<?php
class Vision_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertdata($model)
    {
        $this->db->insert('vision_master', $model);
        return $this->db->insert_id();
    } 

    public function getdetailview()
    {      
        $this->db->select('vision_master.Vision_id,
                          vision_master.Vision,
                          vision_master.Mission,
                          vision_master.fkbranch_id,
                          vision_master.finicial_Year,
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('vision_master');
        $this->db->join('branch_master', 'vision_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'vision_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->order_by('vision_master.Vision_id', 'DESC');
        
        $query = $this->db->get();
        return $query->result();      
    }

    public function getbranch() 
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getActiveYear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    public function getbyid($id)
    {
        $this->db->select("vision_master.*");
        $this->db->where('Vision_id', $id);
        $query = $this->db->get('vision_master');
        return $query->result();
    }

    public function update($model)
    {
        return $sql = $this->db->where('Vision_id', $model['Vision_id'])->update('vision_master', $model); 
    }

    public function getVisionDetailsById($id)
    {
        $this->db->select('vision_master.*, 
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('vision_master');
        $this->db->join('branch_master', 'vision_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'vision_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('vision_master.Vision_id', $id);
        $query = $this->db->get();
        return $query->row();
    }
}