<?php
class YearwiseAmountReport_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // Get all years for dropdown
    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get branches based on user session
    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get institute data
    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    // Get year-wise total amount (filtered by branches if provided)
    public function getYearwiseAmount($years = [], $branches = [])
    {
        $this->db->select('
            finiyear_master.finiYear_id,
            finiyear_master.fini_Label as year,
            SUM(grantrec_master.Amount_rec) as total_amount,
            COUNT(grantrec_master.Grant_id) as grant_count
        ');
        $this->db->from('grantrec_master');
        $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = grantrec_master.finicial_Year', 'left');

        // Filter by years (multi-select)
        if (!empty($years)) {
            $this->db->where_in('grantrec_master.finicial_Year', (array)$years);
        }

        // Filter by branches (multi-select)
        if (!empty($branches)) {
            $this->db->where_in('grantrec_master.fkbranch_id', (array)$branches);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!empty($branchIds)) {
                if (!is_array($branchIds)) {
                    $branchIds = explode(',', $branchIds);
                }
                $this->db->where_in('grantrec_master.fkbranch_id', $branchIds);
            }
        }

        $this->db->group_by('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->order_by('finiyear_master.finiYear_id', 'DESC');

        return $this->db->get()->result();
    }

    // Get detailed grant entries for specific years and branches
    public function getGrantDetails($years = [], $branches = [])
    {
        $this->db->select('
            grantrec_master.Grant_id,
            grantrec_master.Grant_date,
            grantrec_master.description,
            grantrec_master.Amount_rec,
            faculty_master.fac_Fullname,
            branch_master.branch_name,
            granttype_master.granttype_name,
            institute_master.Institu_name,
            finiyear_master.fini_Label,
            grantrec_master.Approval_letter,
            grantrec_master.Other_doc
        ');
        $this->db->from('grantrec_master');
        $this->db->join('faculty_master', 'grantrec_master.fkfac_id = faculty_master.fac_id', 'left');
        $this->db->join('branch_master', 'grantrec_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('granttype_master', 'grantrec_master.fkgranttype_id = granttype_master.granttype_id', 'left');
        $this->db->join('institute_master', 'grantrec_master.institute = institute_master.Institu_id', 'left');
        $this->db->join('finiyear_master', 'grantrec_master.finicial_Year = finiyear_master.finiYear_id', 'left');

        if (!empty($years)) {
            $this->db->where_in('grantrec_master.finicial_Year', (array)$years);
        }
        
        if (!empty($branches)) {
            $this->db->where_in('grantrec_master.fkbranch_id', (array)$branches);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!empty($branchIds)) {
                if (!is_array($branchIds)) {
                    $branchIds = explode(',', $branchIds);
                }
                $this->db->where_in('grantrec_master.fkbranch_id', $branchIds);
            }
        }

        $this->db->order_by('grantrec_master.Grant_date', 'DESC');

        return $this->db->get()->result();
    }

   // Get print headings
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}