<?php
class YearwisePO_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertdata($model)
    {
        $this->db->insert('yearwise_po_master', $model);
        return $this->db->insert_id();
    } 


    

    public function getdetailview()
    {      
        $this->db->select('yearwise_po_master.YearwisePO_id,
                          yearwise_po_master.status,
                          yearwise_po_master.Description,
                          yearwise_po_master.Order_no,
                          yearwise_po_master.fkPO_lable_id,
                          po_lable_master.Po_lable_name,
                          yearwise_po_master.fkbranch_id,
                          yearwise_po_master.finicial_Year,
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('yearwise_po_master');
        $this->db->join('branch_master', 'yearwise_po_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'yearwise_po_master.finicial_Year = finiyear_master.finiYear_id', 'left');
         $this->db->join('po_lable_master', 'yearwise_po_master.fkPO_lable_id = po_lable_master.PO_lable_id', 'left');
        $this->db->order_by('yearwise_po_master.YearwisePO_id', 'DESC');
        
        $query = $this->db->get();
        return $query->result();      
    }


    public function getFilteredData($fkbranch_id = null, $finicial_Year = null)
{
    $this->db->select('yearwise_po_master.YearwisePO_id,
                      yearwise_po_master.status,
                      yearwise_po_master.Description,
                      yearwise_po_master.Order_no,
                      yearwise_po_master.fkPO_lable_id,
                      po_lable_master.Po_lable_name,
                      yearwise_po_master.fkbranch_id,
                      yearwise_po_master.finicial_Year,
                      branch_master.branch_name,
                      finiyear_master.fini_Label');
    $this->db->from('yearwise_po_master');
    $this->db->join('branch_master', 'yearwise_po_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('finiyear_master', 'yearwise_po_master.finicial_Year = finiyear_master.finiYear_id', 'left');
    $this->db->join('po_lable_master', 'yearwise_po_master.fkPO_lable_id = po_lable_master.PO_lable_id', 'left');
    
    // Apply filters if provided
    if (!empty($fkbranch_id)) {
        $this->db->where('yearwise_po_master.fkbranch_id', $fkbranch_id);
    }
    
    if (!empty($finicial_Year)) {
        $this->db->where('yearwise_po_master.finicial_Year', $finicial_Year);
    }
    
    $this->db->order_by('yearwise_po_master.YearwisePO_id', 'DESC');
    
    $query = $this->db->get();
    return $query->result();
}

    public function getlable() 
    {
        $this->db->select('PO_lable_id, Po_lable_name');
        $this->db->from('po_lable_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    } 
    
    public function getbranch() 
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // public function getActiveYear()
    // {
    //     $this->db->select('*');
    //     $this->db->from('finiyear_master');
    //     $this->db->where('Active_Deactive', 1);
    //     return $this->db->get()->row();
    // }

    public function getbyid($id)
    {
        $this->db->select("yearwise_po_master.*");
        $this->db->where('YearwisePO_id', $id);
        $query = $this->db->get('yearwise_po_master');
        return $query->result();
    }

    public function update($model)
    {
        return $sql = $this->db->where('YearwisePO_id', $model['YearwisePO_id'])->update('yearwise_po_master', $model); 
    }

    

   
}