<?php
  class Academic_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
    


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getduration()
     {
      $this->db->select('internduration_master.*,');
      $this->db->from('internduration_master');
       $query = $this->db->get();
        return $query->result();
     }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }



  public function gettype()
     {
      $this->db->select('audit_type.ID,audit_type.type_name,');
      $this->db->from('audit_type');
       $query = $this->db->get();
        return $query->result();
     }

     public function getsem()
     {
      $this->db->select('semester_master.*,');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function geteven()
     {
      $this->db->select('eveodd_typemaster.ID,eveodd_typemaster.Name');
      $this->db->from('eveodd_typemaster');
       $query = $this->db->get();
        return $query->result();
     }


public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $ids = [], $IDs = [], $SemIDs = [], $startdate = null, $enddate = null)
{
    $this->db->select('
        academic_audit.*, 
        branch_master.branch_name,
        eveodd_typemaster.Name, 
semester_master.Sem_Name,audit_type.type_name,');

    $this->db->from('academic_audit');
    $this->db->join('branch_master', 'branch_master.branch_id = academic_audit.fk_branch', 'left');
     $this->db->join('eveodd_typemaster', 'eveodd_typemaster.ID = academic_audit.fk_even', 'left');
       $this->db->join('semester_master', 'academic_audit.fk_sem = semester_master.SemID', 'left');
        $this->db->join('audit_type', 'academic_audit.fk_auditType = audit_type.ID', 'left');

    $this->db->where('academic_audit.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('academic_audit.fk_branch', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

 if (!empty($ids)) {
        $this->db->where_in('academic_audit.fk_even', $ids);
    }

if (!empty($IDs)) {
    $this->db->where_in('academic_audit.fk_auditType', $IDs);
}


if (!empty($SemIDs)) {
    $this->db->where_in('academic_audit.fk_sem', $SemIDs);
}
    
    if (!empty($year_id)) {
    $this->db->where('academic_audit.Financial_Year', $year_id);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('academic_audit.start_date >=', $startdate);
        $this->db->where('academic_audit.start_date <=', $enddate);
    }

    
        $this->db->order_by('academic_audit.start_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

  // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(academic_audit.audit_id) as count")
        ->from("academic_audit")
        ->join("finiyear_master", "finiyear_master.finiYear_id = academic_audit.Financial_Year")
        ->group_by("academic_audit.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}


 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(academic_audit.audit_id) as count")
        ->from("academic_audit")
        ->join("finiyear_master", "finiyear_master.finiYear_id = academic_audit.Financial_Year")
        ->where("academic_audit.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('academic_audit.fk_branch', (array)$branches);
    }
  else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('academic_audit.fk_branch', explode(',', $branchIds));
    }
}
 
    $this->db->group_by("academic_audit.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("academic_audit.audit_id, academic_audit.details, finiyear_master.fini_Label as year,
    academic_audit.start_date, academic_audit.document, academic_audit.fk_even, eveodd_typemaster.Name,              
semester_master.Sem_Name,audit_type.type_name,branch_master.branch_name,")
        ->from("academic_audit")
        ->join("finiyear_master", "finiyear_master.finiYear_id = academic_audit.Financial_Year")
        ->join('semester_master', 'academic_audit.fk_sem = semester_master.SemID', 'left')
        ->join('audit_type', 'academic_audit.fk_auditType = audit_type.ID', 'left')
       ->join('branch_master', 'branch_master.branch_id = academic_audit.fk_branch', 'left')
       ->join('eveodd_typemaster', 'eveodd_typemaster.ID = academic_audit.fk_even', 'left')
        ->where("academic_audit.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('academic_audit.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('academic_audit.fk_branch', explode(',', $branchIds));
    }
}
 
    return $this->db->get()->result_array();
}

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(academic_audit.audit_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('academic_audit', 'branch_master.branch_id = academic_audit.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('academic_audit.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('academic_audit.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('academic_audit.details,
                       academic_audit.audit_id,
                       academic_audit.fk_branch,
                       academic_audit.start_date,
                       academic_audit.document,
semester_master.Sem_Name,audit_type.type_name,
                       branch_master.branch_name, 
                       academic_audit.fk_even,
                       eveodd_typemaster.Name,                     
                        ');
    $this->db->from('academic_audit');
    $this->db->join('branch_master', 'branch_master.branch_id = academic_audit.fk_branch', 'left');
 $this->db->join('semester_master', 'academic_audit.fk_sem = semester_master.SemID', 'left');
        $this->db->join('audit_type', 'academic_audit.fk_auditType = audit_type.ID', 'left');
$this->db->join('eveodd_typemaster', 'eveodd_typemaster.ID = academic_audit.fk_even', 'left');
   if (is_array($branch_id)) {
    $this->db->where_in('academic_audit.fk_branch', $branch_id);
} else {
    $this->db->where('academic_audit.fk_branch', $branch_id);
}
 

    if (!empty($institu)) {
        $this->db->where('academic_audit.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('academic_audit.Financial_Year', $year);
    // }

  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('academic_audit.Financial_Year', $year);
    } else {
        $this->db->where('academic_audit.Financial_Year', $year);
    }
}
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("academic_audit.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.audit_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('academic_audit sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.audit_id) as count");
    $this->db->from("academic_audit sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
    
public function getStudentsByMeetId($fk_auditID)
{
    return $this->db->select('member_name, designation, remark,	mobile_no, email, document_2,photo')
                    ->from('audit_member')
                    ->where('fk_auditID', $fk_auditID)
                    ->get()
                    ->result_array();
}
 

}