<?php
  class Academicau_institutereport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
    


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getduration()
     {
      $this->db->select('internduration_master.*,');
      $this->db->from('internduration_master');
       $query = $this->db->get();
        return $query->result();
     }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }



  public function gettype()
     {
      $this->db->select('audit_type.ID,audit_type.type_name,');
      $this->db->from('audit_type');
       $query = $this->db->get();
        return $query->result();
     }

     public function getsem()
     {
      $this->db->select('semester_master.*,');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function geteven()
     {
      $this->db->select('eveodd_typemaster.ID,eveodd_typemaster.Name');
      $this->db->from('eveodd_typemaster');
       $query = $this->db->get();
        return $query->result();
     }

public function getDataByInstitute($institute_id,  $year_id, $ids = [], $IDs = [], $SemIDs = [], $startdate = null, $enddate = null)
{
    $this->db->select('
        academic_auditinstitute.*, 
        eveodd_typemaster.Name, 
semester_master.Sem_Name,audit_type.type_name,');

    $this->db->from('academic_auditinstitute');
    $this->db->join('eveodd_typemaster', 'eveodd_typemaster.ID = academic_auditinstitute.fk_even', 'left');
       $this->db->join('semester_master', 'academic_auditinstitute.fk_sem = semester_master.SemID', 'left');
        $this->db->join('audit_type', 'academic_auditinstitute.fk_auditType = audit_type.ID', 'left');

    $this->db->where('academic_auditinstitute.Institute', $institute_id);

    if (!empty($ids)) {
        $this->db->where_in('academic_auditinstitute.fk_even', $ids);
    }
    

if (!empty($IDs)) {
    $this->db->where_in('academic_auditinstitute.fk_auditType', $IDs);
}


if (!empty($SemIDs)) {
    $this->db->where_in('academic_auditinstitute.fk_sem', $SemIDs);
}
    
    if (!empty($year_id)) {
    $this->db->where('academic_auditinstitute.Financial_Year', $year_id);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('academic_auditinstitute.start_date >=', $startdate);
        $this->db->where('academic_auditinstitute.start_date <=', $enddate);
    }

    
        $this->db->order_by('academic_auditinstitute.start_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

  // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(academic_auditinstitute.audit_id) as count")
        ->from("academic_auditinstitute")
        ->join("finiyear_master", "finiyear_master.finiYear_id = academic_auditinstitute.Financial_Year")
        ->group_by("academic_auditinstitute.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}


 
public function getSingleYearData($yearId)  // ✅ Remove $branches parameter
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(academic_auditinstitute.audit_id) as count")
        ->from("academic_auditinstitute")
        ->join("finiyear_master", "finiyear_master.finiYear_id = academic_auditinstitute.Financial_Year")
        ->where("academic_auditinstitute.Financial_Year", $yearId);
 
    // ✅ Keep session-based branch filter for data security
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('academic_auditinstitute.fk_branch', explode(',', $branchIds));
    }
 
    $this->db->group_by("academic_auditinstitute.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId)  // ✅ Remove $branches parameter
{
    $this->db->select("academic_auditinstitute.audit_id, academic_auditinstitute.details, finiyear_master.fini_Label as year,
    academic_auditinstitute.start_date, academic_auditinstitute.document,                
    semester_master.Sem_Name, audit_type.type_name, branch_master.branch_name")
        ->from("academic_auditinstitute")
        ->join("finiyear_master", "finiyear_master.finiYear_id = academic_auditinstitute.Financial_Year")
        ->join('semester_master', 'academic_auditinstitute.fk_sem = semester_master.SemID', 'left')
        ->join('audit_type', 'academic_auditinstitute.fk_auditType = audit_type.ID', 'left')
        ->join('branch_master', 'branch_master.branch_id = academic_auditinstitute.fk_branch', 'left')
        ->where("academic_auditinstitute.Financial_Year", $yearId);
 
 
    return $this->db->get()->result_array();
}

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(academic_auditinstitute.audit_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('academic_auditinstitute', 'branch_master.branch_id = academic_auditinstitute.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('academic_auditinstitute.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('academic_auditinstitute.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('academic_auditinstitute.details,
                       academic_auditinstitute.audit_id,
                       academic_auditinstitute.fk_branch,
                       academic_auditinstitute.start_date,
                       academic_auditinstitute.document,
semester_master.Sem_Name,audit_type.type_name,
                       branch_master.branch_name,                      
                        ');
    $this->db->from('academic_auditinstitute');
    $this->db->join('branch_master', 'branch_master.branch_id = academic_auditinstitute.fk_branch', 'left');
 $this->db->join('semester_master', 'academic_auditinstitute.fk_sem = semester_master.SemID', 'left');
        $this->db->join('audit_type', 'academic_auditinstitute.fk_auditType = audit_type.ID', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('academic_auditinstitute.fk_branch', $branch_id);
} else {
    $this->db->where('academic_auditinstitute.fk_branch', $branch_id);
}
 

    if (!empty($institu)) {
        $this->db->where('academic_auditinstitute.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('academic_auditinstitute.Financial_Year', $year);
    // }

  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('academic_auditinstitute.Financial_Year', $year);
    } else {
        $this->db->where('academic_auditinstitute.Financial_Year', $year);
    }
}
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("academic_auditinstitute.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $years = [])  // ✅ Remove $branches parameter
{
    $response = [];
 
    // ❌ REMOVE ENTIRE BRANCHWISE COUNT SECTION (Line 1-25)
    /*
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.audit_id) as student_count');
    $this->db->from('branch_master b');
    ... entire branch code ...
    $response['branchData'] = $this->db->get()->result();
    */
 
    // --- Yearwise Count ONLY ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.audit_id) as count");
    $this->db->from("academic_auditinstitute sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.Institute', $institu);
    }
    
    

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
    
public function getStudentsByMeetId($fk_auditID)
{
    return $this->db->select('member_name, designation, remark, mobile_no, email, document_2,photo')
                    ->from('audit_memberinstitute')
                    ->where('fk_auditID', $fk_auditID)
                    ->get()
                    ->result_array();
}
 

}