<?php
  class AnnualSports_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
         public function insertdata($model)
	{
	 $this->db->insert('annualsports_master',$model);
     return $this->db->insert_id();
			//return $sql->result();
	} 
public function getdetailview()
{      
    $this->db->select('annualsports_master.*, sports_levels.level_name,sports_master.sport_name');
    $this->db->from('annualsports_master');
    $this->db->join('sports_levels', 'annualsports_master.fkSportsLevel_id = sports_levels.level_id', 'left');
    $this->db->join('sports_master', 'annualsports_master.fkSportsName_id = sports_master.sport_id', 'left');
    $this->db->order_by('annualsports_master.Annual_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}
      public function get_all_Branch()
{
    return $this->db->get('branch_master')->result();
}

      public function get_all_Sports()
{
    return $this->db->get('sports_levels')->result();
}

      public function get_all_Name()
{
    return $this->db->get('sports_master')->result();
}

public function get_students_by_meet($Annual_id)
{
    $this->db->select('annual_sports_students.*, 
                       branch_master.branch_name, 
                       sports_master.sport_name, 
                       finiyear_master.fini_Label as year_label');
    $this->db->from('annual_sports_students');
    $this->db->join('branch_master', 'branch_master.branch_id = annual_sports_students.fkbranch_id', 'left');
    $this->db->join('sports_master', 'sports_master.sport_id = annual_sports_students.fkSportsName_id', 'left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = annual_sports_students.FiniYear', 'left');
    $this->db->where('annual_sports_students.Annual_id', $Annual_id);

    $query = $this->db->get();
    return $query->result();
}
   // Get gallery by club id
    public function getClubGallery($Annual_id) {
        return $this->db
            ->select('*')
            ->from('annualsports_photos')
            ->where('Annual_id', $Annual_id)
            ->get()
            ->result();
    }
// public function get_students_by_meet($Annual_id)
// {
//     $this->db->where('Annual_id', $Annual_id);
//     $query = $this->db->get('annual_sports_students');
//     return $query->result();
// }


      public function getbyid($id)
		{
		  $this->db->select("annualsports_master.*,");
	    $this->db->where('Annual_id',$id);
      $query = $this->db->get('annualsports_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('Annual_id',$model['Annual_id'])->update('annualsports_master',$model); 
    } 


        
      public function get_all_institute()
{
    return $this->db->get('institute_master')->result();
}
public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }

     
public function getDataByInstitute($institute_id, $StartDate = null, $DateComp = null, $sportsLevels = [], $sportsNames = [])
{
    $this->db->select('annualsports_master.*, 
                       sports_levels.level_name,
                       sports_master.sport_name,
                       institute_master.Institu_name');
    $this->db->from('annualsports_master');
    $this->db->join('sports_levels', 'annualsports_master.fkSportsLevel_id = sports_levels.level_id', 'left');
    $this->db->join('sports_master', 'annualsports_master.fkSportsName_id = sports_master.sport_id', 'left');
    $this->db->join('institute_master', 'annualsports_master.Institute_id = institute_master.Institu_id', 'left');

    // ✅ filter by institute
    if (!empty($institute_id)) {
        $this->db->where('annualsports_master.Institute_id', $institute_id);
    }

    // ✅ filter by Date
    if (!empty($StartDate) && !empty($DateComp)) {
        $this->db->where('annualsports_master.StartDate >=', $StartDate);
        $this->db->where('annualsports_master.DateComp <=', $DateComp);
    }

    // ✅ filter by multiselect Sports Level
    if (!empty($sportsLevels)) {
        $this->db->where_in('annualsports_master.fkSportsLevel_id', $sportsLevels);
    }

    // ✅ filter by multiselect Sports Name
    if (!empty($sportsNames)) {
        $this->db->where_in('annualsports_master.fkSportsName_id', $sportsNames);
    }

    $this->db->order_by('annualsports_master.Annual_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}


 public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}



    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("annual_sports_students")
        ->join("finiyear_master", "finiyear_master.finiYear_id = annual_sports_students.FiniYear")
        ->group_by("annual_sports_students.FiniYear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId)
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("annual_sports_students")
        ->join("finiyear_master", "finiyear_master.finiYear_id = annual_sports_students.FiniYear")
        ->where("annual_sports_students.FiniYear", $yearId)
        ->group_by("annual_sports_students.FiniYear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 public function getYearwiseTypes($yearId, $institu = null, $startDate = null, $endDate = null)
{
    $this->db->select("annual_sports_students.Annual_id, annual_sports_students.fkSportsName_id, sports_master.sport_name, finiyear_master.fini_Label as year");
    $this->db->from("annual_sports_students");
    $this->db->join("finiyear_master", "finiyear_master.finiYear_id = annual_sports_students.FiniYear");
    // $this->db->join("sports_master", "annualsports_master.fkSportsName_id = sports_master.sport_id");
    $this->db->join("sports_master", "annual_sports_students.fkSportsName_id = sports_master.sport_id");
    $this->db->where("annual_sports_students.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where("annual_sports_students.fkInstitName_id", $institu);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("annual_sports_students.created_at >=", $startDate);
        $this->db->where("annual_sports_students.created_at <=", $endDate);
    }

    return $this->db->get()->result_array();
}



    
 public function getCombinedData($institu = null, $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Annual_id) as count");
    $this->db->from("annual_sports_students sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.FiniYear");

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.FiniYear', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}

}