<?php
class BudgetutiReport_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Main table data - budgetuti_main_master
    public function getFilteredData($institu, $branches = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('budgetuti_main_master.budgetmain_id,
                           budgetuti_main_master.fkbranch_id,
                           branch_master.branch_name,
                           budgetuti_main_master.budgetuti_date,
                           budgetuti_main_master.Desscription_main,    
                           budgetuti_main_master.excel_file,       
                           budgetuti_main_master.finicial_Year,
                           finiyear_master.fini_Label');
        $this->db->from('budgetuti_main_master');
        $this->db->join('branch_master', 'budgetuti_main_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'budgetuti_main_master.finicial_Year = finiyear_master.finiYear_id', 'left');

        // Institute filter
        if (!empty($institu)) {
            $this->db->where('budgetuti_main_master.institute', $institu);
        }

        // Branch filter (multiple)
        if (!empty($branches)) {
            if (is_array($branches)) {
                $this->db->where_in('budgetuti_main_master.fkbranch_id', $branches);
            } else {
                $this->db->where('budgetuti_main_master.fkbranch_id', $branches);
            }
        }
// new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

        // Year filter
        if (!empty($year) && $year != 0) {
            $this->db->where('budgetuti_main_master.finicial_Year', $year);
        }

        // Date range filter
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(budgetuti_main_master.budgetuti_date) BETWEEN '$startDate' AND '$endDate'");
        } elseif (!empty($startDate)) {
            $this->db->where("DATE(budgetuti_main_master.budgetuti_date) >= '$startDate'");
        } elseif (!empty($endDate)) {
            $this->db->where("DATE(budgetuti_main_master.budgetuti_date) <= '$endDate'");
        }

        $this->db->order_by('budgetuti_main_master.budgetmain_id', 'DESC');
        return $this->db->get()->result();
    }

    // Get budgetutilazation_master details for modal (view button)
    public function getBudgetUtilizationDetails($fkbudgetmain_id)
    {
        $this->db->select('budgetutilazation_master.budgetuti_id,
                           budgetutilazation_master.fkallocationtype_id,
                           allocationtype_master.name as allocation_type,
                           budgetutilazation_master.fkexpentype_id,
                           expensivetype_master.expen_name as expense_type,
                           budgetutilazation_master.expensive_date,
                           budgetutilazation_master.amount,
                           budgetutilazation_master.invioce,
                           budgetutilazation_master.desscription,
                           budgetutilazation_master.fkbudgetmain_id
                           ');
        $this->db->from('budgetutilazation_master');
        $this->db->join('allocationtype_master', 'budgetutilazation_master.fkallocationtype_id = allocationtype_master.allocationtype_id', 'left');
        $this->db->join('expensivetype_master', 'budgetutilazation_master.fkexpentype_id = expensivetype_master.expentype_id', 'left');
        $this->db->where('budgetutilazation_master.fkbudgetmain_id', $fkbudgetmain_id);
        $this->db->where('budgetutilazation_master.is_active', 1);
        $this->db->order_by('budgetutilazation_master.expensive_date', 'DESC');
        
        return $this->db->get()->result();
    }
  
    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end

        $query = $this->db->get();
        return $query->result();
    }
 
    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    } 

    public function getAllYearsData()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("budgetuti_main_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = budgetuti_main_master.finicial_Year")
            ->group_by("budgetuti_main_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }
 
    public function getSingleYearData($yearId, $branches = [])
    {
        $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("budgetuti_main_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = budgetuti_main_master.finicial_Year")
            ->where("budgetuti_main_master.finicial_Year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('budgetuti_main_master.fkbranch_id', (array)$branches);
        }
else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('budgetuti_main_master.fkbranch_id', explode(',', $branchIds));
    }
}

        $this->db->group_by("budgetuti_main_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
    }
 
    public function getYearwiseTypes($yearId, $branches = [])
    {
        $this->db->select("budgetuti_main_master.budgetmain_id,
                           budgetuti_main_master.fkbranch_id,
                           branch_master.branch_name,
                           budgetuti_main_master.budgetuti_date,
                           budgetuti_main_master.Desscription_main,        
                           budgetuti_main_master.excel_file,       
                           finiyear_master.fini_Label as year")
            ->from("budgetuti_main_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = budgetuti_main_master.finicial_Year")
            ->join('branch_master', 'budgetuti_main_master.fkbranch_id = branch_master.branch_id', 'left')
            ->where("budgetuti_main_master.finicial_Year", $yearId);
        
        if (!empty($branches)) {
            $this->db->where_in('budgetuti_main_master.fkbranch_id', (array)$branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('budgetuti_main_master.fkbranch_id', explode(',', $branchIds));
    }
}

        return $this->db->get()->result_array();
    }
 
    public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('branch_master.branch_id,
                           branch_master.branch_name,
                           COUNT(budgetuti_main_master.budgetmain_id) as Budget_count');
        $this->db->from('branch_master');
        $this->db->join('budgetuti_main_master', 'branch_master.branch_id = budgetuti_main_master.fkbranch_id', 'left');
     
        if (!empty($institu)) {
            $this->db->where('budgetuti_main_master.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('branch_master.branch_id', (array)$branches);
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
        if (!empty($year) && $year != 0) {
            $this->db->where('budgetuti_main_master.finicial_Year', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(budgetuti_main_master.budgetuti_date) BETWEEN '$startDate' AND '$endDate'");
        }
     
        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');
     
        return $this->db->get()->result();
    }
 
    public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('budgetuti_main_master.budgetmain_id,
                           budgetuti_main_master.fkbranch_id,
                           branch_master.branch_name,
                           budgetuti_main_master.budgetuti_date,
                           budgetuti_main_master.Desscription_main,       
                           budgetuti_main_master.excel_file');
        $this->db->from('budgetuti_main_master');
        $this->db->join('branch_master', 'branch_master.branch_id = budgetuti_main_master.fkbranch_id', 'left');
     
        if (is_array($branch_id)) {
            $this->db->where_in('budgetuti_main_master.fkbranch_id', $branch_id);
        } else {
            $this->db->where('budgetuti_main_master.fkbranch_id', $branch_id);
        }
     
        if (!empty($institu)) {
            $this->db->where('budgetuti_main_master.institute', $institu);
        }
        
        if (!empty($year)) {
            if (is_array($year)) {
                $this->db->where_in('budgetuti_main_master.finicial_Year', $year);
            } else {
                $this->db->where('budgetuti_main_master.finicial_Year', $year);
            }
        }
        
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(budgetuti_main_master.budgetuti_date) BETWEEN '$startDate' AND '$endDate'");
        }
     
        return $this->db->get()->result();
    }
 
    public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
    {
        $response = [];
     
        // Branchwise Count
        $this->db->select('b.branch_id, b.branch_name, COUNT(sr.budgetmain_id) as Budget_count');
        $this->db->from('branch_master b');
        $this->db->join('budgetuti_main_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
     
        if (!empty($institu)) {
            $this->db->where('sr.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('b.branch_id', (array)$branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}

        if (!empty($years)) {
            $this->db->where_in('sr.finicial_Year', (array)$years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(sr.budgetuti_date) BETWEEN '$startDate' AND '$endDate'");
        }
     
        $this->db->group_by('b.branch_id, b.branch_name');
        $this->db->order_by('b.branch_name', 'ASC');
        $response['branchData'] = $this->db->get()->result();
     
        // Yearwise Count
        $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.budgetmain_id) as count");
        $this->db->from("budgetuti_main_master sr");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
     
        if (!empty($institu)) {
            $this->db->where('sr.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('sr.fkbranch_id', (array)$branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}

        if (!empty($years)) {
            $this->db->where_in('sr.finicial_Year', (array)$years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(sr.budgetuti_date) BETWEEN '$startDate' AND '$endDate'");
        }
     
        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();
     
        return $response;
    }
}