<?php
class Chapter_report_model extends CI_Model
{
    public function __construct()
    {
        $this->load->database();
    }

    // ============================================================
    // BASIC GETTERS
    // ============================================================

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_Faculty() {
        return $this->db->get('faculty_master')->result();
    }

    public function get_all_Student() {
        return $this->db->get('student_reg')->result();
    }

    public function get_all_Branch() {
        return $this->db->get('branch_master')->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_InduType()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_institute()
    {
        return $this->db->get('institute_master')->result();
    }

    public function getAllClubNames()
    {
        return $this->db->select('club_id, NameClub')
            ->from('Chapterclub_master')
            ->order_by('NameClub', 'ASC')
            ->get()
            ->result();
    }

    // ============================================================
    // INSERT / UPDATE / DELETE OPERATIONS
    // ============================================================

    public function insertdata($model) {
        return $this->db->insert('Chapterclub_master', $model);
    }

    public function update($model, $club_id) {
        return $this->db->where('club_id', $club_id)
                        ->update('Chapterclub_master', $model);
    }

    public function getbyid($id) {
        return $this->db
            ->select("Chapterclub_master.*")
            ->where('club_id', $id)
            ->get('Chapterclub_master')
            ->result();
    }

    public function getdetailview() {
        $this->db->select('Chapterclub_master.*, finiyear_master.fini_Label, faculty_master.fac_Fullname, student_reg.FullName');
        $this->db->from('Chapterclub_master');
        $this->db->join('finiyear_master', 'Chapterclub_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->join('faculty_master', 'Chapterclub_master.fkFacCo_id = faculty_master.fac_id', 'left');
        $this->db->join('student_reg', 'Chapterclub_master.fkStudCo_id = student_reg.Student_id', 'left');
        $this->db->order_by('Chapterclub_master.club_id', 'DESC');
        return $this->db->get()->result();
    }

    // ============================================================
    // STUDENT LIST OPERATIONS
    // ============================================================

    public function insertStudents($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('student_list', $data);
        }
        return false;
    }

    public function get_students_by_club($club_id)
    {
        $this->db->where('club_id', $club_id);
        $query = $this->db->get('student_list');
        return $query->result();
    }

    public function deleteStudentsByClub($club_id) {
        return $this->db->where('club_id', $club_id)
                        ->delete('student_list');
    }

    // ============================================================
    // ACTIVITIES OPERATIONS
    // ============================================================

    public function insertActivities($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('activities', $data);
        }
        return false;
    }

    public function get_students_by_activity($club_id)
    {
        $this->db->where('club_id', $club_id);
        $query = $this->db->get('activities');
        return $query->result();
    }

    public function getActivitiesByClub($club_id) {
        return $this->db->where('club_id', $club_id)
                        ->get('activities')
                        ->result();
    }

    public function deleteActivitiesByClub($club_id) {
        return $this->db->where('club_id', $club_id)
                        ->delete('activities');
    }

    // ============================================================
    // FACULTY LIST OPERATIONS
    // ============================================================

    public function insertFacultylistxcel($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('facultylistxcel', $data);
        }
        return false;
    }

    public function getFacultylistxcelByClub($club_id) {
        return $this->db->where('club_id', $club_id)
                        ->get('facultylistxcel')
                        ->result();
    }

    public function deleteFacultylistxcelByClub($club_id) {
        return $this->db->where('club_id', $club_id)
                        ->delete('facultylistxcel');
    }

    // ============================================================
    // GALLERY OPERATIONS
    // ============================================================

    public function getClubGallery($club_id) {
        return $this->db
            ->select('*')
            ->from('Chapter_gallery')
            ->where('club_id', $club_id)
            ->get()
            ->result();
    }

    public function insertMultiplePhotos($club_id, $file_paths) {
        if (empty($file_paths)) return false;
        $insert_data = [];
        foreach ($file_paths as $path) {
            $insert_data[] = [
                'club_id'   => $club_id,
                'file_path' => $path
            ];
        }
        return $this->db->insert_batch('Chapter_gallery', $insert_data);
    }

    public function deleteExistingPhotos($club_id, $removed_photos_array)
    {
        if (!empty($removed_photos_array)) {
            $this->db->where('club_id', $club_id);
            $this->db->where_in('file_path', $removed_photos_array);
            $this->db->delete('Chapter_gallery');

            foreach ($removed_photos_array as $file_path) {
                $full_path = FCPATH . $file_path;
                if (file_exists($full_path)) {
                    unlink($full_path);
                }
            }
        }
    }

    // ============================================================
    // FULL CLUB DETAILS
    // ============================================================

    public function getClubFullDetails($club_id) {
        $data = [];

        $data['club'] = $this->db
            ->select('Chapterclub_master.*, branch_master.branch_name, faculty_master.fac_Fullname, student_reg.FullName')
            ->from('Chapterclub_master')
            ->join('branch_master', 'Chapterclub_master.fkbranch_id = branch_master.branch_id', 'left')
            ->join('faculty_master', 'Chapterclub_master.fkFacCo_id = faculty_master.fac_id', 'left')
            ->join('student_reg', 'Chapterclub_master.fkStudCo_id = student_reg.Student_id', 'left')
            ->where('Chapterclub_master.club_id', $club_id)
            ->get()
            ->row();

        $data['students'] = $this->get_students_by_club($club_id);
        $data['activities'] = $this->getActivitiesByClub($club_id);
        $data['facultylistxcel'] = $this->getFacultylistxcelByClub($club_id);
        $data['gallery'] = $this->getClubGallery($club_id);

        return $data;
    }

    // ============================================================
    // REPORT DATA BY INSTITUTE WITH FILTERS
    // ============================================================

    public function getDataByInstitute($institute_id, $startdate = null, $enddate = null, $year = null, $branches = [], $faculties = [], $students = [])
    {
        $this->db->select('Chapterclub_master.club_id,
                           Chapterclub_master.NameClub,
                           Chapterclub_master.LinkDetails,
                           Chapterclub_master.Acheivment,
                           Chapterclub_master.StartDate,
                           branch_master.branch_name, 
                           faculty_master.fac_Fullname as faculty_name, 
                           student_reg.FullName as student_name,
                           institute_master.Institu_name,
                           finiyear_master.fini_Label');
        $this->db->from('Chapterclub_master');
        $this->db->join('branch_master', 'Chapterclub_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('faculty_master', 'Chapterclub_master.fkFacCo_id = faculty_master.fac_id', 'left');
        $this->db->join('student_reg', 'Chapterclub_master.fkStudCo_id = student_reg.Student_id', 'left');
        $this->db->join('finiyear_master', 'Chapterclub_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->join('institute_master', 'Chapterclub_master.InstituteId = institute_master.Institu_id', 'left');

        // Institute filter
        if (!empty($institute_id)) {
            $this->db->where('Chapterclub_master.InstituteId', $institute_id);
        }

        // Year filter
        if (!empty($year) && $year != '0') {
            $this->db->where('Chapterclub_master.FiniYear', $year);
        }

        // Date range filter
        if (!empty($startdate) && !empty($enddate)) {
            $this->db->where('Chapterclub_master.StartDate >=', $startdate);
            $this->db->where('Chapterclub_master.StartDate <=', $enddate);
        }

        // Branch filter (multi-select)
        if (!empty($branches) && is_array($branches)) {
            $this->db->where_in('Chapterclub_master.fkbranch_id', $branches);
        }

        // Faculty coordinator filter (single select)
        if (!empty($faculties)) {
            $this->db->where('Chapterclub_master.fkFacCo_id', $faculties);
        }

        // Student coordinator filter (multi-select)
        if (!empty($students) && is_array($students)) {
            $this->db->where_in('Chapterclub_master.fkStudCo_id', $students);
        }

        $this->db->order_by('Chapterclub_master.club_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // ============================================================
    // PRINT HEADINGS
    // ============================================================

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

    // ============================================================
    // YEARWISE DATA FOR CHARTS
    // ============================================================

    public function getAllYearsData()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(Chapterclub_master.club_id) as count")
            ->from("Chapterclub_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = Chapterclub_master.FiniYear")
            ->group_by("Chapterclub_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }

    public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
    {
        $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(Chapterclub_master.club_id) as count")
            ->from("Chapterclub_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = Chapterclub_master.FiniYear")
            ->where("Chapterclub_master.FiniYear", $yearId);

        if (!empty($institu)) {
            $this->db->where('Chapterclub_master.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('Chapterclub_master.fkbranch_id', (array) $branches);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("Chapterclub_master.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by("Chapterclub_master.FiniYear, fini_Label, finiyear_master.finiYear_id");

        return $this->db->get()->result_array();
    }

    public function getYearwiseTypes($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
    {
        $this->db->select("Chapterclub_master.NameClub,
                           Chapterclub_master.club_id,
                           finiyear_master.fini_Label as year,
                           branch_master.branch_name")
            ->from("Chapterclub_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = Chapterclub_master.FiniYear")
            ->join('branch_master', 'branch_master.branch_id = Chapterclub_master.fkbranch_id', 'left')
            ->where("Chapterclub_master.FiniYear", $yearId);

        if (!empty($institu)) {
            $this->db->where('Chapterclub_master.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('Chapterclub_master.fkbranch_id', (array) $branches);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("Chapterclub_master.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        return $this->db->get()->result_array();
    }

    // ============================================================
    // BRANCHWISE DATA FOR CHARTS
    // ============================================================

    public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('branch_master.branch_id,
                           branch_master.branch_name,
                           COUNT(Chapterclub_master.club_id) as student_count');
        $this->db->from('branch_master');
        $this->db->join('Chapterclub_master', 'branch_master.branch_id = Chapterclub_master.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('Chapterclub_master.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('branch_master.branch_id', (array) $branches);
        }
        if (!empty($year) && $year != 0) {
            $this->db->where('Chapterclub_master.FiniYear', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("Chapterclub_master.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');

        return $this->db->get()->result();
    }

    public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('Chapterclub_master.NameClub,
                           Chapterclub_master.club_id,
                           Chapterclub_master.fkbranch_id,
                           branch_master.branch_name');
        $this->db->from('Chapterclub_master');
        $this->db->join('branch_master', 'branch_master.branch_id = Chapterclub_master.fkbranch_id', 'left');

        if (is_array($branch_id)) {
            $this->db->where_in('Chapterclub_master.fkbranch_id', $branch_id);
        } else {
            $this->db->where('Chapterclub_master.fkbranch_id', $branch_id);
        }

        if (!empty($institu)) {
            $this->db->where('Chapterclub_master.InstituteId', $institu);
        }
        if (!empty($year)) {
            if (is_array($year)) {
                $this->db->where_in('Chapterclub_master.FiniYear', $year);
            } else {
                $this->db->where('Chapterclub_master.FiniYear', $year);
            }
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("Chapterclub_master.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        return $this->db->get()->result();
    }

    // ============================================================
    // COMBINED DATA FOR CHARTS
    // ============================================================

    public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
    {
        $response = [];

        // Branchwise Count
        $this->db->select('b.branch_id, b.branch_name, COUNT(sc.club_id) as student_count');
        $this->db->from('branch_master b');
        $this->db->join('Chapterclub_master sc', 'b.branch_id = sc.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('sc.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('b.branch_id', (array) $branches);
        }
        if (!empty($years)) {
            $this->db->where_in('sc.FiniYear', (array) $years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("sc.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by('b.branch_id, b.branch_name');
        $this->db->order_by('b.branch_name', 'ASC');
        $response['branchData'] = $this->db->get()->result();

        // Yearwise Count
        $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sc.club_id) as count");
        $this->db->from("Chapterclub_master sc");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = sc.FiniYear");

        if (!empty($institu)) {
            $this->db->where('sc.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('sc.fkbranch_id', (array) $branches);
        }
        if (!empty($years)) {
            $this->db->where_in('sc.FiniYear', (array) $years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("sc.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();

        return $response;
    }

    // ============================================================
    // FACULTY AND STUDENT BY BRANCH
    // ============================================================

    public function getFacultyByBranch($branch_id) {
        return $this->db->where('fkbranch_id', $branch_id)
                        ->get('faculty_master')
                        ->result();
    }

    public function getStudentsByBranch($branch_id) {
        return $this->db->where('fkbranch_id', $branch_id)
                        ->get('student_reg')
                        ->result();
    }
}