<?php
  class Conf_cultReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('conf_culturalchild',$model);
			//return $sql->result();
	} 

  public function getevent()
     {
      $this->db->select('event_master.*');
      $this->db->from('event_master');
       $query = $this->db->get();
        return $query->result();
     }

    

     public function getinstitu()
     {
      $this->db->select('institute_master.*');
    $this->db->from('institute_master');
   $query = $this->db->get();
        return $query->result();
     }

        

      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


     

     public function getfk_eventTypes()
{
    $this->db->select('fk_eventType');
    $this->db->from('conf_culturalchild');
    $this->db->group_by('fk_eventType');
    $this->db->order_by('fk_eventType', 'ASC'); // optional sorting
    return $this->db->get()->result();
}

    public function getDataByInstitute($year_id, $institute_id = [], $event_types = [], $startdate = null, $enddate = null, ) {
        $this->db->select('
            conf_culturalchild.*, 
            event_master.event_type,
        ');
        $this->db->from('conf_culturalchild');
               $this->db->join('event_master', 'event_master.event_id = conf_culturalchild.fk_eventType', 'left');
        $this->db->order_by('conf_culturalchild.cult_id','DESC');
        // $this->db->where('conf_culturalchild.Institute', $institute_id);
 if (!empty($institute_id)) {
            $this->db->where('conf_culturalchild.Institute', $institute_id);
        }

        if (!empty($year_id)) {
            $this->db->where('conf_culturalchild.Financial_year', $year_id);
        }

        
        if (!empty($event_types)) {
            $this->db->where_in('conf_culturalchild.fk_eventType', $event_types);
        }

        if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('conf_culturalchild.event_date >=', $startdate);
        $this->db->where('conf_culturalchild.event_date <=', $enddate);
    }

 $this->db->order_by('conf_culturalchild.event_date','DESC');
        return $this->db->get()->result();
    }


// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

      // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("conf_culturalchild")
        ->join("finiyear_master", "finiyear_master.finiYear_id = conf_culturalchild.Financial_Year")
        ->group_by("conf_culturalchild.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("conf_culturalchild")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = conf_culturalchild.Financial_Year")
//         ->where("conf_culturalchild.Financial_Year", $yearId)
//         ->group_by("conf_culturalchild.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("conf_culturalchild.ID, conf_culturalchild.fk_student, finiyear_master.fini_Label as year, student_reg.FullName,")
//         ->from("conf_culturalchild")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = conf_culturalchild.Financial_Year")
//         ->join('student_reg', 'student_reg.Student_id = conf_culturalchild.fk_student')
//         ->where("conf_culturalchild.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 

public function getSingleYearData($yearId, $events = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("conf_culturalchild")
        ->join("finiyear_master", "finiyear_master.finiYear_id = conf_culturalchild.Financial_Year")
        ->where("conf_culturalchild.Financial_Year", $yearId);
 
    
    if (!empty($events)) {
        $this->db->where_in('conf_culturalchild.fk_eventType', (array)$events);
    }
  
 
    $this->db->group_by("conf_culturalchild.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $events = [],)
{
    $this->db->select("conf_culturalchild.cult_id, conf_culturalchild.Guest_name, finiyear_master.fini_Label as year,event_master.event_type,
    conf_culturalchild.event_name,conf_culturalchild.event_date,conf_culturalchild.guest_details,conf_culturalchild.document_1,conf_culturalchild.document_2,conf_culturalchild.event_details,
    conf_culturalchild.document_3,conf_culturalchild.event_date")
        ->from("conf_culturalchild")
        ->join("finiyear_master", "finiyear_master.finiYear_id = conf_culturalchild.Financial_Year")
        ->join('event_master', 'event_master.event_id = conf_culturalchild.fk_eventType', 'left')
        ->where("conf_culturalchild.Financial_Year", $yearId);
 
    
    if (!empty($events)) {
        $this->db->where_in('conf_culturalchild.fk_eventType', (array)$events);
    }
    
 
    return $this->db->get()->result_array();
}
 

// public function getCombinedData($institu = null, $events = [], $years = [])
// {
//     $response = [];

//     // --- 1. Eventwise Count ---
//     $this->db->select('sp.fk_eventType, COUNT(sp.cult_id) as student_count');
//     $this->db->from('conf_culturalchild sp');

//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($events)) {
//         $this->db->where_in('sp.fk_eventType', (array)$events);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.Financial_Year', (array)$years);
//     }

//     $this->db->group_by('sp.fk_eventType');
//     $this->db->order_by('sp.fk_eventType', 'ASC');
//     $response['eventData'] = $this->db->get()->result();

//     // --- 2. Yearwise Count ---
//     $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.cult_id) as count");
//     $this->db->from("conf_culturalchild sp");
//     $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");

//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($events)) {
//         $this->db->where_in('sp.fk_eventType', (array)$events);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.Financial_Year', (array)$years);
//     }

//     $this->db->group_by("fy.finiYear_id, fy.fini_Label");
//     $this->db->order_by("fy.finiYear_id", "ASC");
//     $response['yearData'] = $this->db->get()->result();

//     return $response;
// }

public function getCombinedData($institu = null, $events = [], $years = [])
{
    $response = [];

    // --- 1. Eventwise Count ---
    $this->db->select('sp.fk_eventType, em.event_type, COUNT(sp.cult_id) as student_count');
    $this->db->from('conf_culturalchild sp');
    $this->db->join('event_master em', 'em.event_id = sp.fk_eventType', 'left'); // ✅ Join added

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($events)) {
        $this->db->where_in('sp.fk_eventType', (array)$events);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }

    $this->db->group_by('sp.fk_eventType, em.event_type'); // ✅ Updated group by
    $this->db->order_by('sp.fk_eventType', 'ASC');
    $response['eventData'] = $this->db->get()->result();

    // --- 2. Yearwise Count (unchanged) ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.cult_id) as count");
    $this->db->from("conf_culturalchild sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($events)) {
        $this->db->where_in('sp.fk_eventType', (array)$events);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}

public function getEventDetailsData($fk_eventType, $institu = null, $year = null)
{
    $this->db->select('sp.Guest_name, sp.cult_id, event_master.event_type,
    sp.event_name,sp.event_date,sp.guest_details,sp.document_1,sp.document_2,
    sp.document_3,sp.event_date,sp.event_details');
    $this->db->from('conf_culturalchild sp');
     $this->db->join('event_master', 'event_master.event_id = sp.fk_eventType', 'left');

    $this->db->where('sp.fk_eventType', $fk_eventType);

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('sp.Financial_Year', $year);
    // }


  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('sp.Financial_Year', $year);
    } else {
        $this->db->where('sp.Financial_Year', $year);
    }
}

    return $this->db->get()->result();
}

}