<?php
class Consultancy_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertdata($model)
    {
         $this->db->insert('consultancy_master', $model);
         return $this->db->insert_id();
    }

    public function getdetailview()
    {
        $this->db->select('consultancy_master.*, finiyear_master.fini_Label, faculty_master.fac_Fullname, branch_master.branch_name');
        $this->db->from('consultancy_master');
        $this->db->join('finiyear_master', 'consultancy_master.Financial_year = finiyear_master.finiYear_id', 'left');
        $this->db->join('faculty_master', 'consultancy_master.fk_fac = faculty_master.fac_id', 'left');
        $this->db->join('branch_master', 'consultancy_master.fk_branch = branch_master.branch_id', 'left');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        
        $this->db->order_by('consultancy_master.conslt_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getYearData()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // public function getbranch()
    // {
    //     $this->db->select('branch_id, branch_name');
    //     $this->db->from('branch_master');
    //     $this->db->where('is_active', 1);
    //     $this->db->order_by('branch_name', 'ASC');
    //     $query = $this->db->get();
    //     return $query->result();
    // }
 public function getbranch()
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end

        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }


    public function getfac()
    {
        $this->db->select('fac_id, fac_Fullname');
        $this->db->from('faculty_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fac_Fullname', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Branch methods
    public function branchExists($branch_name)
    {
        $this->db->where('LOWER(branch_name)', strtolower($branch_name));
        $query = $this->db->get('branch_master');
        return $query->num_rows() > 0;
    }

    public function insertBranch($data)
    {
        if ($this->db->insert('branch_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    public function getBranchIdByName($branch_name)
    {
        $this->db->select('branch_id');
        $this->db->where('LOWER(branch_name)', strtolower($branch_name));
        $query = $this->db->get('branch_master');
        if ($query->num_rows() > 0) {
            return $query->row()->branch_id;
        }
        return false;
    }

    // Faculty methods
    public function facultyExists($faculty_name)
    {
        $this->db->where('LOWER(fac_Fullname)', strtolower($faculty_name));
        $query = $this->db->get('faculty_master');
        return $query->num_rows() > 0;
    }

    public function insertFaculty($data)
    {
        if ($this->db->insert('faculty_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    public function getFacultyIdByName($faculty_name)
    {
        $this->db->select('fac_id');
        $this->db->where('LOWER(fac_Fullname)', strtolower($faculty_name));
        $query = $this->db->get('faculty_master');
        if ($query->num_rows() > 0) {
            return $query->row()->fac_id;
        }
        return false;
    }

    // Year methods
    public function yearExists($year_label)
    {
        $this->db->where('LOWER(fini_Label)', strtolower($year_label));
        $query = $this->db->get('finiyear_master');
        return $query->num_rows() > 0;
    }

    public function insertYear($data)
    {
        if ($this->db->insert('finiyear_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    public function getYearIdByLabel($year_label)
    {
        $this->db->select('finiYear_id');
        $this->db->where('LOWER(fini_Label)', strtolower($year_label));
        $query = $this->db->get('finiyear_master');
        if ($query->num_rows() > 0) {
            return $query->row()->finiYear_id;
        }
        return false;
    }

    // ⭐ Get single record by ID with joins
    public function getbyid($id)
    {
        $this->db->select('consultancy_master.*, branch_master.branch_name, faculty_master.fac_Fullname, finiyear_master.fini_Label');
        $this->db->from('consultancy_master');
        $this->db->join('branch_master', 'consultancy_master.fk_branch = branch_master.branch_id', 'left');
        $this->db->join('faculty_master', 'consultancy_master.fk_fac = faculty_master.fac_id', 'left');
        $this->db->join('finiyear_master', 'consultancy_master.Financial_year = finiyear_master.finiYear_id', 'left');
        $this->db->where('conslt_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

    // ⭐ Update record
    public function update($model)
    {
        if (!is_array($model) || empty($model['conslt_id'])) {
            log_message('error', 'Invalid model data in Consultancy_model->update(): ' . print_r($model, true));
            return false;
        }

        return $this->db->where('conslt_id', $model['conslt_id'])
                        ->update('consultancy_master', $model);
    }
}