<?php
class FacultyReport_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    public function getTaluka() 
    {
        $this->db->select('taluka_id, taulkaName');
        $this->db->from('taluka_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getbranch()
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getCity()
    {
        $this->db->select('district_id, district_name');
        $this->db->from('district_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getEMP()
    {
        $this->db->select('teaching_type');
        $this->db->distinct();
        $this->db->from('faculty_master');
        $this->db->where('teaching_type IS NOT NULL');
        $this->db->where('teaching_type !=', '');
        $query = $this->db->get();
        return $query->result();
    }
    

    public function getGender()
    {
        $this->db->select('gender_id, gender_name');
        $this->db->from('gender_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getFilteredData($taluka = [], $branches = [], $city = [], $empType = [], $gender = [])
    {
        $this->db->select('
            faculty_master.fac_id,
            faculty_master.fac_Fullname,
            faculty_master.fac_EmpID,
            faculty_master.fac_mobileNo,
            faculty_master.fkgender,
            gender_master.gender_name,
            faculty_master.fac_mailId,
            faculty_master.fac_PermanantAdd,
            faculty_master.fkTaluka_id,
            taluka_master.taulkaName,
            faculty_master.fkPresentDist_id,
            district_master.district_name,
            faculty_master.teaching_type,
            faculty_master.joining_date,
            faculty_master.fkbranch_id,
            branch_master.branch_name,
            faculty_master.finicial_Year,
            finiyear_master.fini_Label
        ');
        
        $this->db->from('faculty_master');
        $this->db->join('branch_master', 'faculty_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'faculty_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->join('gender_master', 'faculty_master.fkgender = gender_master.gender_id', 'left');
        $this->db->join('taluka_master', 'faculty_master.fkTaluka_id = taluka_master.taluka_id', 'left');
        $this->db->join('district_master', 'faculty_master.fkPresentDist_id = district_master.district_id', 'left');

        // Apply Taluka filter
        if (!empty($taluka)) {
            if (is_array($taluka)) {
                $this->db->where_in('faculty_master.fkTaluka_id', $taluka);
            } else {
                $this->db->where('faculty_master.fkTaluka_id', $taluka);
            }
        }

        // Apply Branch/Department filter
        if (!empty($branches)) {
            if (is_array($branches)) {
                $this->db->where_in('faculty_master.fkbranch_id', $branches);
            } else {
                $this->db->where('faculty_master.fkbranch_id', $branches);
            }
        }

        // Apply City filter
        if (!empty($city)) {
            if (is_array($city)) {
                $this->db->where_in('faculty_master.fkPresentDist_id', $city);
            } else {
                $this->db->where('faculty_master.fkPresentDist_id', $city);
            }
        }

        // Apply Employee Type filter
        // Apply Employee Type filter
if (!empty($empType)) {
    if (is_array($empType)) {
        $this->db->where_in('faculty_master.teaching_type', $empType);
    } else {
        $this->db->where('faculty_master.teaching_type', $empType);
    }
}
        

        // Apply Gender filter
        if (!empty($gender)) {
            if (is_array($gender)) {
                $this->db->where_in('faculty_master.fkgender', $gender);
            } else {
                $this->db->where('faculty_master.fkgender', $gender);
            }
        }

        $this->db->order_by('faculty_master.fac_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}