<?php
  class Firstinduct_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('first_induction',$model);
			//return $sql->result();
	} 


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


public function getDataByInstitute($year_id, $startdate = null, $enddate = null, )
{
    $this->db->select('
        first_induction.*, ');

    $this->db->from('first_induction');

    
    if (!empty($year_id)) {
    $this->db->where('first_induction.year', $year_id);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('first_induction.date >=', $startdate);
        $this->db->where('first_induction.date <=', $enddate);
    }

    

        $this->db->order_by('first_induction.date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}


public function getActivityByMainId($fk_firstudid)
{
    return $this->db->select('student_name, count, description,photo')
                    ->from('induction_activities')
                    ->where('fk_firstudid', $fk_firstudid)
                    ->get()
                    ->result_array();
}

public function getGuestsByMainId($fk_studentId)
{
    return $this->db->select('guest_name, designation, description')
                    ->from('induction_guest')
                    ->where('fk_studentId', $fk_studentId)
                    ->get()
                    ->result_array();
}

  // chart code
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("first_induction")
        ->join("finiyear_master", "finiyear_master.finiYear_id = first_induction.Financial_Year")
        ->group_by("first_induction.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("first_induction")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = first_induction.Financial_Year")
//         ->where("first_induction.Financial_Year", $yearId)
//         ->group_by("first_induction.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("first_induction.soft_id, first_induction.soft_name, finiyear_master.fini_Label as year,")
//         ->from("first_induction")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = first_induction.Financial_Year")
//      ->where("first_induction.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("first_induction")
        ->join("finiyear_master", "finiyear_master.finiYear_id = first_induction.Financial_Year")
        ->where("first_induction.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('first_induction.fk_branch', (array)$branches);
    }
  
 
    $this->db->group_by("first_induction.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("first_induction.soft_id, first_induction.soft_name, finiyear_master.fini_Label as year,")
        ->from("first_induction")
        ->join("finiyear_master", "finiyear_master.finiYear_id = first_induction.Financial_Year")
                // ->join('student_reg', 'student_reg.Student_id = first_induction.fk_student')
        ->where("first_induction.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('first_induction.fk_branch', (array)$branches);
    }
    
 
    return $this->db->get()->result_array();
}

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(first_induction.soft_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('first_induction', 'branch_master.branch_id = first_induction.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('first_induction.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('first_induction.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('first_induction.soft_name,
                       first_induction.soft_id,
                       first_induction.fk_branch,
                       branch_master.branch_name,
                        ');
    $this->db->from('first_induction');
    $this->db->join('branch_master', 'branch_master.branch_id = first_induction.fk_branch', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('first_induction.fk_branch', $branch_id);
} else {
    $this->db->where('first_induction.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('first_induction.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('first_induction.Financial_Year', $year);
    // }

  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('first_induction.Financial_Year', $year);
    } else {
        $this->db->where('first_induction.Financial_Year', $year);
    }
}
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("first_induction.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.soft_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('first_induction sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.soft_id) as count");
    $this->db->from("first_induction sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
    

}