<?php
  class Guestlec_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
 
      public function insertdata($model)
  {
     $this->db->insert('guestlectures_master',$model);
      return $this->db->insert_id();
  }
  public function insertgallery($model)
    {
        return $this->db->insert('guesttalk_photo_master',$model);
            //return $sql->result();
    }
 
    public function insertChild($model) {
        return $this->db->insert('guestlec_student', $model);
    }


   public function getdetailview()
{      
    $this->db->select('guestlectures_master.Guest_id ,
                       guestlectures_master.Guest_name,
                       guestlectures_master.fkbranch_id,
                       branch_master.branch_name,
                       guestlectures_master.fkdesig_id,
                       designation_master.desig_name,
                       guestlectures_master.fkfac_id,
                       faculty_master.fac_Fullname,
                       guestlectures_master.fkclass_id,
                      classmaster.classname,
                       guestlectures_master.fkSemID,
                       semester_master.Sem_Name,
                       guestlectures_master.Talk_date,
                       guestlectures_master.No_benefit,
                       guestlectures_master.Expert_topic,
                       guestlectures_master.oraganization,
                       guestlectures_master.location,
                        guestlectures_master.start_date,
                       guestlectures_master.end_date
                      
                       ');

    $this->db->from('guestlectures_master');
    $this->db->join('branch_master','guestlectures_master.fkbranch_id = branch_master.branch_id','left');
    $this->db->join('classmaster','guestlectures_master.fkclass_id = classmaster.class_id','left');
    $this->db->join('semester_master','guestlectures_master.fkSemID = semester_master.SemID','left');
    $this->db->join('designation_master','guestlectures_master.fkdesig_id = designation_master.desig_id','left'); 
    $this->db->join('faculty_master','guestlectures_master.fkfac_id = faculty_master.fac_id','left'); 
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end

    $this->db->order_by('guestlectures_master.Guest_id','DESC');

    $query = $this->db->get();
    return $query->result();      
}

 
     public function getbranch()
{
    $this->db->select('branch_id, branch_name');
    $this->db->from('branch_master');
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    $query = $this->db->get();
    return $query->result();


}
// public function getClassesByBranch($branch_id)
// {
//     return $this->db->select('classmaster.class_id, classmaster.classname AS class_name') // important!
//                     ->from('student_reg')
//                     ->join('classmaster', 'classmaster.class_id = student_reg.fkClass_id')
//                     ->where('student_reg.fkBranchName_id', $branch_id)
//                     ->group_by('classmaster.class_id')
//                     ->get()
//                     ->result();
// }

  public function getFac()
  {      
   
     $this->db->select('fac_id, fac_Fullname');
     $this->db->from('faculty_master');
     $query = $this->db->get();
     return $query->result();

          
  }
  public function getsemester()
  {      
   
     $this->db->select('SemID, Sem_Name');
     $this->db->from('semester_master');
     $query = $this->db->get();
     return $query->result();

          
  }
  
public function getinstitu()
     {
      $this->db->select('Institu_id, Institu_name');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

   public function getClass()
  {      
   
     $this->db->select('class_id, classname');
     $this->db->from('classmaster');
     $query = $this->db->get();
     return $query->result();

          
  }

  public function getdesignation()
{
    $this->db->select('desig_id, desig_name');
    $this->db->from('designation_master');
    $query = $this->db->get();
    return $query->result();
}
 

      public function getbyid($id)
    {
      $this->db->select("guestlectures_master.*,");
      $this->db->where('Guest_id',$id);
      $query = $this->db->get('guestlectures_master');
      return $query->result();
    }
   
    public function update($model)
    {
       return $sql = $this->db->where('Guest_id',$model['Guest_id'])->update('guestlectures_master',$model);
    }
 
   // Delete old images mappings
public function deleteimagedata($fkGuest_id)
{
    return $this->db->where('fkGuest_id', $fkGuest_id)
                    ->delete('guesttalk_photo_master');
}
 public function deleteSpecificPhotos($guest_id, $photo_paths) {
    if (empty($photo_paths)) return false;
    
    $this->db->where('fkGuest_id', $guest_id);
    $this->db->where_in('talk_photos', $photo_paths);
    return $this->db->delete('guesttalk_photo_master');
}
//  In Guestlec_model.php - Add this method for bulk photo insert

public function insertMultiplePhotos($guest_id, $photo_paths)
{
    if (empty($photo_paths)) return false;
    
    $insert_data = [];
    foreach ($photo_paths as $path) {
        $insert_data[] = [
            'fkGuest_id' => $guest_id,
            'talk_photos' => $path
        ];
    }
    
    return $this->db->insert_batch('guesttalk_photo_master', $insert_data);
}

// Also fix this method to handle errors properly
public function getSelectedimage($guest_id)
{
    if (empty($guest_id)) return [];
    
    $this->db->select('talk_photos');
    $this->db->from('guesttalk_photo_master');
    $this->db->where('fkGuest_id', $guest_id);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return array_column($query->result_array(), 'talk_photos');
    }
    
    return [];
}


// new code 
 public function getChildByMainId($sub_id) {
        $this->db->select('*');
        $this->db->from('guestlec_student');
        $this->db->where('fkGuest_id', $sub_id);
        return $this->db->get()->result();
    }
 
     // Update child record
    public function updateChild($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('guestlec_student', $data);
    }
 
    // Delete single child record
    public function deleteChild($id) {
        $this->db->where('id', $id);
        return $this->db->delete('guestlec_student');
    }
 
    // Delete child records by main ID (for complete refresh if needed)
    public function deleteChildByMainId($sub_id) {
        $this->db->where('fkGuest_id', $sub_id);
        return $this->db->delete('guestlec_student');
    }
 

// new code end 



}