<?php
  class Heads_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
       public function insertdata($model)
      {
        return $this->db->insert('leaveapp_master',$model);
        //return $sql->result();
      }



public function getBranchFaculty($branch_id, $exclude_fac_id = null)
{
    // ✅ Step 1: Get REG + PRINCIPAL faculty IDs
    $this->db->select('fkfac_id');
    $this->db->from('activeheads_master');
    $this->db->where_in('fkdesig_id', [2, 3]);
    $this->db->where('is_active', 1);
    $this->db->where('Active_Deactive', 1);

    $subQuery = $this->db->get_compiled_select(); // ✅ create subquery string

    // ✅ Step 2: Main faculty query
    $this->db->select('f.fac_id, f.fac_Fullname');
    $this->db->from('faculty_master f');
    $this->db->where('f.fkbranch_id', $branch_id);
    $this->db->where('f.is_active', 1);

    // ✅ Step 3: Exclude REG/PRINCIPAL using subquery
    $this->db->where("f.fac_id NOT IN ($subQuery)", NULL, FALSE); // Raw where

    if (!empty($exclude_fac_id)) {
        $this->db->where('f.fac_id !=', $exclude_fac_id);
    }

    return $this->db->get()->result();
}


  public function getLoggedInFaculty($fac_id)
{
    $this->db->select('fac_id, fac_Fullname');
    $this->db->from('faculty_master');
    $this->db->where('fac_id', $fac_id);
    $query = $this->db->get();
    return $query->result();
}


     public function getallLeave()
  {                   
    $this->db->select('leaveCat_id,leave_name');
    $this->db->from('leavecat_master');
 
    $query = $this->db->get();
    return $query->result();
  }
public function getdetailview()
{
    $this->db->select('leaveapp_master.LeaveApp_id,leaveapp_master.HOD_RejReas,leaveapp_master.REG_RejReas,leaveapp_master.Princ_RejReas,leaveapp_master.REG_Approval, leaveapp_master.Princ_Approval, leaveapp_master.HOD_Approval, leaveapp_master.Leave_from, leaveapp_master.Leave_to, leaveapp_master.No_of_days, leaveapp_master.Leave_Reas, faculty_master.fac_Fullname, leavecat_master.leave_name');
    $this->db->from('leaveapp_master');
    $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
    
    // ✅ Filter: Show only data of currently logged-in faculty
    $this->db->where('leaveapp_master.fkfac_id');
    
    $query = $this->db->get();
    return $query->result();
}
// public function getverifydetailview()
// {
//     $branch_id     = $this->session->userdata('branch_id');
//     // $logged_fac_id = $this->session->userdata('fac_id');

//     // ✅ Step 1: Get faculty_ids with desig_id 2 or 3 (Registrar/Principal)
//     $this->db->select('fkfac_id');
//     $this->db->from('activeheads_master');
//     $this->db->where_in('fkdesig_id', [2, 3]);
//     $this->db->where('is_active', 1);
//     $this->db->where('Active_Deactive', 1);
//     $excludedFacIDs = array_column($this->db->get()->result_array(), 'fkfac_id');

//     // ✅ Step 2: Main query
//     $this->db->select('
//         leaveapp_master.LeaveApp_id,
//         leaveapp_master.REG_Approval,
//         leaveapp_master.Princ_Approval,
//         leaveapp_master.HOD_Approval,
//         leaveapp_master.Leave_from,
//         leaveapp_master.Leave_to,
//         leaveapp_master.No_of_days,
//         leaveapp_master.ApprovedDays,
//         leaveapp_master.Leave_Reas,
//         faculty_master.fac_Fullname,
//         leavecat_master.leave_name,
//         leaveapp_master.HOD_RejReas,
//         leaveapp_master.REG_RejReas,
//         leaveapp_master.Princ_RejReas,
//         b.branch_name
//     ');
//     $this->db->from('leaveapp_master');
//     $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
//     $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
//     $this->db->join('branch_master b', 'b.branch_id  = faculty_master.fkbranch_id', 'left');

//     // ✅ Filters
//     $this->db->where('faculty_master.fkbranch_id', $branch_id);
//     $this->db->where('faculty_master.is_active', 1);
//     // $this->db->where('leaveapp_master.fkfac_id !=', $logged_fac_id);

//     if (!empty($excludedFacIDs)) {
//         $this->db->where_not_in('leaveapp_master.fkfac_id', $excludedFacIDs);
//     }

//     $this->db->order_by('leaveapp_master.LeaveApp_id', 'DESC');

//     return $this->db->get()->result();
// }

public function getverifydetailview()
{
    $branch_id     = $this->session->userdata('branch_id');
    // $logged_fac_id = $this->session->userdata('fac_id');

    // ✅ Step 1: Get faculty_ids with desig_id 2 or 3 (Registrar/Principal)
    $this->db->select('fkfac_id');
    $this->db->from('activeheads_master');
    $this->db->where_in('fkdesig_id', [2, 3]);
    $this->db->where('is_active', 1);
    $this->db->where('Active_Deactive', 1);
    $excludedFacIDs = array_column($this->db->get()->result_array(), 'fkfac_id');

    // ✅ Step 2: Main query
    $this->db->select('
        leaveapp_master.LeaveApp_id,
        leaveapp_master.REG_Approval,
        leaveapp_master.Princ_Approval,
        leaveapp_master.HOD_Approval,
        leaveapp_master.Leave_from,
        leaveapp_master.Leave_to,
        leaveapp_master.No_of_days,
        leaveapp_master.ApprovedDays,
        leaveapp_master.Leave_Reas,
         fm1.fac_Fullname as facname1,
        leavecat_master.leave_name,
        leaveapp_master.HOD_RejReas,
        leaveapp_master.REG_RejReas,
        leaveapp_master.Princ_RejReas,
         leaveapp_master.fkAlternative_id,leaveapp_master.created_date,
        b.branch_name, fm2.fac_Fullname as facname2,

    ');
    $this->db->from('leaveapp_master');
$this->db->join('faculty_master fm1', 'leaveapp_master.fkfac_id = fm1.fac_id', 'left');
$this->db->join('faculty_master fm2', 'leaveapp_master.fkAlternative_id = fm2.fac_id', 'left'); 
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('branch_master b', 'b.branch_id  =  fm1.fkbranch_id', 'left');

    // ✅ Filters
    $this->db->where('fm1.fkbranch_id', $branch_id);
    $this->db->where('fm1.is_active', 1);
    // $this->db->where('leaveapp_master.fkfac_id !=', $logged_fac_id);

    if (!empty($excludedFacIDs)) {
        $this->db->where_not_in('leaveapp_master.fkfac_id', $excludedFacIDs);
    }

    $this->db->order_by('leaveapp_master.LeaveApp_id', 'DESC');

    return $this->db->get()->result();
}



// public function getRegverifydetailview()
// {
//     $logged_fac_id = $this->session->userdata('fac_id');

//     $this->db->select('
//         leaveapp_master.LeaveApp_id,
//         leaveapp_master.REG_Approval,
//         leaveapp_master.Princ_Approval,
//         leaveapp_master.HOD_Approval,
//         leaveapp_master.Leave_from,
//         leaveapp_master.Leave_to,
//         leaveapp_master.No_of_days,
//         leaveapp_master.ApprovedDays,
//         leaveapp_master.Leave_Reas,
//         leavecat_master.leave_name,
//         faculty_master.fac_Fullname,
//         leaveapp_master.HOD_RejReas,
//         leaveapp_master.REG_RejReas,
//         leaveapp_master.Princ_RejReas,
//         b.branch_name
//     ');
//     $this->db->from('leaveapp_master');
//     $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
//     $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
//     $this->db->join('activeheads_master ah', 'ah.fkfac_id = faculty_master.fac_id', 'left');
//     $this->db->join('branch_master b', 'b.branch_id = faculty_master.fkbranch_id', 'left');

//     // ✅ Only show leave requests approved by HOD
//     $this->db->where('leaveapp_master.HOD_Approval', 1);

//     // ✅ Exclude currently logged-in registrar’s own leave entries
//     // $this->db->where('leaveapp_master.fkfac_id !=', $logged_fac_id);

//     // ✅ Only active faculty
//     $this->db->where('faculty_master.is_active', 1);

//     // ✅ Exclude Principals (fkdesig_id = 3), but include NULLs (non-heads)
//     $this->db->group_start();
//         $this->db->where('ah.fkdesig_id !=', 3);
//         $this->db->or_where('ah.fkdesig_id IS NULL');
//     $this->db->group_end();

//     // ✅ Order by latest leave entries
//     $this->db->order_by('leaveapp_master.LeaveApp_id', 'DESC');

//     return $this->db->get()->result();
// }

public function getRegverifydetailview()
{
    $logged_fac_id = $this->session->userdata('fac_id');
 
    $this->db->select('
        leaveapp_master.LeaveApp_id,
        leaveapp_master.REG_Approval,
        leaveapp_master.Princ_Approval,
        leaveapp_master.HOD_Approval,
        leaveapp_master.Leave_from,
        leaveapp_master.Leave_to,
        leaveapp_master.No_of_days,
        leaveapp_master.ApprovedDays,
        leaveapp_master.Leave_Reas,
        leavecat_master.leave_name,
        faculty_master.fac_Fullname,
        alt.fac_Fullname AS alt_name,
        leaveapp_master.HOD_RejReas,
        leaveapp_master.REG_RejReas,
        leaveapp_master.Princ_RejReas,
        b.branch_name
    ');
    $this->db->from('leaveapp_master');
    $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
      $this->db->join('faculty_master alt', 'alt.fac_id = leaveapp_master.fkAlternative_id', 'left');
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('activeheads_master ah', 'ah.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->join('branch_master b', 'b.branch_id = faculty_master.fkbranch_id', 'left');
 
    // ✅ Only show leave requests approved by HOD
    $this->db->where('leaveapp_master.HOD_Approval', 1);
 
    // ✅ Exclude currently logged-in registrar’s own leave entries
    // $this->db->where('leaveapp_master.fkfac_id !=', $logged_fac_id);
 
    // ✅ Only active faculty
    $this->db->where('faculty_master.is_active', 1);
 
    // ✅ Exclude Principals (fkdesig_id = 3), but include NULLs (non-heads)
    $this->db->group_start();
        $this->db->where('ah.fkdesig_id !=', 3);
        $this->db->or_where('ah.fkdesig_id IS NULL');
    $this->db->group_end();
 
    // ✅ Order by latest leave entries
    $this->db->order_by('leaveapp_master.LeaveApp_id', 'DESC');
 
    return $this->db->get()->result();
}


// public function getPrincipleverifydetailview()
// {
//     $logged_fac_id = $this->session->userdata('fac_id');

//     $this->db->select('
//         leaveapp_master.LeaveApp_id,
//         leaveapp_master.REG_Approval,
//         leaveapp_master.Princ_Approval,
//         leaveapp_master.HOD_Approval,
//         leaveapp_master.Leave_from,
//         leaveapp_master.Leave_to,
//         leaveapp_master.No_of_days,
//         leaveapp_master.ApprovedDays,
//         leaveapp_master.Leave_Reas,
//         faculty_master.fac_Fullname,
//         leavecat_master.leave_name,
//         leaveapp_master.HOD_RejReas,
//         leaveapp_master.REG_RejReas,
//         leaveapp_master.Princ_RejReas,
//         b.branch_name
//              ');
//     $this->db->from('leaveapp_master');
//     $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
//     $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
//     $this->db->join('activeheads_master ah', 'ah.fkfac_id = faculty_master.fac_id', 'left');
//     $this->db->join('branch_master b', 'b.branch_id  = faculty_master.fkbranch_id', 'left');

// $this->db->where('leaveapp_master.HOD_Approval', 1);
//     $this->db->where('leaveapp_master.REG_Approval', 1);


//     // $this->db->where('leaveapp_master.fkfac_id !=', $logged_fac_id);

  
//     $this->db->order_by('leaveapp_master.LeaveApp_id', 'DESC');

//     $query = $this->db->get();
//     return $query->result();
// }
public function getPrincipleverifydetailview()
{
    $logged_fac_id = $this->session->userdata('fac_id');

    $this->db->select('
        leaveapp_master.LeaveApp_id,
        leaveapp_master.REG_Approval,
        leaveapp_master.Princ_Approval,
        leaveapp_master.HOD_Approval,
        leaveapp_master.Leave_from,
        leaveapp_master.Leave_to,
        leaveapp_master.No_of_days,
        leaveapp_master.ApprovedDays,
        leaveapp_master.Leave_Reas,
    fm1.fac_Fullname as facname1,
        leavecat_master.leave_name,
        leaveapp_master.HOD_RejReas,
        leaveapp_master.REG_RejReas,
        leaveapp_master.Princ_RejReas,
        b.branch_name,leaveapp_master.created_date,
        fm2.fac_Fullname as facname2,
             ');
    $this->db->from('leaveapp_master');
    $this->db->join('faculty_master fm1', 'leaveapp_master.fkfac_id = fm1.fac_id', 'left');
$this->db->join('faculty_master fm2', 'leaveapp_master.fkAlternative_id = fm2.fac_id', 'left');
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('activeheads_master ah', 'ah.fkfac_id =  fm1.fac_id', 'left');
    $this->db->join('branch_master b', 'b.branch_id  =  fm1.fkbranch_id', 'left');

$this->db->where('leaveapp_master.HOD_Approval', 1);
    $this->db->where('leaveapp_master.REG_Approval', 1);


    // $this->db->where('leaveapp_master.fkfac_id !=', $logged_fac_id);

  
    $this->db->order_by('leaveapp_master.LeaveApp_id', 'DESC');

    $query = $this->db->get();
    return $query->result();
}

     public function getbyid($id)
		{
	
		
        $this->db->select('leaveapp_master.LeaveApp_id,leaveapp_master.fkfac_id,leaveapp_master.HOD_RejReas,leaveapp_master.REG_RejReas,leaveapp_master.ApprovedDays,
        leaveapp_master.HOD_date,leaveapp_master.REG_date,leaveapp_master.fkAlternative_id,
        leaveapp_master.LeaveType,leaveapp_master.REG_Approval,leaveapp_master.Princ_Approval,leaveapp_master.HOD_Approval,leaveapp_master.Leave_from,leaveapp_master.Leave_to,leaveapp_master.No_of_days,leaveapp_master.Leave_Reas,faculty_master.fac_Fullname,leavecat_master.leave_name, leaveapp_master.HOD_RejReas,
        leaveapp_master.REG_RejReas, leaveapp_master.created_date,
        leaveapp_master.Princ_RejReas');
        $this->db->from('leaveapp_master');
	    $this->db->where('LeaveApp_id',$id);
      $this->db->join('faculty_master','leaveapp_master.fkfac_id = faculty_master.fac_id','left'); 
          $this->db->join('leavecat_master','leaveapp_master.LeaveType = leavecat_master.leaveCat_id','left');
            $query = $this->db->get();
          	return $query->result();
  
		}

        // all update data
            public function getbyiddata($id)
		{
	
		
        $this->db->select('leaveapp_master.LeaveApp_id,leaveapp_master.fkfac_id,leaveapp_master.HOD_RejReas,leaveapp_master.REG_RejReas,leaveapp_master.ApprovedDays,leaveapp_master.HOD_date,leaveapp_master.REG_date,leaveapp_master.fkAlternative_id,leaveapp_master.LeaveType,leaveapp_master.REG_Approval,leaveapp_master.Princ_Approval,leaveapp_master.HOD_Approval,leaveapp_master.Leave_from,leaveapp_master.Leave_to,leaveapp_master.No_of_days,leaveapp_master.Leave_Reas,f.fac_Fullname as fullname,fa.fac_Fullname as fullaltername,leavecat_master.leave_name, leaveapp_master.HOD_RejReas,
        leaveapp_master.REG_RejReas, leaveapp_master.created_date,
        leaveapp_master.Leave_Document,
        leaveapp_master.Princ_RejReas');
        $this->db->from('leaveapp_master');
	    $this->db->where('LeaveApp_id',$id);
      $this->db->join('faculty_master f','leaveapp_master.fkfac_id = f.fac_id','left'); 
      $this->db->join('faculty_master fa','leaveapp_master.fkAlternative_id = fa.fac_id','left'); 
          $this->db->join('leavecat_master','leaveapp_master.LeaveType = leavecat_master.leaveCat_id','left');
            $query = $this->db->get();
          	return $query->result();
  
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('LeaveApp_id',$model['LeaveApp_id'])->update('leaveapp_master',$model); 
    }
    
// public function getAllLeaveStatus($fac_id) {
//     $this->db->select('leaveCat_id, leave_name, No_of_leave');
//     $leaveCategories = $this->db->get('leavecat_master')->result();

//     // Get sum of approved/pending leaves only (exclude any rejected)
//     $this->db->select('LeaveType, SUM(No_of_days) as total_days');
//     $this->db->from('leaveapp_master');
//     $this->db->where('fkfac_id', $fac_id);
//     $this->db->where('HOD_Approval !=', 2);
//     $this->db->where('REG_Approval !=', 2);
//     $this->db->where('Princ_Approval !=', 2);
//     $this->db->group_by('LeaveType');
//     $leaveSums = $this->db->get()->result();

//     $sums = [];
//     foreach ($leaveSums as $row) {
//         $sums[$row->LeaveType] = $row->total_days;
//     }

//     // Fetch all records (including rejected ones)
//     $this->db->select('
//         lm.Leave_from,
//         lm.Leave_to,
//         lm.No_of_days,
//         lm.Leave_Reas,
//         lm.LeaveType,
//         lm.HOD_Approval,
//         lm.REG_Approval,
//         lm.Princ_Approval,
//           lm.created_date,
//         fm.fac_Fullname AS altFaculty
//     ');
//     $this->db->from('leaveapp_master lm');
//     $this->db->join('faculty_master fm', 'lm.fkAlternative_id = fm.fac_id', 'left');
//     $this->db->where('lm.fkfac_id', $fac_id);
//     $records = $this->db->get()->result();

//     $recordGrouped = [];
//     foreach ($records as $r) {
//         $recordGrouped[$r->LeaveType][] = $r;
//     }

//     $output = [];
//     foreach ($leaveCategories as $cat) {
//         $cat_id = $cat->leaveCat_id;
//         $output[] = [
//             'id' => $cat_id,
//             'name' => $cat->leave_name,
//             'max' => $cat->No_of_leave,
//             'used' => isset($sums[$cat_id]) ? $sums[$cat_id] : 0,
//             'records' => isset($recordGrouped[$cat_id]) ? $recordGrouped[$cat_id] : []
//         ];
//     }

//     return $output;
// }

public function getExtraLeaveDays($fac_id)
{
    $this->db->select('fkleaveCat_id, no_of_LeaveDays, Leave_date, LateMark, Lateday');
    $this->db->from('reg_fac_leave_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('is_active', 1);

    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';
    $this->db->where_in('fkfiniYear_id', "($subQuery)", FALSE);

    $query = $this->db->get()->result();

    $grouped = [];
    foreach ($query as $row) {
        $grouped[$row->fkleaveCat_id][] = $row;
    }

    return $grouped;
}




public function getAllLeaveStatus($fac_id)
{
    $this->db->select("
        abc.leaveCat_id,
        abc.leave_name,
        CASE 
            WHEN fy.finiYear_id IS NOT NULL AND fy.Active_Deactive = 1 THEN
                CASE MONTH(f.joining_date)
                    WHEN 1 THEN abc.January
                    WHEN 2 THEN abc.February
                    WHEN 3 THEN abc.March
                    WHEN 4 THEN abc.April
                    WHEN 5 THEN abc.May
                    WHEN 6 THEN abc.June
                    WHEN 7 THEN abc.July
                    WHEN 8 THEN abc.August
                    WHEN 9 THEN abc.September
                    WHEN 10 THEN abc.October
                    WHEN 11 THEN abc.November
                    WHEN 12 THEN abc.December
                END
            ELSE abc.April
        END AS joining_month_value
    ");
    $this->db->from("(SELECT 
                        leaveCat_id,
                        leave_name,
                        January,
                        February,
                        March,
                        April,
                        May,
                        June,
                        July,
                        August,
                        September,
                        October,
                        November,
                        December
                     FROM leavecat_master) AS abc");
    $this->db->join('faculty_master f', 'f.fac_id = ' . (int)$fac_id, 'left');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = f.finicial_Year AND fy.Active_Deactive = 1', 'left');

    $leaveCategories = $this->db->get()->result();


    
    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';


    $this->db->select('LeaveType, SUM(No_of_days) as total_days');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('HOD_Approval !=', 2);
    $this->db->where('REG_Approval !=', 2);
    $this->db->where('Princ_Approval !=', 2);
    $this->db->where_in('finicial_Year', "($subQuery)", FALSE);
    $this->db->group_by('LeaveType');
    $leaveSums = $this->db->get()->result();

    $sums = [];
    foreach ($leaveSums as $row) {
        $sums[$row->LeaveType] = $row->total_days;
    }



    $this->db->select('
        lm.Leave_from,
        lm.Leave_to,
        lm.No_of_days,
        lm.Leave_Reas,
        lm.LeaveType,
        lm.HOD_Approval,
        lm.REG_Approval,
        lm.created_date,
        lm.Princ_Approval,
        lm.ApprovedDays,
        fm.fac_Fullname AS altFaculty
    ');
    $this->db->from('leaveapp_master lm');
    $this->db->join('faculty_master fm', 'lm.fkAlternative_id = fm.fac_id', 'left');
    $this->db->where('lm.fkfac_id', $fac_id);
    $this->db->where_in('lm.finicial_Year', "($subQuery)", FALSE);
    $this->db->order_by('lm.created_date', 'DESC');

    $records = $this->db->get()->result();

    $recordGrouped = [];
    foreach ($records as $r) {
        $recordGrouped[$r->LeaveType][] = $r;
    }



    $output = [];
    foreach ($leaveCategories as $cat) {
        $cat_id = $cat->leaveCat_id;
        $output[] = [
            'id'      => $cat_id,
            'name'    => $cat->leave_name,
            'max'     => $cat->joining_month_value,
            'used'    => isset($sums[$cat_id]) ? $sums[$cat_id] : 0,
            'records' => isset($recordGrouped[$cat_id]) ? $recordGrouped[$cat_id] : []
        ];
    }

    return $output;
}

public function get_all_leave_types() {
    return $this->db->get('leavecat_master')->result(); // Adjust table name if different
}


}