<?php
  class Honor_MinorReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
    
 public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function gethonor()
     {
      $this->db->select('honor_minor_type_master.*,');
      $this->db->from('honor_minor_type_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getduration()
     {
      $this->db->select('internduration_master.*,');
      $this->db->from('internduration_master');
       $query = $this->db->get();
        return $query->result();
     }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }





public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [],  $typeids = [] )
{
    $this->db->select('
        honor_minor_master.*, 
        honor_minor_type_master.honor_minor_type_name,
        finiyear_master.fini_Label,
        branch_master.branch_name,
        honor_minor_type_master.honor_minor_type_name');

    $this->db->from('honor_minor_master');
    $this->db->join('honor_minor_type_master', 'honor_minor_type_master.honor_minor_type_id = honor_minor_master.fk_honor_minor_type', 'left');
$this->db->join('finiyear_master', 
                        'honor_minor_master.fk_year = finiyear_master.finiYear_id', 
                        'left');
$this->db->join('branch_master', 'branch_master.branch_id = honor_minor_master.fkbranch_id', 'left');
    $this->db->where('honor_minor_master.fkInstitu_id', $institute_id);

    if (!empty($typeids)) {
        $this->db->where_in('honor_minor_master.fk_honor_minor_type', $typeids);
    }

 if (!empty($branch_ids)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

    if (!empty($year_id)) {
    $this->db->where('honor_minor_master.fk_year', $year_id);
}



    
        // $this->db->order_by('honor_minor_master.start_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

public function getAllYearsData($branches = [])
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(honor_minor_master.honor_minor_id) as count")
        ->from("honor_minor_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = honor_minor_master.fk_year");
    
    if (!empty($branches)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', (array)$branches);
    }
    
    $this->db->group_by("honor_minor_master.fk_year, fini_Label, finiyear_master.finiYear_id");
    
    return $this->db->get()->result_array();
}

// Updated getSingleYearData with branch filter
public function getSingleYearData($yearId, $branches = [])
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(honor_minor_master.honor_minor_id) as count")
        ->from("honor_minor_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = honor_minor_master.fk_year")
        ->where("honor_minor_master.fk_year", $yearId);
    
    if (!empty($branches)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', explode(',', $branchIds));
    }
}
    $this->db->group_by("honor_minor_master.fk_year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}

// Updated getYearwiseTypes with branch filter
public function getYearwiseTypes($yearId, $branches = [])
{
    $this->db->select("honor_minor_master.honor_minor_id, honor_minor_master.details, finiyear_master.fini_Label as year,
    honor_minor_type_master.honor_minor_type_name,
    honor_minor_master.student_name, honor_minor_master.prn_no,")
        ->from("honor_minor_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = honor_minor_master.fk_year")
        ->join('honor_minor_type_master', 'honor_minor_type_master.honor_minor_type_id = honor_minor_master.fk_honor_minor_type', 'left')
        ->where("honor_minor_master.fk_year", $yearId);
    
    if (!empty($branches)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', explode(',', $branchIds));
    }
}
    return $this->db->get()->result_array();
}

// Updated getBranchwiseCount - fix column name from fk_branch to fkbranch_id
public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(honor_minor_master.honor_minor_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('honor_minor_master', 'branch_master.branch_id = honor_minor_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('honor_minor_master.fkInstitu_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('honor_minor_master.fk_year', $year);
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}

// Updated getBranchDetailsData - fix column name
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('honor_minor_master.details,
                       honor_minor_master.honor_minor_id,
                       honor_minor_master.fkbranch_id,
                       honor_minor_master.pdf_file,
                       honor_minor_master.student_name,
                       honor_minor_master.prn_no,
                       branch_master.branch_name,
                       honor_minor_type_master.honor_minor_type_name, finiyear_master.fini_Label as year');
    $this->db->from('honor_minor_master');
    $this->db->join('branch_master', 'branch_master.branch_id = honor_minor_master.fkbranch_id', 'left');
    $this->db->join('honor_minor_type_master', 'honor_minor_type_master.honor_minor_type_id = honor_minor_master.fk_honor_minor_type', 'left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = honor_minor_master.fk_year', 'left'); // Add this join
    if (is_array($branch_id)) {
        $this->db->where_in('honor_minor_master.fkbranch_id', $branch_id);
    } else {
        $this->db->where('honor_minor_master.fkbranch_id', $branch_id);
    }

    if (!empty($institu)) {
        $this->db->where('honor_minor_master.fkInstitu_id', $institu);
    }

    if (!empty($year)) {
        if (is_array($year)) {
            $this->db->where_in('honor_minor_master.fk_year', $year);
        } else {
            $this->db->where('honor_minor_master.fk_year', $year);
        }
    }
 
    return $this->db->get()->result();
}

// Updated getCombinedData with branch filter
public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // Branchwise Count
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.honor_minor_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('honor_minor_master sp', 'b.branch_id = sp.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitu_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.fk_year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // Yearwise Count
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.honor_minor_id) as count");
    $this->db->from("honor_minor_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.fk_year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitu_id', $institu);
    }
    
    if (!empty($branches)) {
        $this->db->where_in('sp.fkbranch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fkbranch_id', explode(',', $branchIds));
    }
}
   
    if (!empty($years)) {
        $this->db->where_in('sp.fk_year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}

  // chart code
 
 
//     public function getAllYearsData()
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(honor_minor_master.honor_minor_id) as count")
//         ->from("honor_minor_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = honor_minor_master.fk_year")
//         ->group_by("honor_minor_master.fk_year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }


 
// public function getSingleYearData($yearId)
// {
//     $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(honor_minor_master.honor_minor_id) as count")
//         ->from("honor_minor_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = honor_minor_master.fk_year")
//         ->where("honor_minor_master.fk_year", $yearId);
 
    
   
 
//     $this->db->group_by("honor_minor_master.fk_year, fini_Label, finiyear_master.finiYear_id");
 
//     return $this->db->get()->result_array();
// }
 
 
// public function getYearwiseTypes($yearId)
// {
//     $this->db->select("honor_minor_master.honor_minor_id, honor_minor_master.details, finiyear_master.fini_Label as year,
//     honor_minor_type_master.honor_minor_type_name,
//     honor_minor_master.student_name, honor_minor_master.prn_no,")
//         ->from("honor_minor_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = honor_minor_master.fk_year")
// ->join('honor_minor_type_master', 'honor_minor_type_master.honor_minor_type_id = honor_minor_master.fk_honor_minor_type', 'left')

//         ->where("honor_minor_master.fk_year", $yearId);
//     return $this->db->get()->result_array();
// }

//   public function getBranchwiseCount($institu = null, $branches = [], $year = null)
// {
//     $this->db->select('branch_master.branch_id,
//                        branch_master.branch_name,
//                        COUNT(honor_minor_master.honor_minor_id) as student_count');
//     $this->db->from('branch_master');
//     $this->db->join('honor_minor_master', 'branch_master.branch_id = honor_minor_master.fk_branch', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('honor_minor_master.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('branch_master.branch_id', (array)$branches);
//     }
//     if (!empty($year) && $year != 0) {
//         $this->db->where('honor_minor_master.fk_year', $year);
//     }
    
 
//     $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
//     $this->db->order_by('branch_master.branch_name', 'ASC');
 
//     return $this->db->get()->result();
// }
 
// public function getBranchDetailsData($branch_id, $institu = null, $year = null)
// {
//     $this->db->select('honor_minor_master.details,
//                        honor_minor_master.honor_minor_id,
//                        honor_minor_master.fk_branch,
//                        honor_minor_master.start_date,
//                        honor_minor_master.document,
// semester_master.Sem_Name,audit_type.type_name,
//                        branch_master.branch_name,                      
//                         ');
//     $this->db->from('honor_minor_master');
//     $this->db->join('branch_master', 'branch_master.branch_id = honor_minor_master.fk_branch', 'left');
//  $this->db->join('semester_master', 'honor_minor_master.fk_sem = semester_master.SemID', 'left');
//         $this->db->join('audit_type', 'honor_minor_master.fk_auditType = audit_type.ID', 'left');

//    if (is_array($branch_id)) {
//     $this->db->where_in('honor_minor_master.fk_branch', $branch_id);
// } else {
//     $this->db->where('honor_minor_master.fk_branch', $branch_id);
// }
 

//     if (!empty($institu)) {
//         $this->db->where('honor_minor_master.fkInstitName_id', $institu);
//     }
//     // if (!empty($year) && $year != 0) {
//     //     $this->db->where('honor_minor_master.fk_year', $year);
//     // }

//   if (!empty($year)) {
//     if (is_array($year)) {
//         $this->db->where_in('honor_minor_master.fk_year', $year);
//     } else {
//         $this->db->where('honor_minor_master.fk_year', $year);
//     }
// }
    
//     if (!empty($startDate) && !empty($endDate)) {
//         $this->db->where("honor_minor_master.created_at BETWEEN '$startDate' AND '$endDate'");
//     }
 
//     return $this->db->get()->result();
// }
 
// public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
// {
//     $response = [];
 
//     // --- 1. Branchwise Count --- ❌ COMMENTED OUT
    
//     $this->db->select('b.branch_id, b.branch_name, COUNT(sp.honor_minor_id) as student_count');
//     $this->db->from('branch_master b');
//     $this->db->join('honor_minor_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('b.branch_id', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.fk_year', (array)$years);
//     }
   
//     $this->db->group_by('b.branch_id, b.branch_name');
//     $this->db->order_by('b.branch_name', 'ASC');
//     $response['branchData'] = $this->db->get()->result();
    
 
//     // --- 2. Yearwise Count --- ✅ KEEP THIS
//     $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.honor_minor_id) as count");
//     $this->db->from("honor_minor_master sp");
//     $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.fk_year");
 
//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitu_id', $institu);
//     }
   
//     if (!empty($years)) {
//         $this->db->where_in('sp.fk_year', (array)$years);
//     }
   
//     $this->db->group_by("fy.finiYear_id, fy.fini_Label");
//     $this->db->order_by("fy.finiYear_id", "ASC");
//     $response['yearData'] = $this->db->get()->result();
 
//     return $response;
// }
    
public function getStudentsByMeetId($fk_honor_minor_id)
{
    return $this->db->select('course_name, duration, start_date,end_date,grade,certificate_file,fk_year,
    finiyear_master.fini_Label, internduration_master.duration_type,')
                    ->from('honor_minor_course_details')
                     ->join('finiyear_master',' honor_minor_course_details.fk_year = finiyear_master.finiYear_id','left')
                    ->join(' internduration_master',' honor_minor_course_details.duration =  internduration_master.duration_id','left')
                    ->where('fk_honor_minor_id', $fk_honor_minor_id)
                    ->get()
                    ->result_array();
}
 

}