<?php
class Honor_Minor_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
        $this->db->db_debug = TRUE; 
    }

    public function insertdata($model)
    {
        $this->db->insert('honor_minor_master', $model);
        // return $this->db->affected_rows() > 0;
        if ($this->db->affected_rows() > 0) {
        return $this->db->insert_id(); // return parent ID
    }

    return false;
        
    }

    public function insertCourseDetail($model)
    {
        $this->db->insert('honor_minor_course_details', $model);
        if ($this->db->error()['code'] != 0) {
            log_message('error', 'Insert Course Detail Error: ' . json_encode($this->db->error()));
            log_message('error', 'Course Data: ' . json_encode($model));
            return false;
        }
        return $this->db->affected_rows() > 0;
    }

    public function getDurations()
    {
        $this->db->select('duration_id, duration_type, duration_months, duration_days');
        $this->db->from('internduration_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('duration_months', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
public function getRegisteredBranches()
{
    $this->db->select('branch_master.branch_id, branch_master.branch_name');
    $this->db->from('branch_master');
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    return $this->db->get()->result();
}

//           public function getRegisteredBranches()
// {
//     return $this->db->select('branch_master.branch_id, branch_master.branch_name')
//                     ->from('branch_master')
//                     ->get()
//                     ->result();
// }
    
    public function getdetailview()
    {
        $this->db->select('honor_minor_master.*, 
                              honor_minor_type_master.honor_minor_type_name,
                              branch_master.branch_name,
                              finiyear_master.fini_Label');
        $this->db->from('honor_minor_master');
        $this->db->join('honor_minor_type_master', 
                        'honor_minor_master.fk_honor_minor_type = honor_minor_type_master.honor_minor_type_id', 
                        'left');
                         $this->db->join('branch_master', 'honor_minor_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 
                        'honor_minor_master.fk_year = finiyear_master.finiYear_id', 
                        'left');
 $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }

        $this->db->order_by('honor_minor_master.honor_minor_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getbyid($id)
    {
        $this->db->select('honor_minor_master.*, 
                         honor_minor_type_master.honor_minor_type_name,
                         branch_master.branch_name,
                         finiyear_master.fini_Label');
        $this->db->from('honor_minor_master');
        $this->db->join('honor_minor_type_master', 
                         'honor_minor_master.fk_honor_minor_type = honor_minor_type_master.honor_minor_type_id', 
                         'left');
                        $this->db->join('branch_master', 'honor_minor_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 
                         'honor_minor_master.fk_year = finiyear_master.finiYear_id', 
                         'left');
        $this->db->where('honor_minor_master.honor_minor_id', $id);
        $query = $this->db->get();
        return $query->result(); 
    }

    public function update($model)
    {
        $this->db->where('honor_minor_id', $model['honor_minor_id']);
        $update_data = $model;
        unset($update_data['honor_minor_id']); 
        
        $this->db->update('honor_minor_master', $update_data);
        
        if ($this->db->error()['code'] != 0) {
            log_message('error', 'Update Honor Minor Error: ' . json_encode($this->db->error()));
            return false;
        }
        return true; 
    }

    public function getCourseDetailsByMainId($honor_minor_id)
    {
        $this->db->select('hmc.*, fy.fini_Label, dm.duration_type');
        $this->db->from('honor_minor_course_details hmc');
        $this->db->join('finiyear_master fy', 'hmc.fk_year = fy.finiYear_id', 'left');
        $this->db->join('internduration_master dm', 'hmc.duration = dm.duration_id', 'left');
        $this->db->where('hmc.fk_honor_minor_id', $honor_minor_id);
        $query = $this->db->get();
        return $query->result();
    }

    public function updateCourseDetail($id, $data)
    {
        $this->db->where('course_detail_id', $id);
        $this->db->update('honor_minor_course_details', $data);
        
        if ($this->db->error()['code'] != 0) {
            log_message('error', 'Update Course Detail Error: ' . json_encode($this->db->error()));
            log_message('error', 'Update Data: ' . json_encode($data));
            return false;
        }
        return true;
    }

    public function deleteCourseDetail($id)
    {
        $this->db->where('course_detail_id', $id);
        $this->db->delete('honor_minor_course_details');
        return $this->db->affected_rows() > 0;
    }

    public function getHonorMinorTypes()
    {
        $this->db->select('honor_minor_type_master.*');
        $this->db->from('honor_minor_type_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('honor_minor_type_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function insertHonorMinorType($model)
    {
        $this->db->insert('honor_minor_type_master', $model);
        return $this->db->affected_rows() > 0;
    }

    public function getDepartments()
    {
        $this->db->select('department_master.*');
        $this->db->from('department_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('dep_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getActiveYear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        $query = $this->db->get();
        return $query->row();
    }
}