<?php
  class HostelFee_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }

  public function insertdata($model)
{
    $this->db->where('fk_student', $model['fk_student']);
    $this->db->where('fk_hosteltype', $model['fk_hosteltype']);
    $this->db->where('finicial_Year', $model['finicial_Year']);
    $existing = $this->db->get('hostel_feemaster')->row();

    if ($existing) {
        // UPDATE
        $this->db->where('host_id', $existing->host_id)
                 ->update('hostel_feemaster', $model);

        return $existing->host_id; 
    } else {
        // INSERT
        $this->db->insert('hostel_feemaster', $model);
        return $this->db->insert_id(); 
    }
}


    //   public function insertdata($model)
	// {
	// 	return $this->db->insert('hostel_feemaster',$model);
	// 		//return $sql->result();
	// } 

    // PURANE getHostel() method ko REPLACE karein
public function getHostel() {
    $this->db->select('Hostel_id, Hostel_Name, hostel_fees');  // hostel_fees add kiya
    $this->db->from('hostel_master');
    $this->db->where('is_on', 1);
    $this->db->where('is_active', 1);
    $this->db->order_by('Hostel_Name', 'ASC');
    return $this->db->get()->result();
}

//      public function getHostel()
// {
//     $this->db->select('Hostel_id, Hostel_Name');
//     $this->db->from('hostel_master');
//     $query = $this->db->get();
//     return $query->result();


// }

public function getstudents()
{
    $this->db->select('Student_id, Student_Name,PRN');
    $this->db->from('studentfeedlist_master');
    $query = $this->db->get();
    return $query->result();


}
    public function getActiveYear()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    /**
     * Get all years
     */
 public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }

   
  public function getdetailview()
{
    $this->db->select('
        hostel_feemaster.host_id,
         hostel_feemaster.fk_hosteltype,
        hostel_feemaster.finicial_Year,
        hostel_feemaster.fk_student,
        hostel_feemaster.fees,
        hostel_master.Hostel_Name,
        finiyear_master.fini_Label,
        studentfeedlist_master.Student_Name,
        
    ');

    $this->db->from('hostel_feemaster');

    // Join with menu master
    $this->db->join(
        'hostel_master',
        'hostel_master.Hostel_id = hostel_feemaster.fk_hosteltype',
        'left'
    );

    // Join with form type master (correct relation)
    $this->db->join(
        'finiyear_master',
        'finiyear_master.finiYear_id = hostel_feemaster.finicial_Year',
        'left'
    );
$this->db->join(
        'studentfeedlist_master',
        'studentfeedlist_master.Student_id = hostel_feemaster.fk_student',
        'left'
    );
    $this->db->order_by('hostel_feemaster.host_id', 'DESC');

    $query = $this->db->get();
    return $query->result();
}

      public function getbyid($id)
		{
		  $this->db->select("hostel_feemaster.*,");
	    $this->db->where('host_id',$id);
      $query = $this->db->get('hostel_feemaster');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('host_id',$model['host_id'])->update('hostel_feemaster',$model); 
    } 

// Existing HostelFee_model.php mein ye methods ADD karein

// Method 1: Get hostel fees by ID
public function getHostelFeesById($hostel_id) {
    $this->db->select('hostel_fees');
    $this->db->from('hostel_master');
    $this->db->where('Hostel_id', $hostel_id);
    $this->db->where('is_active', 1);
    return $this->db->get()->row();
}

  // UPDATED: Get students by hostel AND year (dono filters)
    public function getStudentsByHostelAndYear($hostel_id, $year_id) {
        $this->db->select('s.Student_id, s.Student_Name, s.PRN');
        $this->db->from('studentfeedlist_master s');
        $this->db->where('s.fkHostelType_id', $hostel_id);
        $this->db->where('s.FiniYear', $year_id); // Year filter add kiya
        $this->db->where('s.is_active', 1);
        $this->db->order_by('s.PRN', 'ASC');
        return $this->db->get()->result();
    }

public function getStudentById($student_id) {
        $this->db->select('Student_id, Student_Name, PRN');
        $this->db->from('studentfeedlist_master');
        $this->db->where('Student_id', $student_id);
        $this->db->where('is_active', 1);
        return $this->db->get()->row();
    }

    public function getStudentPaymentHistory($student_id, $hostel_id, $year_id) {
    $this->db->select('
    host_id,
        first_date,
        first_installation,
        first_note,
        second_date,
        second_installation,
        second_note,
        pending
    ');
    $this->db->from('hostel_feemaster');
    $this->db->where('fk_student', $student_id);
    $this->db->where('fk_hosteltype', $hostel_id);
    $this->db->where('finicial_Year', $year_id);
    $this->db->order_by('host_id', 'DESC'); // Latest record pehle
    $this->db->limit(1);
    return $this->db->get()->row();
}

// // Method 2: Get students by hostel
// public function getStudentsByHostel($hostel_id) {
//     $this->db->select('s.Student_id, s.Student_Name');
//     $this->db->from('studentfeedlist_master s');
//     $this->db->where('s.fkHostelType_id', $hostel_id);
//     $this->db->where('s.is_active', 1);
//     $this->db->order_by('s.Student_Name', 'ASC');
//     return $this->db->get()->result();
// }


}