<?php
class ICTtools_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert ICT Tool data
    public function insertICTTool($data) {
         $this->db->insert('ict_tools_master', $data);
         return $this->db->insert_id();
    }

    // Get all ICT Tools with related data
    public function getdetailview()
    {      
        $this->db->select('ict_tools_master.ict_id,
                           ict_tools_master.fkbranch_id,
                           branch_master.branch_name,
                           ict_tools_master.fkfac_id,
                           faculty_master.fac_Fullname,
                           ict_tools_master.finicial_Year,
                           finiyear_master.fini_Label,
                           ict_tools_master.ict_link,
                           ict_tools_master.Desscription,
                           ict_tools_master.Publish_date');

        $this->db->from('ict_tools_master');
        $this->db->join('branch_master','ict_tools_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('faculty_master', 'ict_tools_master.fkfac_id = faculty_master.fac_id', 'left');
        $this->db->join('finiyear_master', 'ict_tools_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->where('ict_tools_master.is_active', 1);
        $this->db->order_by('ict_tools_master.ict_id','DESC');

        $query = $this->db->get();
        return $query->result();      
    }

    // ============================================
    // UPDATE & DELETE METHODS - NAYE METHODS
    // ============================================
    
    // Get single ICT Tool by ID
    public function getICTToolById($ict_id) {
        $this->db->select('ict_tools_master.*,
                           branch_master.branch_name,
                           faculty_master.fac_Fullname,
                           finiyear_master.fini_Label');
        $this->db->from('ict_tools_master');
        $this->db->join('branch_master', 'ict_tools_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('faculty_master', 'ict_tools_master.fkfac_id = faculty_master.fac_id', 'left');
        $this->db->join('finiyear_master', 'ict_tools_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('ict_tools_master.ict_id', $ict_id);
        $this->db->where('ict_tools_master.is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    // Update ICT Tool
    public function updateICTTool($ict_id, $data) {
        $this->db->where('ict_id', $ict_id);
        return $this->db->update('ict_tools_master', $data);
    }

    // Soft Delete ICT Tool
    public function deleteICTTool($ict_id) {
        $data = array(
            'is_active' => 0,
            'updated_date' => date('Y-m-d H:i:s')
        );
        $this->db->where('ict_id', $ict_id);
        return $this->db->update('ict_tools_master', $data);
    }

    // Hard Delete ICT Tool (permanent delete)
    public function permanentDeleteICTTool($ict_id) {
        $this->db->where('ict_id', $ict_id);
        return $this->db->delete('ict_tools_master');
    }

    // ============================================
    // MASTER DATA METHODS
    // ============================================

    // Insert new branch and return ID
    public function insertBranch($data) {
        if ($this->db->insert('branch_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new faculty and return ID
    public function insertFaculty($data) {
        if ($this->db->insert('faculty_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new year and return ID
    public function insertYear($data) {
        if ($this->db->insert('finiyear_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Get branch data
    public function getbranch() {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get faculty data  
    public function getfaculty() {
        $this->db->select('fac_id, fac_Fullname');
        $this->db->from('faculty_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fac_Fullname', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get year data  
    public function getyear() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fini_Label', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Check if branch exists by name
    public function branchExists($branch_name) {
        $this->db->where('LOWER(branch_name)', strtolower($branch_name));
        $query = $this->db->get('branch_master');
        return $query->num_rows() > 0;
    }
    
    // Check if faculty exists by name
    public function facultyExists($faculty_name) {
        $this->db->where('LOWER(fac_Fullname)', strtolower($faculty_name));
        $query = $this->db->get('faculty_master');
        return $query->num_rows() > 0;
    }
    
    // Check if year exists by name
    public function yearExists($year_name) {
        $this->db->where('LOWER(fini_Label)', strtolower($year_name));
        $query = $this->db->get('finiyear_master');
        return $query->num_rows() > 0;
    }
    
    // Get branch ID by name
    public function getBranchIdByName($branch_name) {
        $this->db->select('branch_id');
        $this->db->where('LOWER(branch_name)', strtolower($branch_name));
        $query = $this->db->get('branch_master');
        if ($query->num_rows() > 0) {
            return $query->row()->branch_id;
        }
        return false;
    }
    
    // Get faculty ID by name
    public function getFacultyIdByName($faculty_name) {
        $this->db->select('fac_id');
        $this->db->where('LOWER(fac_Fullname)', strtolower($faculty_name));
        $query = $this->db->get('faculty_master');
        if ($query->num_rows() > 0) {
            return $query->row()->fac_id;
        }
        return false;
    }
    
    // Get year ID by name
    public function getYearIdByName($year_name) {
        $this->db->select('finiYear_id');
        $this->db->where('LOWER(fini_Label)', strtolower($year_name));
        $query = $this->db->get('finiyear_master');
        if ($query->num_rows() > 0) {
            return $query->row()->finiYear_id;
        }
        return false;
    }
}
?>