<?php
  class Industrial_problereport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('industrial_problem_data',$model);
			//return $sql->result();
	} 


    //  public function getbranch()
    //  {
    //   $this->db->select('branch_master.*,');
    //   $this->db->from('branch_master');
    //   $query = $this->db->get();
    //     return $query->result();
    //  }

     public function getinstitu()
     {
      $this->db->select('institute_master.Institu_id,institute_master.Institu_name,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getcompany()
     {
      $this->db->select('industrial_problem_data.comp_name,');
      $this->db->from('industrial_problem_data');
       $query = $this->db->get();
        return $query->result();
     }

    //   public function getduration()
    //  {
    //   $this->db->select('internduration_master.*,');
    //   $this->db->from('internduration_master');
    //   $query = $this->db->get();
    //     return $query->result();
    //  }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.finiYear_id,finiyear_master.fini_Label');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


     



public function getDataByInstitute($institute_id,  $year_id, $company_ids, $startdate = null, $enddate = null)
{
    $this->db->select('
        industrial_problem_data.indus_id,
        industrial_problem_data.comp_name,
        industrial_problem_data.indus_Date,
        industrial_problem_data.fk_finalyear,
        industrial_problem_data.problem_statement,
        finiyear_master.fini_Label,');

    $this->db->from('industrial_problem_data');
      $this->db->join('finiyear_master', 'industrial_problem_data.fk_finalyear = finiyear_master.finiYear_id', 'left');
   

    $this->db->where('industrial_problem_data.Institute', $institute_id);

    if (!empty($company_ids)) {
        $this->db->where_in('industrial_problem_data.comp_name', $company_ids);
    }



    
//     if (!empty($year_id)) {
//     $this->db->where('industrial_problem_data.fk_finalyear', $year_id);
// }

if (!empty($year_id) && $year_id != 0) {
        $this->db->where('industrial_problem_data.fk_finalyear', $year_id);
 
    }

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('industrial_problem_data.indus_Date >=', $startdate);
        $this->db->where('industrial_problem_data.indus_Date <=', $enddate);
    }

      

        $this->db->order_by('industrial_problem_data.indus_Date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

  // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(industrial_problem_data.indus_id) as count")
        ->from("industrial_problem_data")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industrial_problem_data.fk_finalyear")
        ->group_by("industrial_problem_data.fk_finalyear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
 
public function getSingleYearData($yearId, $companies = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(industrial_problem_data.indus_id) as count")
        ->from("industrial_problem_data")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industrial_problem_data.fk_finalyear")
        ->where("industrial_problem_data.fk_finalyear", $yearId);
 
    
    if (!empty($companies)) {
        $this->db->where_in('industrial_problem_data.comp_name', (array)$companies);
    }
  
 
    $this->db->group_by("industrial_problem_data.fk_finalyear, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $companies = [],)
{
    $this->db->select("industrial_problem_data.indus_id, industrial_problem_data.comp_name,
    industrial_problem_data.problem_statement,
 industrial_problem_data.indus_Date,
     finiyear_master.fini_Label as year,")
        ->from("industrial_problem_data")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industrial_problem_data.fk_finalyear")
                // ->join('student_reg', 'student_reg.Student_id = industrial_problem_data.fk_student')
        ->where("industrial_problem_data.fk_finalyear", $yearId);
 
    
    if (!empty($companies)) {
        $this->db->where_in('industrial_problem_data.comp_name', (array)$companies);
    }
    
 
    return $this->db->get()->result_array();
}


    
public function getCompanywiseCount($institu = null, $companies = [], $year = null)
{
    $this->db->select('industrial_problem_data.comp_name,
                       COUNT(industrial_problem_data.indus_id) as problem_count');
    $this->db->from('industrial_problem_data');
 
    if (!empty($institu)) {
        $this->db->where('industrial_problem_data.Institute', $institu);
    }
    if (!empty($companies)) {
        $this->db->where_in('industrial_problem_data.comp_name', (array)$companies);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('industrial_problem_data.fk_finalyear', $year);
    }
 
    $this->db->group_by('industrial_problem_data.comp_name');
    $this->db->order_by('industrial_problem_data.comp_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getCompanyDetailsData($company_name, $institu = null, $year = null)
{
    $this->db->select('industrial_problem_data.problem_statement,
                       industrial_problem_data.indus_Date,
                       industrial_problem_data.comp_name,
                       finiyear_master.fini_Label');
    $this->db->from('industrial_problem_data');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = industrial_problem_data.fk_finalyear', 'left');

    if (is_array($company_name)) {
        $this->db->where_in('industrial_problem_data.comp_name', $company_name);
    } else {
        $this->db->where('industrial_problem_data.comp_name', $company_name);
    }
 
    if (!empty($institu)) {
        $this->db->where('industrial_problem_data.Institute', $institu);
    }

    if (!empty($year)) {
        if (is_array($year)) {
            $this->db->where_in('industrial_problem_data.fk_finalyear', $year);
        } else {
            $this->db->where('industrial_problem_data.fk_finalyear', $year);
        }
    }
 
    return $this->db->get()->result();
}
 
public function getCombinedData($institu = null, $companies = [], $years = [])
{
    $response = [];
 
    // --- 1. Companywise Count ---
    $this->db->select('industrial_problem_data.comp_name, COUNT(industrial_problem_data.indus_id) as problem_count');
    $this->db->from('industrial_problem_data');
 
    if (!empty($institu)) {
        $this->db->where('industrial_problem_data.Institute', $institu);
    }
    if (!empty($companies)) {
        $this->db->where_in('industrial_problem_data.comp_name', (array)$companies);
    }
    if (!empty($years)) {
        $this->db->where_in('industrial_problem_data.fk_finalyear', (array)$years);
    }
   
    $this->db->group_by('industrial_problem_data.comp_name');
    $this->db->order_by('industrial_problem_data.comp_name', 'ASC');
    $response['companyData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.indus_id) as count");
    $this->db->from("industrial_problem_data sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.fk_finalyear");
 
    if (!empty($institu)) {
        $this->db->where('sp.Institute', $institu);
    }
    if (!empty($companies)) {
        $this->db->where_in('sp.comp_name', (array)$companies);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.fk_finalyear', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}

}