<?php
  class IndustrialtranReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
   

 public function getindustDataFiltered($institu_id, $branch_ids = null, $company_ids = null, $year = null, $startdate = null, $enddate = null)
{
    $this->db->select('
        industrialtrain_master.*,
        branch_master.branch_name,
        company_master.comp_name,
        internduration_master.duration_type
    ');
    $this->db->from('industrialtrain_master');
    $this->db->join('branch_master', 'branch_master.branch_id = industrialtrain_master.fkbranch_id', 'left');
    $this->db->join('company_master', 'company_master.ID = industrialtrain_master.fkcomp_ID', 'left');
    $this->db->join('internduration_master', 'internduration_master.duration_id = industrialtrain_master.fkduration_id', 'left');

    if (!empty($institu_id)) {
        $this->db->where('industrialtrain_master.institute', $institu_id);
    }
    if (!empty($branch_ids)) {
        $this->db->where_in('industrialtrain_master.fkbranch_id', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($company_ids)) {
        $this->db->where_in('industrialtrain_master.fkcomp_ID', $company_ids);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('industrialtrain_master.finicial_Year', $year);
    }
    // ✅ Date filter condition
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('industrialtrain_master.StartDate >=', $startdate);
        $this->db->where('industrialtrain_master.EndDate <=', $enddate);
    }

    $this->db->group_by('industrialtrain_master.intrain_id');
    $this->db->order_by('industrialtrain_master.intrain_id', 'DESC');

    $query = $this->db->get();
    return $query->result();
}


 
     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }
 
     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
 
 
      public function getcompany() 
    {
        $this->db->select('ID, comp_name');
        $this->db->from('company_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
} 

// student list 

public function getStudentsByMeetId($fkintrain_id)
{
    return $this->db->select('student_name, fk_branch, prn_no, fk_class')
                    ->from('industrialtrain_student')
                    ->where('fkintrain_id', $fkintrain_id)
                    ->get()
                    ->result_array();
}
// Faculty list 

// Faculty list method - corrected table name
public function getfacultyByMeetId($fkintrain_id)
{
    return $this->db->select('faculty_name, fk_branch, fk_class')
                    ->from('industrialtrain_faculty')  // Changed table name from 'faculty_name' to 'industrialtrain_faculty'
                    ->where('fkintrain_id', $fkintrain_id)
                    ->get()
                    ->result_array();
}

    // new 

public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("industrialtrain_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industrialtrain_master.finicial_Year")
        ->group_by("industrialtrain_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("industrialtrain_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industrialtrain_master.finicial_Year")
        ->where("industrialtrain_master.finicial_Year", $yearId);

        if (!empty($branches)) {
                $this->db->where_in('industrialtrain_master.fkbranch_id', (array)$branches);
            }
             else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('industrialtrain_master.fkbranch_id', explode(',', $branchIds));
    }
}
            
        $this->db->group_by("industrialtrain_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
}


 
public function getYearwiseTypes($yearId, $branches = [],)
{
  $this->db->select("industrialtrain_master.intrain_id,
                     industrialtrain_master.Trainee_Details,
                     industrialtrain_master.fkbranch_id,
                     branch_master.branch_name,
                     industrialtrain_master.fkcomp_ID,
                     company_master.comp_name,
                     industrialtrain_master.fkduration_id,
                     internduration_master.duration_type,
                     industrialtrain_master.Feedback,
                     industrialtrain_master.StartDate,
                     industrialtrain_master.EndDate,
                    finiyear_master.fini_Label as year")
        ->from("industrialtrain_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industrialtrain_master.finicial_Year")
        ->join('branch_master', 'branch_master.branch_id = industrialtrain_master.fkbranch_id', 'left')
   ->join('company_master', 'company_master.ID = industrialtrain_master.fkcomp_ID', 'left')
   ->join('internduration_master', 'internduration_master.duration_id = industrialtrain_master.fkduration_id', 'left')
        ->where("industrialtrain_master.finicial_Year", $yearId);

        if (!empty($branches)) {
        $this->db->where_in('industrialtrain_master.fkbranch_id', (array)$branches);
       }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('industrialtrain_master.fkbranch_id', explode(',', $branchIds));
    }
}
         return $this->db->get()->result_array();
}
 
 
  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(industrialtrain_master.intrain_id) as indus_count');
    $this->db->from('branch_master');
    $this->db->join('industrialtrain_master', 'branch_master.branch_id = industrialtrain_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('industrialtrain_master.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('industrialtrain_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("industrialtrain_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('industrialtrain_master.intrain_id,
                     industrialtrain_master.Trainee_Details,
                     industrialtrain_master.fkbranch_id,
                     branch_master.branch_name,
                     industrialtrain_master.fkcomp_ID,
                     company_master.comp_name,
                     industrialtrain_master.fkduration_id,
                     internduration_master.duration_type,
                     industrialtrain_master.Feedback,
                     industrialtrain_master.StartDate,
                     industrialtrain_master.EndDate,');
    $this->db->from('industrialtrain_master');
    $this->db->join('branch_master', 'branch_master.branch_id = industrialtrain_master.fkbranch_id', 'left');
    $this->db->join('company_master', 'company_master.ID = industrialtrain_master.fkcomp_ID', 'left');
   $this->db->join('internduration_master', 'internduration_master.duration_id = industrialtrain_master.fkduration_id', 'left');
 
   if (is_array($branch_id)) {
    $this->db->where_in('industrialtrain_master.fkbranch_id', $branch_id);
} else {
    $this->db->where('industrialtrain_master.fkbranch_id', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('industrialtrain_master.institute', $institu);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('industrialtrain_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("industrialtrain_master.StartDate BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.intrain_id) as indus_count');
    $this->db->from('branch_master b');
    $this->db->join('industrialtrain_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.intrain_id) as count");
    $this->db->from("industrialtrain_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sr.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
   


}