<?php
  class Industry_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		 $this->db->insert('industry_master',$model);
			return $this->db->insert_id();
	} 

 public function insertclassdata($model)
	{
		return $this->db->insert('industry_class',$model);
			//return $sql->result();
	} 

    public function insertgallery($model)
	{
		return $this->db->insert('industry_multiphoto',$model);
			//return $sql->result();
	} 

   public function insertChild($model)
	{
		return $this->db->insert('industryvisit_student',$model);
			//return $sql->result();
	} 


     public function getdetailview()
     {      
      
        $this->db->select(' industry_master.indu_id,
        industry_master.fkbranch_id,
        industry_master.fkclass_id,
        industry_master.fk_company,
        industry_master.fk_div,
        industry_master.fk_sem,
        industry_master.Address,
        industry_master.startdate,
        industry_master.enddate,,branch_master.branch_name,division_master.div_name,
        classmaster.classname,semester_master.Sem_Name,');
        $this->db->from('industry_master');
          $this->db->join('branch_master', 'industry_master.fkbranch_id = branch_master.branch_id', 'left');
          $this->db->join('industry_class', 'industry_master.indu_id = industry_class.fk_indu_id', 'left');
    $this->db->join('classmaster', 'industry_master.fkclass_id = classmaster.class_id', 'left');
        $this->db->join('division_master', 'industry_master.fk_div = division_master.div_id', 'left');
                $this->db->join('semester_master', 'industry_master.fk_sem = semester_master.SemID', 'left');
                // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
                
        $this->db->group_by('industry_master.indu_id');
        $this->db->order_by('industry_master.indu_id','DESC');
        $query = $this->db->get();
        return $query->result();
             
     }

     public function getRegisteredBranches()
{
    $this->db->select('branch_master.branch_id, branch_master.branch_name');
    $this->db->from('branch_master');
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    return $this->db->get()->result();
}

 
 public function getdiv()
     {
      $this->db->select('division_master.*,');
      $this->db->from('division_master');
       $query = $this->db->get();
        return $query->result();
     }
 

public function getsem()
     {
      $this->db->select('semester_master.SemID,semester_master.Sem_Name');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getclass()
     {
      $this->db->select('classmaster.*,');
      $this->db->from('classmaster');
       $query = $this->db->get();
        return $query->result();
     }


     public function getfac()
     {
      $this->db->select('faculty_master.fac_id,faculty_master.fac_Fullname,');
      $this->db->from('faculty_master');
      $this->db->where('faculty_master.with_form', 1);
       $query = $this->db->get();
        return $query->result();
     }


      public function getbyid($id)
		{
		  $this->db->select(" industry_master.indu_id,
        industry_master.fkbranch_id,
        industry_master.fkclass_id,
        industry_master.fk_company,
        industry_master.fk_div,
        industry_master.fk_sem,
        industry_master.Address,
        industry_master.startdate,
        industry_master.enddate,
         industry_master.fac_1,
        industry_master.fac_2,
        industry_master.fac_3,
        industry_master.fac_4,
        industry_master.problem_report,
        industry_master.visit_photo,
        ");
	    $this->db->where('indu_id',$id);
      $query = $this->db->get('industry_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('indu_id',$model['indu_id'])->update('industry_master',$model); 
    } 

// Delete old class mappings
public function deleteclassdata($indu_id)
{
    return $this->db->where('fk_indu_id', $indu_id)
                    ->delete('industry_class');
}

public function getSelectedclass($indu_id)
{
    $this->db->select('fk_class');
    $this->db->from('industry_class');
    $this->db->where('fk_indu_id', $indu_id);
    $query = $this->db->get();

    // Return array of branch IDs
    return array_column($query->result_array(), 'fk_class');
}


 // Industry_model.php
public function get_company_details_by_id($company_id)
{
    return $this->db
        ->select('Address, GPS_location, logo')
        ->from('company_master')
        ->where('ID', $company_id)
        ->get()
        ->row();
}


public function fetch_company_details($company_id)
{
    $this->db->select('Address, GPS_location, logo');
    $this->db->from('company_master');
    $this->db->where('ID', $company_id);
    $query = $this->db->get();
    return $query->result();
}

 public function getChildByMainId($conf_id) {
        $this->db->select('*');
        $this->db->from('industryvisit_student');
        $this->db->where('fk_induID', $conf_id);
        return $this->db->get()->result();
    }

     // Update child record
    public function updateChild($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('industryvisit_student', $data);
    }

    // Delete single child record
    public function deleteChild($id) {
        $this->db->where('id', $id);
        return $this->db->delete('industryvisit_student');
    }

    // Delete child records by main ID (for complete refresh if needed)
    public function deleteChildByMainId($conf_id) {
        $this->db->where('fk_induID', $conf_id);
        return $this->db->delete('industryvisit_student');
    }

    public function getSelectedimage($intern_id)
{
    $this->db->select('pub_photo');
    $this->db->from('industry_multiphoto');
    $this->db->where('fk_induid', $intern_id);
    $query = $this->db->get();

    return array_column($query->result_array(), 'pub_photo');
}

}