<?php
class InventoryReport_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function getFilteredData($institu, $supplier = [], $category = [], $item = [], $year = null, $startDate = null, $endDate = null)
    {
        // Select inventory main data with related tables
        $this->db->select('
            inventory_main_master.Inventory_main_id,
            inventory_main_master.fkSupplier_id,
            supplier_master.Supplier_name,
            inventory_main_master.Date,
            inventory_main_master.Description,
            inventory_main_master.Grand_Total,
            inventory_main_master.finicial_Year,
            finiyear_master.fini_Label,
            inventory_master.fkItem_id,
            store_item_master.Item_name,
            store_item_master.fkCategory_ID,
            itemcategory_master.Category_name,
            inventory_master.fkUnit_ID,
            unit_master.Unit_name,
            inventory_master.Quantity,
            inventory_master.Rate,
            inventory_master.Total
        ');
        
        $this->db->from('inventory_main_master');
        
        // Join inventory_master (items detail table)
        $this->db->join('inventory_master', 
            'inventory_master.fkInventory_main_id = inventory_main_master.Inventory_main_id', 
            'left');
        
        // Join store_item_master for item details
        $this->db->join('store_item_master', 
            'inventory_master.fkItem_id = store_item_master.Item_id', 
            'left');
        
        // Join itemcategory_master for category details
        $this->db->join('itemcategory_master', 
            'store_item_master.fkCategory_ID = itemcategory_master.Category_id', 
            'left');
        
        // Join unit_master for unit details
        $this->db->join('unit_master', 
            'inventory_master.fkUnit_ID = unit_master.Unit_ID', 
            'left');
        
        // Join supplier_master
        $this->db->join('supplier_master', 
            'inventory_main_master.fkSupplier_id = supplier_master.Supplier_id', 
            'left');
        
        // Join financial year
        $this->db->join('finiyear_master', 
            'inventory_main_master.finicial_Year = finiyear_master.finiYear_id', 
            'left');

        // Institute filter
        if (!empty($institu)) {
            $this->db->where('inventory_main_master.institute', $institu);
        }

        // Supplier filter (multiple)
        if (!empty($supplier)) {
            if (is_array($supplier)) {
                $this->db->where_in('inventory_main_master.fkSupplier_id', $supplier);
            } else {
                $this->db->where('inventory_main_master.fkSupplier_id', $supplier);
            }
        }

        // Category filter (multiple) - NEW
        if (!empty($category)) {
            if (is_array($category)) {
                $this->db->where_in('store_item_master.fkCategory_ID', $category);
            } else {
                $this->db->where('store_item_master.fkCategory_ID', $category);
            }
        }

        // Item filter (multiple) - NEW
        if (!empty($item)) {
            if (is_array($item)) {
                $this->db->where_in('inventory_master.fkItem_id', $item);
            } else {
                $this->db->where('inventory_master.fkItem_id', $item);
            }
        }

        // Year filter
        if (!empty($year) && $year != 0) {
            $this->db->where('inventory_main_master.finicial_Year', $year);
        }

        // Date range filter
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(inventory_main_master.Date) BETWEEN '$startDate' AND '$endDate'");
        } elseif (!empty($startDate)) {
            $this->db->where("DATE(inventory_main_master.Date) >= '$startDate'");
        } elseif (!empty($endDate)) {
            $this->db->where("DATE(inventory_main_master.Date) <= '$endDate'");
        }

        // Active records only
        $this->db->where('inventory_main_master.is_active', 1);

        $this->db->order_by('inventory_main_master.Date', 'DESC');
        $this->db->order_by('inventory_main_master.Inventory_main_id', 'DESC');
        
        return $this->db->get()->result();
    }

    public function getsupplier()
    {
        $this->db->select('Supplier_id, Supplier_name, Con_person_name, Phone, GST_no');
        $this->db->from('supplier_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Supplier_name', 'ASC');
        return $this->db->get()->result();
    }

    // NEW: Get all categories
    public function getCategory()
    {
        $this->db->select('Category_id, Category_name');
        $this->db->from('itemcategory_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Category_name', 'ASC');
        return $this->db->get()->result();
    }

    // NEW: Get all items
    public function getItems()
    {
        $this->db->select('store_item_master.Item_id, store_item_master.Item_name, store_item_master.fkCategory_ID, itemcategory_master.Category_name');
        $this->db->from('store_item_master');
        $this->db->join('itemcategory_master', 'store_item_master.fkCategory_ID = itemcategory_master.Category_id', 'left');
        $this->db->where('store_item_master.is_active', 1);
        $this->db->order_by('store_item_master.Item_name', 'ASC');
        return $this->db->get()->result();
    }

    // NEW: Get items by category (for dynamic dropdown)
    public function getItemsByCategory($category_id)
    {
        $this->db->select('Item_id, Item_name');
        $this->db->from('store_item_master');
        $this->db->where('fkCategory_ID', $category_id);
        $this->db->where('is_active', 1);
        $this->db->order_by('Item_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getyear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getinstitu()
    {
        $this->db->select('*');
        $this->db->from('institute_master');
        $this->db->order_by('Institu_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}