<?php
class JobStudentReport_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // ✅ UPDATED METHOD - Added class_ids and nature_ids parameters
    public function getjobStudentDataFiltered($institu_id, $branch_ids = null, $class_ids = null, $nature_ids = null, $year = null, $startdate = null, $enddate = null)
    {
        $this->db->select('
            jobstudent_master.jobstud_id,
            jobstudent_master.fknature_id,
            naturework_master.nature_name,
            jobstudent_master.fkfac_id,
            faculty_master.fac_Fullname,
            jobstudent_master.fkbranch_id,
            branch_master.branch_name,
            jobstudent_master.jobstud_name,
            jobstudent_master.fkclass_id,
            classmaster.classname,
            jobstudent_master.studcontact,
            jobstudent_master.Duration,
            jobstudent_master.workingDays,
            jobstudent_master.paydetails,
            jobstudent_master.StartDate,
            jobstudent_master.EndDate,
            jobstudent_master.institute,
            jobstudent_master.finicial_Year,
            finiyear_master.fini_Label
        ');
        
        $this->db->from('jobstudent_master');
        $this->db->join('branch_master','jobstudent_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('faculty_master','jobstudent_master.fkfac_id = faculty_master.fac_id','left');
        $this->db->join('finiyear_master','jobstudent_master.finicial_Year = finiyear_master.finiYear_id','left');
        $this->db->join('naturework_master', 'jobstudent_master.fknature_id = naturework_master.nature_id', 'left');
        $this->db->join('classmaster', 'jobstudent_master.fkclass_id = classmaster.class_id', 'left');

        // Institute Filter
        if (!empty($institu_id)) {
            $this->db->where('jobstudent_master.institute', $institu_id);
        }
        
        // Branch Filter
        if (!empty($branch_ids)) {
            $this->db->where_in('jobstudent_master.fkbranch_id', $branch_ids);
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
        
        // ✅ NEW: Class Filter
        if (!empty($class_ids)) {
            $this->db->where_in('jobstudent_master.fkclass_id', $class_ids);
        }
        
        // ✅ NEW: Nature of Work Filter
        if (!empty($nature_ids)) {
            $this->db->where_in('jobstudent_master.fknature_id', $nature_ids);
        }
        
        // Year Filter
        if (!empty($year) && $year != 0) {
            $this->db->where('jobstudent_master.finicial_Year', $year);
        }
        
        // Date Range Filter
        if (!empty($startdate) && !empty($enddate)) {
            $this->db->where('jobstudent_master.StartDate >=', $startdate);
            $this->db->where('jobstudent_master.StartDate <=', $enddate);
        }

        $this->db->order_by('jobstudent_master.jobstud_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }

    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getclass()
    {
        $this->db->select('classmaster.*');
        $this->db->from('classmaster');
        $query = $this->db->get();
        return $query->result();
    }

    public function getworktype()
    {
        $this->db->select('naturework_master.*');
        $this->db->from('naturework_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

    // ✅ UPDATED: Added class and nature filters
    public function getAllYearsData($branches = [], $classes = [], $natures = [])
    {
        $this->db->select("finiyear_master.finiYear_id as year_id, 
                           fini_Label as year, COUNT(jobstudent_master.jobstud_id) as count")
            ->from("jobstudent_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = jobstudent_master.finicial_Year");

        if (!empty($branches)) {
            $this->db->where_in('jobstudent_master.fkbranch_id', (array)$branches);
        }
        if (!empty($classes)) {
            $this->db->where_in('jobstudent_master.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('jobstudent_master.fknature_id', (array)$natures);
        }

        $this->db->group_by("jobstudent_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
    }

    // ✅ UPDATED: Added class and nature filters
    public function getSingleYearData($yearId, $branches = [], $classes = [], $natures = [])
    {
        $this->db->select("finiyear_master.finiYear_id as year_id,
                           fini_Label as year, COUNT(jobstudent_master.jobstud_id) as count")
            ->from("jobstudent_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = jobstudent_master.finicial_Year")
            ->where("jobstudent_master.finicial_Year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('jobstudent_master.fkbranch_id', (array)$branches);
        }
         else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('jobstudent_master.fkbranch_id', explode(',', $branchIds));
    }
}
        if (!empty($classes)) {
            $this->db->where_in('jobstudent_master.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('jobstudent_master.fknature_id', (array)$natures);
        }

        $this->db->group_by("jobstudent_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
    }

    // ✅ UPDATED: Added class and nature filters
    public function getYearwiseTypes($yearId, $branches = [], $classes = [], $natures = [])
    {
        $this->db->select("jobstudent_master.jobstud_id, 
                           jobstudent_master.jobstud_name,
                           jobstudent_master.fknature_id,
                           naturework_master.nature_name,
                            finiyear_master.fini_Label as year")
            ->from("jobstudent_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = jobstudent_master.finicial_Year")
            ->join('naturework_master', 'jobstudent_master.fknature_id = naturework_master.nature_id', 'left')
            ->where("jobstudent_master.finicial_Year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('jobstudent_master.fkbranch_id', (array)$branches);
        }
         else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('jobstudent_master.fkbranch_id', explode(',', $branchIds));
    }
}
        if (!empty($classes)) {
            $this->db->where_in('jobstudent_master.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('jobstudent_master.fknature_id', (array)$natures);
        }
        
        return $this->db->get()->result_array();
    }

    // ✅ UPDATED: Added class and nature filters
    public function getBranchwiseCount($institu = null, $branches = [], $classes = [], $natures = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('branch_master.branch_id, branch_master.branch_name, COUNT(jobstudent_master.jobstud_id) as jobstud_count');
        $this->db->from('branch_master');
        $this->db->join('jobstudent_master', 'branch_master.branch_id = jobstudent_master.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('jobstudent_master.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('branch_master.branch_id', (array)$branches);
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
        if (!empty($classes)) {
            $this->db->where_in('jobstudent_master.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('jobstudent_master.fknature_id', (array)$natures);
        }
        if (!empty($year) && $year != 0) {
            $this->db->where('jobstudent_master.finicial_Year', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('jobstudent_master.StartDate >=', $startDate);
            $this->db->where('jobstudent_master.StartDate <=', $endDate);
        }

        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');

        return $this->db->get()->result();
    }

    // ✅ UPDATED: Added class and nature filters
    public function getBranchDetailsData($branch_id, $institu = null, $classes = [], $natures = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('jobstudent_master.jobstud_name,
                           jobstudent_master.jobstud_id, 
                           jobstudent_master.fkbranch_id,
                            branch_master.branch_name,
                            jobstudent_master.fknature_id,
                            naturework_master.nature_name');
        $this->db->from('jobstudent_master');
        $this->db->join('branch_master', 'branch_master.branch_id = jobstudent_master.fkbranch_id', 'left');
         $this->db->join('naturework_master', 'jobstudent_master.fknature_id = naturework_master.nature_id', 'left');

        if (is_array($branch_id)) {
            $this->db->where_in('jobstudent_master.fkbranch_id', $branch_id);
        } else {
            $this->db->where('jobstudent_master.fkbranch_id', $branch_id);
        }

        if (!empty($institu)) {
            $this->db->where('jobstudent_master.institute', $institu);
        }
        if (!empty($classes)) {
            $this->db->where_in('jobstudent_master.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('jobstudent_master.fknature_id', (array)$natures);
        }
        if (!empty($year) && $year != 0) {
            $this->db->where('jobstudent_master.finicial_Year', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('jobstudent_master.StartDate >=', $startDate);
            $this->db->where('jobstudent_master.StartDate <=', $endDate);
        }

        return $this->db->get()->result();
    }

    // ✅ UPDATED: Added class and nature filters
    public function getCombinedData($institu = null, $branches = [], $classes = [], $natures = [], $years = [], $startDate = null, $endDate = null)
    {
        $response = [];

        // Branchwise Count
        $this->db->select('b.branch_id, b.branch_name, COUNT(sr.jobstud_id) as jobstud_count');
        $this->db->from('branch_master b');
        $this->db->join('jobstudent_master sr', 'b.branch_id = sr.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('sr.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('b.branch_id', (array)$branches);
        }
         else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
        if (!empty($classes)) {
            $this->db->where_in('sr.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('sr.fknature_id', (array)$natures);
        }
        if (!empty($years)) {
            $this->db->where_in('sr.finicial_Year', (array)$years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('sr.StartDate >=', $startDate);
            $this->db->where('sr.StartDate <=', $endDate);
        }

        $this->db->group_by('b.branch_id, b.branch_name');
        $this->db->order_by('b.branch_name', 'ASC');
        $response['branchData'] = $this->db->get()->result();

        // Yearwise Count
        $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.jobstud_id) as count");
        $this->db->from("jobstudent_master sr");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");

        if (!empty($institu)) {
            $this->db->where('sr.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('sr.fkbranch_id', (array)$branches);
        }
         else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}
        if (!empty($classes)) {
            $this->db->where_in('sr.fkclass_id', (array)$classes);
        }
        if (!empty($natures)) {
            $this->db->where_in('sr.fknature_id', (array)$natures);
        }
        if (!empty($years)) {
            $this->db->where_in('sr.finicial_Year', (array)$years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('sr.StartDate >=', $startDate);
            $this->db->where('sr.StartDate <=', $endDate);
        }

        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();

        return $response;
    }
}
?>