<?php
class JobStudent_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Insert child record directly to jobstudent_master
    public function insertChild($data) {
         $this->db->insert('jobstudent_master', $data);
         return $this->db->insert_id();
    }

    public function getdetailview() {
    $this->db->select('jobstudent_master.jobstud_id,
                      jobstudent_master.fkbranch_id,
                      branch_master.branch_name,
                      jobstudent_master.fkfac_id,
                      faculty_master.fac_Fullname,
                      jobstudent_master.fkclass_id,
                      classmaster.classname,
                      jobstudent_master.fknature_id,
                      naturework_master.nature_name,
                       jobstudent_master.studcontact,
                        jobstudent_master.Duration,
                         jobstudent_master.jobstud_name,
                         jobstudent_master.workingDays,
                          jobstudent_master.paydetails,
                      jobstudent_master.StartDate,
                       jobstudent_master.EndDate,
                      jobstudent_master.finicial_Year,
                      jobstudent_master.excel_name,
                      finiyear_master.fini_Label');
    $this->db->from('jobstudent_master');
    $this->db->join('branch_master','jobstudent_master.fkbranch_id = branch_master.branch_id','left');
     $this->db->join('classmaster','jobstudent_master.fkclass_id = classmaster.class_id','left');
    $this->db->join('naturework_master','jobstudent_master.fknature_id = naturework_master.nature_id','left');
    $this->db->join('faculty_master','jobstudent_master.fkfac_id = faculty_master.fac_id','left');
    $this->db->join('finiyear_master','jobstudent_master.finicial_Year = finiyear_master.finiYear_id','left');
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    $this->db->order_by('jobstudent_master.jobstud_id','DESC');
    $query = $this->db->get();
    return $query->result();
}

    public function getclass() {
        $this->db->select('class_id, classname');
        $this->db->from('classmaster');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getbranch() {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }

    public function getFac()
    {
        $this->db->select('faculty_master.*');
        $this->db->from('faculty_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }
    public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}

    // Get record by ID from jobstudent_master
    public function getMainById($id) {
        $this->db->select('*');
        $this->db->from('jobstudent_master');
        $this->db->where('jobstud_id', $id);
        return $this->db->get()->row();
    }
    
    // Get child records by main ID (using jobstud_id as main_id)
    public function getChildByMainId($main_id) {
        $this->db->select('*');
        $this->db->from('jobstudent_master');
        $this->db->where('jobstud_id', $main_id);
        return $this->db->get()->result();
    }

  public function updateRow($id, $data)
{
    $this->db->where('jobstud_id', $id);
    return $this->db->update('jobstudent_master', $data);
}


    // Branch
    public function getBranchByName($name) {
        return $this->db->where('LOWER(branch_name)', strtolower(trim($name)))
                        ->get('branch_master')->row();
    }
    public function insertBranch($data) {
        $this->db->insert('branch_master', $data);
        return $this->db->insert_id();
    }
// Add this method to JobStudent_model.php

// Faculty methods
public function getFacultyByName($name) {
    return $this->db->where('LOWER(fac_Fullname)', strtolower(trim($name)))
                    ->get('faculty_master')->row();
}

public function insertFaculty($data) {
    $this->db->insert('faculty_master', $data);
    return $this->db->insert_id();
}
    // Class
    public function getClassByName($name) {
        return $this->db->where('LOWER(classname)', strtolower(trim($name)))
                        ->get('classmaster')->row();
    }
    public function insertClass($data) {
        $this->db->insert('classmaster', $data);
        return $this->db->insert_id();
    }

    // Nature of Work
    public function getNatureWork() {
        $this->db->select('nature_id, nature_name');
        $this->db->from('naturework_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getNatureWorkByName($name) {
        return $this->db->where('LOWER(nature_name)', strtolower(trim($name)))
                        ->get('naturework_master')->row();
    }

    public function insertNatureWork($data) {
        $this->db->insert('naturework_master', $data);
        return $this->db->insert_id();
    }
}
?>