<?php
  class LateMark_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('reg_fac_leave_master',$model);
			//return $sql->result();
	} 

     public function getdetailview()
{      
    $this->db->select('reg_fac_leave_master.reg_id,
                       reg_fac_leave_master.fkbranch_id,
                       branch_master.branch_name,
                       reg_fac_leave_master.fkfac_id,
                       faculty_master.fac_Fullname,
                       reg_fac_leave_master.fkleaveCat_id,
                       leavecat_master.leave_name,
                       reg_fac_leave_master.no_of_LeaveDays,
                       reg_fac_leave_master.Leave_date,
                       reg_fac_leave_master.LateMark,
                       reg_fac_leave_master.Lateday
                       ');

    $this->db->from('reg_fac_leave_master');
    $this->db->join('leavecat_master','reg_fac_leave_master.fkleaveCat_id = leavecat_master.leaveCat_id','left');
    $this->db->join('branch_master','reg_fac_leave_master.fkbranch_id = branch_master.branch_id','left');
    $this->db->join('faculty_master','reg_fac_leave_master.fkfac_id = faculty_master.fac_id','left'); // ✅ Added this line

    $this->db->order_by('reg_fac_leave_master.reg_id','DESC');

    $query = $this->db->get();
    return $query->result();      
}



   

    public function getFac()
  {      
   
     $this->db->select('faculty_master.*');
     $this->db->from('faculty_master');
     $query = $this->db->get();
     return $query->result();

          
  }

   public function getleave()
  {      
   
     $this->db->select('leavecat_master.*');
     $this->db->from('leavecat_master');
     $query = $this->db->get();
     return $query->result();

          
  }

 public function getbranch()
{
    $this->db->select('branch_id, branch_name');
    $this->db->from('branch_master');
    $query = $this->db->get();
    return $query->result();
}

public function getExtraLeaveDays($fac_id)
{
    $this->db->select('fkleaveCat_id, no_of_LeaveDays, Leave_date, LateMark, Lateday');
    $this->db->from('reg_fac_leave_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('is_active', 1);

    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';
    $this->db->where_in('fkfiniYear_id', "($subQuery)", FALSE);

    $query = $this->db->get()->result();

    $grouped = [];
    foreach ($query as $row) {
        $grouped[$row->fkleaveCat_id][] = $row;
    }

    return $grouped;
}




public function getAllLeaveStatus($fac_id)
{
    $this->db->select("
        abc.leaveCat_id,
        abc.leave_name,
        CASE 
            WHEN fy.finiYear_id IS NOT NULL AND fy.Active_Deactive = 1 THEN
                CASE MONTH(f.joining_date)
                    WHEN 1 THEN abc.January
                    WHEN 2 THEN abc.February
                    WHEN 3 THEN abc.March
                    WHEN 4 THEN abc.April
                    WHEN 5 THEN abc.May
                    WHEN 6 THEN abc.June
                    WHEN 7 THEN abc.July
                    WHEN 8 THEN abc.August
                    WHEN 9 THEN abc.September
                    WHEN 10 THEN abc.October
                    WHEN 11 THEN abc.November
                    WHEN 12 THEN abc.December
                END
            ELSE abc.April
        END AS joining_month_value
    ");
    $this->db->from("(SELECT 
                        leaveCat_id,
                        leave_name,
                        January,
                        February,
                        March,
                        April,
                        May,
                        June,
                        July,
                        August,
                        September,
                        October,
                        November,
                        December
                     FROM leavecat_master) AS abc");
    $this->db->join('faculty_master f', 'f.fac_id = ' . (int)$fac_id, 'left');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = f.finicial_Year AND fy.Active_Deactive = 1', 'left');

    $leaveCategories = $this->db->get()->result();


    
    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';


    $this->db->select('LeaveType, SUM(No_of_days) as total_days');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('HOD_Approval !=', 2);
    $this->db->where('REG_Approval !=', 2);
    $this->db->where('Princ_Approval !=', 2);
    $this->db->where_in('finicial_Year', "($subQuery)", FALSE);
    $this->db->group_by('LeaveType');
    $leaveSums = $this->db->get()->result();

    $sums = [];
    foreach ($leaveSums as $row) {
        $sums[$row->LeaveType] = $row->total_days;
    }



    $this->db->select('
        lm.Leave_from,
        lm.Leave_to,
        lm.No_of_days,
        lm.Leave_Reas,
        lm.LeaveType,
        lm.HOD_Approval,
        lm.REG_Approval,
        lm.created_date,
        lm.Princ_Approval,
        lm.ApprovedDays,
        fm.fac_Fullname AS altFaculty
    ');
    $this->db->from('leaveapp_master lm');
    $this->db->join('faculty_master fm', 'lm.fkAlternative_id = fm.fac_id', 'left');
    $this->db->where('lm.fkfac_id', $fac_id);
    $this->db->where_in('lm.finicial_Year', "($subQuery)", FALSE);
    $this->db->order_by('lm.created_date', 'DESC');

    $records = $this->db->get()->result();

    $recordGrouped = [];
    foreach ($records as $r) {
        $recordGrouped[$r->LeaveType][] = $r;
    }



    $output = [];
    foreach ($leaveCategories as $cat) {
        $cat_id = $cat->leaveCat_id;
        $output[] = [
            'id'      => $cat_id,
            'name'    => $cat->leave_name,
            'max'     => $cat->joining_month_value,
            'used'    => isset($sums[$cat_id]) ? $sums[$cat_id] : 0,
            'records' => isset($recordGrouped[$cat_id]) ? $recordGrouped[$cat_id] : []
        ];
    }

    return $output;
}

      public function getbyid($id)
		{
		  $this->db->select("reg_fac_leave_master.*,");
	    $this->db->where('reg_id',$id);
      $query = $this->db->get('reg_fac_leave_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('reg_id',$model['reg_id'])->update('reg_fac_leave_master',$model); 
    } 




public function getFacultyByBranchId($branch_id)
{
    $this->db->select('*');
    $this->db->from('faculty_master');
    $this->db->where('fkbranch_id', $branch_id);
    $query = $this->db->get();
    return $query->result();
}


}