<?php
  class LeaveReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
       public function insertdata($model)
      {
        return $this->db->insert('leaveapp_master',$model);
        //return $sql->result();
      }

      public function getbranch()
{
    $this->db->select('branch_id, branch_name');
    $this->db->from('branch_master');
    $query = $this->db->get();
    return $query->result();
 
}
  public function getFac()
  {      
   
     $this->db->select('faculty_master.*');
     $this->db->from('faculty_master');
     $query = $this->db->get();
     return $query->result();

          
  }
   public function getyear()
  {      
   
     $this->db->select('finiyear_master.*');
     $this->db->from('finiyear_master');
     $query = $this->db->get();
     return $query->result();
 
         
  }
  
public function getYearRangeById($year_id)
{
    $this->db->select('StartDate, EndDate');
    $this->db->from('finiyear_master');
    $this->db->where('finiYear_id', $year_id);
    $query = $this->db->get();
    return $query->row();
}

public function getFacultyByBranch($branch_id)
{
    $this->db->select('fac_id, fac_Fullname');
    $this->db->from('faculty_master');
    $this->db->where('fkbranch_id', $branch_id);
    $query = $this->db->get();
    return $query->result();
}



public function getExtraLeaveDays($fac_id)
{
    $this->db->select('fkleaveCat_id, no_of_LeaveDays, Leave_date, LateMark, Lateday');
    $this->db->from('reg_fac_leave_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('is_active', 1);
 
    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';
    $this->db->where_in('fkfiniYear_id', "($subQuery)", FALSE);
 
    $query = $this->db->get()->result();
 
    $grouped = [];
    foreach ($query as $row) {
        $grouped[$row->fkleaveCat_id][] = $row;
    }
 
    return $grouped;
}
 
 
 
 
public function getAllLeaveStatus($fac_id)
{
    $this->db->select("
        abc.leaveCat_id,
        abc.leave_name,
        CASE
            WHEN fy.finiYear_id IS NOT NULL AND fy.Active_Deactive = 1 THEN
                CASE MONTH(f.joining_date)
                    WHEN 1 THEN abc.January
                    WHEN 2 THEN abc.February
                    WHEN 3 THEN abc.March
                    WHEN 4 THEN abc.April
                    WHEN 5 THEN abc.May
                    WHEN 6 THEN abc.June
                    WHEN 7 THEN abc.July
                    WHEN 8 THEN abc.August
                    WHEN 9 THEN abc.September
                    WHEN 10 THEN abc.October
                    WHEN 11 THEN abc.November
                    WHEN 12 THEN abc.December
                END
            ELSE abc.April
        END AS joining_month_value
    ");
    $this->db->from("(SELECT
                        leaveCat_id,
                        leave_name,
                        January,
                        February,
                        March,
                        April,
                        May,
                        June,
                        July,
                        August,
                        September,
                        October,
                        November,
                        December
                     FROM leavecat_master) AS abc");
    $this->db->join('faculty_master f', 'f.fac_id = ' . (int)$fac_id, 'left');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = f.finicial_Year AND fy.Active_Deactive = 1', 'left');
 
    $leaveCategories = $this->db->get()->result();
 
 
   
    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';
 
 
    $this->db->select('LeaveType, SUM(No_of_days) as total_days');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('HOD_Approval !=', 2);
    $this->db->where('REG_Approval !=', 2);
    $this->db->where('Princ_Approval !=', 2);
    $this->db->where_in('finicial_Year', "($subQuery)", FALSE);
    $this->db->group_by('LeaveType');
    $leaveSums = $this->db->get()->result();
 
    $sums = [];
    foreach ($leaveSums as $row) {
        $sums[$row->LeaveType] = $row->total_days;
    }
 
 
 
    $this->db->select('
        lm.Leave_from,
        lm.Leave_to,
        lm.No_of_days,
        lm.Leave_Reas,
        lm.LeaveType,
        lm.HOD_Approval,
        lm.REG_Approval,
        lm.created_date,
        lm.Princ_Approval,
        lm.ApprovedDays,
        fm.fac_Fullname AS altFaculty
    ');
    $this->db->from('leaveapp_master lm');
    $this->db->join('faculty_master fm', 'lm.fkAlternative_id = fm.fac_id', 'left');
    $this->db->where('lm.fkfac_id', $fac_id);
    $this->db->where_in('lm.finicial_Year', "($subQuery)", FALSE);
    $this->db->order_by('lm.created_date', 'DESC');
 
    $records = $this->db->get()->result();
 
    $recordGrouped = [];
    foreach ($records as $r) {
        $recordGrouped[$r->LeaveType][] = $r;
    }
 
 
 
    $output = [];
    foreach ($leaveCategories as $cat) {
        $cat_id = $cat->leaveCat_id;
        $output[] = [
            'id'      => $cat_id,
            'name'    => $cat->leave_name,
            'max'     => $cat->joining_month_value,
            'used'    => isset($sums[$cat_id]) ? $sums[$cat_id] : 0,
            'records' => isset($recordGrouped[$cat_id]) ? $recordGrouped[$cat_id] : []
        ];
    }
 
    return $output;
}
 

 
public function getLeaveByBranch($branch_id, $from_date, $to_date, $faculty_id = null)
{
    $this->db->select("leaveapp_master.LeaveApp_id,
                       leaveapp_master.fkbranch_id,
                       branch_master.branch_name,
                       leaveapp_master.fkfac_id,
                       faculty_master.fac_Fullname AS faculty_name,
                       alt.fac_Fullname AS alt_name,
                       leaveapp_master.LeaveType,
                       leavecat_master.leave_name,
                       leaveapp_master.Leave_from,
                       leaveapp_master.Leave_to,
                       leaveapp_master.created_date,
                       leaveapp_master.ApprovedDays,
                       leaveapp_master.No_of_days,
                       hodflag.color_code AS hod_color,
                       princflag.color_code AS princ_color,
                       regflag.color_code AS reg_color,
                       hodflag.flag_name AS hod_status,
                       regflag.flag_name AS reg_status,
                       princflag.flag_name AS princ_status");

    $this->db->from('leaveapp_master');
   
    $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->join('faculty_master alt', 'leaveapp_master.fkAlternative_id = alt.fac_id', 'left');
     $this->db->join('branch_master', 'faculty_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('flag_master AS hodflag', 'leaveapp_master.HOD_Approval = hodflag.flag_value', 'left');
    $this->db->join('flag_master AS regflag', 'leaveapp_master.REG_Approval = regflag.flag_value', 'left');
    $this->db->join('flag_master AS princflag', 'leaveapp_master.Princ_Approval = princflag.flag_value', 'left');

    // Apply filters only if provided
    if (!empty($branch_id)) {
    $this->db->where('faculty_master.fkbranch_id', $branch_id);
}


    if (!empty($from_date) && !empty($to_date)) {
    $this->db->where('leaveapp_master.Leave_from <=', $to_date);
    $this->db->where('leaveapp_master.Leave_to >=', $from_date);
}


    if (!empty($faculty_id)) {
        $this->db->where('leaveapp_master.fkfac_id', $faculty_id);
    }

    $this->db->order_by('leaveapp_master.Leave_from', 'DESC');
    return $this->db->get()->result();
}





public function getLeaveByBranchPri($branch_id, $from_date, $to_date)
{
    $this->db->select("leaveapp_master.LeaveApp_id,
                       leaveapp_master.fkfac_id,
                       faculty_master.fac_Fullname,
                       leaveapp_master.LeaveType,
                       leavecat_master.leave_name,
                       leaveapp_master.created_date,
                       leaveapp_master.No_of_days,
                       CASE
                           WHEN leaveapp_master.HOD_Approval = 0 THEN 'HOD Processing'
                           WHEN leaveapp_master.REG_Approval = 0 THEN 'Registrar Processing'
                           WHEN leaveapp_master.Princ_Approval = 0 THEN 'Principal Processing'
                           ELSE 'Completed'
                       END AS status");

    $this->db->from('leaveapp_master');
    $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');

    $this->db->where('leaveapp_master.fkbranch_id', $branch_id);
    
    if (!empty($from_date) && !empty($to_date)) {
        $this->db->where('leaveapp_master.created_date >=', $from_date);
        $this->db->where('leaveapp_master.created_date <=', $to_date);
    }

    return $this->db->get()->result();
}

    }