<?php
class Library_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // ==================== LIBRARY EXCEL TABLE FUNCTIONS ====================
    
    public function insertExcelRecord($data)
    {
        $this->db->insert('library_excel', $data);
        
        $error = $this->db->error();
        if ($error['code'] != 0) {
            log_message('error', 'Model insert error: ' . print_r($error, true));
            return false;
        }
        
        $insert_id = $this->db->insert_id();
        
        if ($insert_id && $insert_id > 0) {
            return $insert_id;
        }
        
        return false;
    }

    public function deleteExcelRecord($excel_id)
    {
        $this->db->where('excel_id', $excel_id);
        return $this->db->delete('library_excel');
    }

    public function getExcelById($excel_upload_id)
    {
        $this->db->where('excel_upload_id', $excel_upload_id);
        return $this->db->get('library_master')->row();
    }

    // ==================== LIBRARY MASTER TABLE FUNCTIONS ====================
    
    public function insertLibraryMaster($data)
    {
     $this->db->insert('library_master', $data);
     return $this->db->insert_id();
    }

    public function updateLibraryMaster($lib_id, $data)
    {
        $this->db->where('Lib_Id', $lib_id);
        return $this->db->update('library_master', $data);
    }

    public function getLibraryByExcelId($excel_id)
    {
        $this->db->select('lm.*');
        $this->db->from('library_master lm');
        $this->db->where('lm.excel_upload_id', $excel_id);
        $this->db->where('lm.is_active', 1);
        $this->db->order_by('lm.Lib_Id', 'ASC');
        return $this->db->get()->result();
    }

    public function getLibraryById($lib_id)
    {
        $this->db->select('lm.*');
        $this->db->from('library_master lm');
        $this->db->where('lm.Lib_Id', $lib_id);
        return $this->db->get()->row();
    }

    public function deleteAllByExcelId($excel_id)
    {
        $this->db->where('excel_upload_id', $excel_id);
        return $this->db->delete('library_master');
    }

    public function softDeleteLibrary($lib_id)
    {
        $this->db->where('Lib_Id', $lib_id);
        return $this->db->update('library_master', ['is_active' => 0]);
    }

    public function checkCardNoExists($cardNo, $excludeLibId = null)
    {
        $this->db->where('CardNo', $cardNo);
        $this->db->where('is_active', 1);
        
        if ($excludeLibId) {
            $this->db->where('Lib_Id !=', $excludeLibId);
        }
        
        $query = $this->db->get('library_master');
        return $query->num_rows() > 0;
    }

    // ==================== YEAR FUNCTIONS ====================
    
    public function getActiveYear()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    public function getYears()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getYearById($yearId)
    {
        $this->db->where('finiYear_id', $yearId);
        $query = $this->db->get('finiyear_master');
        return $query->row();
    }

    // ==================== CARD TYPE FUNCTIONS ====================
    
    public function getCardTypes()
    {
        $this->db->select('mainuser_id, mainuser_name');
        $this->db->from('mainuser_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('mainuser_name', 'ASC');
        return $this->db->get()->result();
    }

    // ==================== LIST VIEW FUNCTIONS ====================
    
    /**
     * Get all excel records for list view
     */
    public function getdetailview()
{
    $this->db->select('library_master.*, mainuser_master.mainuser_name,finiyear_master.fini_Label');
    $this->db->from('library_master');
    $this->db->join('mainuser_master', 'library_master.fkCardType = mainuser_master.mainuser_id', 'left');
         $this->db->join('finiyear_master', 'library_master.FiniYear = finiyear_master.finiYear_id', 'left');
    $this->db->order_by('library_master.Lib_Id', 'DESC');

    return $this->db->get()->result();
}

    /**
     * Get library data with filters
     */
    public function getLibraryDataFiltered($filters = [])
    {
        $this->db->select('
            lm.*,
            le.ExcelName,
            fm.fini_Label as year_label,
            mm.mainuser_name as card_type_name
        ');
        $this->db->from('library_master lm');
        $this->db->join('library_excel le', 'le.excel_id = lm.excel_upload_id', 'left');
        $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
        $this->db->join('mainuser_master mm', 'mm.mainuser_id = lm.fkCardType', 'left');
        
        if (!empty($filters['year_ids']) && is_array($filters['year_ids'])) {
            $this->db->where_in('lm.FiniYear', $filters['year_ids']);
        }
        
        if (!empty($filters['card_type_ids']) && is_array($filters['card_type_ids'])) {
            $this->db->where_in('lm.fkCardType', $filters['card_type_ids']);
        }
        
        if (!empty($filters['search'])) {
            $search = $filters['search'];
            $this->db->group_start();
            $this->db->like('lm.CardNo', $search);
            $this->db->or_like('lm.Name', $search);
            $this->db->or_like('lm.Department', $search);
            $this->db->group_end();
        }
        
        $this->db->where('lm.is_active', 1);
        $this->db->order_by('lm.Lib_Id', 'DESC');
        
        return $this->db->get()->result();
    }

    /**
     * Get library statistics
     */
    public function getLibraryStats($filters = [])
    {
        $this->db->select('
            COUNT(lm.Lib_Id) as total_cards,
            COUNT(DISTINCT lm.excel_upload_id) as total_uploads,
            fm.fini_Label as year_label
        ');
        $this->db->from('library_master lm');
        $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
        
        if (!empty($filters['year_ids']) && is_array($filters['year_ids'])) {
            $this->db->where_in('lm.FiniYear', $filters['year_ids']);
        }
        
        $this->db->where('lm.is_active', 1);
        $this->db->group_by('lm.FiniYear, fm.fini_Label');
        
        return $this->db->get()->result();
    }

    /**
     * Get department-wise count
     */
    public function getDepartmentwiseCount($year_ids = [])
    {
        $this->db->select('
            lm.Department,
            COUNT(lm.Lib_Id) as card_count,
            fm.fini_Label as year_label
        ');
        $this->db->from('library_master lm');
        $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
        
        if (!empty($year_ids) && is_array($year_ids)) {
            $this->db->where_in('lm.FiniYear', $year_ids);
        }
        
        $this->db->where('lm.is_active', 1);
        $this->db->where('lm.Department IS NOT NULL');
        $this->db->group_by('lm.Department, fm.fini_Label');
        $this->db->order_by('card_count', 'DESC');
        
        return $this->db->get()->result();
    }

    /**
     * Get class-wise count
     */
    public function getClasswiseCount($year_ids = [])
    {
        $this->db->select('
            lm.Class,
            COUNT(lm.Lib_Id) as card_count,
            fm.fini_Label as year_label
        ');
        $this->db->from('library_master lm');
        $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
        
        if (!empty($year_ids) && is_array($year_ids)) {
            $this->db->where_in('lm.FiniYear', $year_ids);
        }
        
        $this->db->where('lm.is_active', 1);
        $this->db->where('lm.Class IS NOT NULL');
        $this->db->group_by('lm.Class, fm.fini_Label');
        $this->db->order_by('card_count', 'DESC');
        
        return $this->db->get()->result();
    }

    /**
     * Get print headings
     */
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }


  
public function getStudentByCard($card_no)
{
    // ✅ Use the correct column name from library_master table
    $this->db->where('CardNo', $card_no); // Based on your screenshot
    $query = $this->db->get('library_master');
    
    // Add debug
    log_message('debug', 'Query: ' . $this->db->last_query());
    log_message('debug', 'Rows found: ' . $query->num_rows());
    
    if ($query->num_rows() > 0) {
        return $query->row();
    }

    return false;
}
}