<?php
class Logfile_model extends CI_Model
{
    public function __construct()
    {
        $this->load->database();
    }

    private function get_action_text($action_value)
    {
        switch($action_value) {
            case 1: return "Inserted";
            case 2: return "Updated";
            case 3: return "Photo Upload";
            case 4: return "Excel File";
            default: return "Unknown";
        }
    }

    public function get_logs($start_date = null, $end_date = null)
    {
        $this->db->select('
             log_master.logId,
            log_master.date,
            log_master.time,
            log_master.action,
            log_master.Ip_addresss,
            log_master.ExcelName,
            log_master.Id,
            COALESCE(user_master.UserName, "Unknown User") as UserName,
            COALESCE(menu_master.MenuName, "N/A") as MenuName,
            COALESCE(submenu_master.Name, "N/A") as Name,
            COALESCE(branch_master.branch_name, "N/A") as branch_name
        ');
       $this->db->from('log_master log_master');
        $this->db->join('user_master', 'log_master.fk_userId = user_master.UserId', 'left');
      $this->db->join('submenu_master ', 'log_master.fk_submenuId = submenu_master.SubID', 'left');
          $this->db->join('branch_master','log_master.Fk_branch = branch_master.branch_id','left');
           $this->db->join('menu_master ', 'submenu_master.fkMenuID = menu_master.MenuID', 'left');

        
        if ($start_date) {
            $this->db->where('log_master.date >=', $start_date);
        }
        if ($end_date) {
            $this->db->where('log_master.date <=', $end_date);
        }
        
        $this->db->order_by('log_master.date', 'DESC');
        $this->db->order_by('log_master.time', 'DESC');
        
        $query = $this->db->get();
        $results = $query->result();
        
        foreach ($results as $result) {
            $result->action_text = $this->get_action_text($result->action);
        }
        
        return $results;
    }
}