<?php
class MiniAdd_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ============================================================
    // GET METHODS FOR EDIT MODE
    // ============================================================
    
    public function getMainDataByProjectId($project_id)
    {
        $this->db->select('miniproject_master.*, 
                          mini_mega_master.MiMe_Name as project_type_name,
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('miniproject_master');
        $this->db->join('mini_mega_master', 'miniproject_master.ProjectType = mini_mega_master.MiMe_ID', 'left');
        $this->db->join('branch_master', 'miniproject_master.fkBranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'miniproject_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->where('miniproject_master.project_id', $project_id);
        
        $result = $this->db->get()->row();
        
        if ($result) {
            $result->ProjectType = $result->ProjectType;
            $result->FiniYear = $result->FiniYear;
            $result->BranchID = $result->fkBranch_id;
        }
        
        return $result;
    }

    public function getChildDataByProjectId($project_id)
    {
        $mainProject = $this->db->get_where('miniproject_master', ['project_id' => $project_id])->row();
        
        if (!$mainProject) {
            return [];
        }

        $this->db->select('miniproject_master.*, 
                          branch_master.branch_name as department,
                          mini_mega_master.MiMe_Name as project_type_text,
                          finiyear_master.fini_Label as academic_year_text,
                          type_master.type_name as sponsorship_name,
                          rank_master.rank_name,
                          classmaster.classname,
                          division_master.div_name,
                          student_reg.FullName,');
        $this->db->from('miniproject_master');
        $this->db->join('branch_master', 'miniproject_master.fkBranch_id = branch_master.branch_id', 'left');
        $this->db->join('mini_mega_master', 'miniproject_master.ProjectType = mini_mega_master.MiMe_ID', 'left');
        $this->db->join('finiyear_master', 'miniproject_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->join('type_master', 'miniproject_master.fk_sponser = type_master.type_id', 'left');
        $this->db->join('rank_master', 'miniproject_master.rank = rank_master.rank_id', 'left');
        $this->db->join('classmaster', 'miniproject_master.class = classmaster.class_id', 'left');
        $this->db->join('division_master', 'miniproject_master.division = division_master.div_id', 'left');
        $this->db->join('student_reg', 'miniproject_master.student_name = student_reg.student_id', 'left');
        
        // $this->db->group_start();
        // $this->db->where('miniproject_master.group_no', $mainProject->group_no);
        // $this->db->where('miniproject_master.ProjectType', $mainProject->ProjectType);
        // $this->db->where('miniproject_master.FiniYear', $mainProject->FiniYear);
        // $this->db->where('miniproject_master.fkBranch_id', $mainProject->fkBranch_id);
        // $this->db->group_end();
        
        $this->db->or_where('miniproject_master.project_id', $project_id);
        $this->db->order_by('miniproject_master.project_id', 'ASC');
        
        $results = $this->db->get()->result();
        
        foreach ($results as $row) {
            $row->Financial_Year = $row->FiniYear;
        }
        
        return $results;
    }

    // ============================================================
    // EXISTING METHODS
    // ============================================================

    public function getdetailview()
    {
        $this->db->select('
            miniproject_master.project_id,
            miniproject_master.fkBranch_id,
            miniproject_master.FiniYear,
            miniproject_master.project_title,
            miniproject_master.ProjectType,
            miniproject_master.guide_name,
            miniproject_master.fk_sponser,
            miniproject_master.rank,
            miniproject_master.student_name,
            miniproject_master.prn,
            miniproject_master.roll_no,
            miniproject_master.division,
            miniproject_master.class,
            miniproject_master.group_no,
            finiyear_master.fini_Label,
            type_master.type_name,
            branch_master.branch_name,
            mini_mega_master.MiMe_Name,
            rank_master.rank_name,
            classmaster.classname,
            division_master.div_name,
            student_reg.FullName
        ');
        $this->db->from('miniproject_master');
        $this->db->join('finiyear_master', 'miniproject_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->join('type_master', 'miniproject_master.fk_sponser = type_master.type_id', 'left');
        $this->db->join('branch_master', 'miniproject_master.fkBranch_id = branch_master.branch_id', 'left');
        $this->db->join('mini_mega_master', 'miniproject_master.ProjectType = mini_mega_master.MiMe_ID', 'left');
        $this->db->join('rank_master', 'miniproject_master.rank = rank_master.rank_id', 'left');
        $this->db->join('classmaster', 'miniproject_master.class = classmaster.class_id', 'left');
        $this->db->join('division_master', 'miniproject_master.division = division_master.div_id', 'left');
        $this->db->join('student_reg', 'miniproject_master.student_name = student_reg.student_id', 'left');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        
        $this->db->order_by('miniproject_master.project_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_institute()
    {
        return $this->db->get('institute_master')->result();
    }

    public function getYearLabel($yearId)
    {
        $year = $this->db->get_where('finiyear_master', ['finiYear_id' => $yearId])->row();
        return $year ? $year->fini_Label : 'Unknown Year';
    }

    public function getBranchName($branchId)
    {
        $branch = $this->db->get_where('branch_master', ['branch_id' => $branchId])->row();
        return $branch ? $branch->branch_name : 'Unknown Branch';
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_Branch()
    {
    $this->db->select('branch_master.branch_id, branch_master.branch_name');
    $this->db->from('branch_master');
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    return $this->db->get()->result();
}
    // {
    //     return $this->db->get('branch_master')->result();
    // }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }

    public function getMini()
    {
        $this->db->select('mini_mega_master.*');
        $this->db->from('mini_mega_master');
        $query = $this->db->get();
        return $query->result();
    }

    // New dropdown methods
    public function getclass()
    {
        $this->db->select('classmaster.*');
        $this->db->from('classmaster');
        $query = $this->db->get();
        return $query->result();
    }

    public function getstudent()
    {
        $this->db->select('student_reg.*');
        $this->db->from('student_reg');
        $query = $this->db->get();
        return $query->result();
    }

    public function getdiv()
    {
        $this->db->select('division_master.*');
        $this->db->from('division_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getrank()
    {
        $this->db->select('rank_master.*');
        $this->db->from('rank_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function gettype()
    {
        $this->db->select('type_master.*');
        $this->db->from('type_master');
        $query = $this->db->get();
        return $query->result();
    }

    // public function getGuideNames()
    // {
    //     $this->db->select('DISTINCT guide_name');
    //     $this->db->from('miniproject_master');
    //     $this->db->where('guide_name IS NOT NULL');
    //     $this->db->order_by('guide_name', 'ASC');
    //     return $this->db->get()->result();
    // }

    // public function getProjectTitles()
    // {
    //     $this->db->select('DISTINCT project_title');
    //     $this->db->from('miniproject_master');
    //     $this->db->where('project_title IS NOT NULL');
    //     $this->db->order_by('project_title', 'ASC');
    //     return $this->db->get()->result();
    // }

// report section
 public function getDataByInstitute($institute_id, $MiMe_IDs = [], $branches = [], $guide_names = [], $project_titles = [],$years = [])
{
    $this->db->select('
        miniproject_master.project_id,
        miniproject_master.project_title,
        miniproject_master.guide_name,
        miniproject_master.rank,
        miniproject_master.FiniYear,
        miniproject_master.group_no,
        miniproject_master.prn,
        branch_master.branch_name,
        institute_master.Institu_name,
         type_master.type_name,
          rank_master.rank_name,
            classmaster.classname,
            division_master.div_name,
            student_reg.FullName,
            mini_mega_master.MiMe_Name
    ');
    $this->db->from('miniproject_master');
    $this->db->join('branch_master', 'miniproject_master.fkBranch_id = branch_master.branch_id', 'left');
    $this->db->join('finiyear_master', 'miniproject_master.FiniYear = finiyear_master.finiYear_id', 'left');
    $this->db->join('institute_master', 'miniproject_master.fk_institu = institute_master.Institu_id', 'left');
        $this->db->join('type_master', 'miniproject_master.fk_sponser = type_master.type_id', 'left');
 $this->db->join('rank_master', 'miniproject_master.rank = rank_master.rank_id', 'left');
        $this->db->join('classmaster', 'miniproject_master.class = classmaster.class_id', 'left');
        $this->db->join('division_master', 'miniproject_master.division = division_master.div_id', 'left');
        $this->db->join('student_reg', 'miniproject_master.student_name = student_reg.student_id', 'left');
        $this->db->join('mini_mega_master', 'miniproject_master.ProjectType = mini_mega_master.MiMe_ID', 'left');

    if (!empty($institute_id)) {
        $this->db->where('miniproject_master.fk_institu', $institute_id);
    }
 if (!empty($MiMe_IDs)) {
        $this->db->where_in('miniproject_master.ProjectType', $MiMe_IDs);
    }

    if (!empty($branches)) {
        $this->db->where_in('miniproject_master.fkBranch_id', $branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

    if (!empty($guide_names)) {
        $this->db->where_in('miniproject_master.guide_name', $guide_names);
    }
    if (!empty($project_titles)) {
        $this->db->where_in('miniproject_master.project_title', $project_titles);
    }
 if (!empty($years)) {
    $this->db->where_in('miniproject_master.FiniYear', (array)$years);
}

    $this->db->order_by('miniproject_master.project_id', 'ASC');
    return $this->db->get()->result();
}

public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

public function getCombinedData($institu, $branches = [], $years = [])
{
    // Branchwise Summary
    $this->db->select('b.branch_id, b.branch_name, COUNT(m.project_id) AS count');
    $this->db->from('miniproject_master m');
    $this->db->join('branch_master b', 'b.branch_id = m.fkBranch_id', 'left');
    $this->db->where('m.is_active', 1);

    if (!empty($institu)) {
        $this->db->where('m.fk_institu', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('m.fkBranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('m.fkBranch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('m.FiniYear', (array)$years);
    }

    $this->db->group_by('b.branch_id');
    $branchData = $this->db->get()->result_array();

    // Yearwise Summary
    $this->db->select('y.finiYear_id AS year_id, y.fini_Label AS year, COUNT(m.project_id) AS count');
    $this->db->from('miniproject_master m');
    $this->db->join('finiyear_master y', 'y.finiYear_id = m.FiniYear', 'left');
    $this->db->where('m.is_active', 1);

    if (!empty($institu)) {
        $this->db->where('m.fk_institu', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('m.fkBranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('m.fkBranch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('m.FiniYear', (array)$years);
    }

    $this->db->group_by('y.finiYear_id');
    $yearData = $this->db->get()->result_array();

    return [
        'branchData' => $branchData,
        'yearData'   => $yearData
    ];
}

 public function getBranchDetailsData($branch_id, $institu, $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('
            m.project_id AS Meet_id,
            m.project_title AS project_title,
            m.guide_name,
            m.rank,
            b.branch_name,
            y.fini_Label AS year,
            s.SponserName AS sponsor_name,
        ');
        $this->db->from('miniproject_master m');
        $this->db->join('branch_master b', 'b.branch_id = m.fkBranch_id', 'left');
        $this->db->join('finiyear_master y', 'y.finiYear_id = m.FiniYear', 'left');
        $this->db->join('sponser_master s', 's.id = m.fk_sponser', 'left');

        $this->db->where('m.fkBranch_id', $branch_id);

        if (!empty($institu)) {
            $this->db->where('m.fk_institu', $institu);
        }
        
         if (!empty($year) && $year != '0') {
    if (is_array($year)) {
        $this->db->where_in('m.FiniYear', $year);
    } else {
        $this->db->where('m.FiniYear', $year);
    }
}
        
        // if (!empty($year) && $year != '0') {
        //     $this->db->where('m.FiniYear', $year);
        // }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('m.created_at >=', $startDate);
            $this->db->where('m.created_at <=', $endDate);
        }

        return $this->db->get()->result_array();
    }

    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("miniproject_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = miniproject_master.FiniYear")
        ->group_by("miniproject_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}


public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("miniproject_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = miniproject_master.FiniYear")
        ->where("miniproject_master.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where('miniproject_master.fk_institu', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('miniproject_master.fkBranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('miniproject_master.fkBranch_id', explode(',', $branchIds));
    }
}
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("miniproject_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("miniproject_master.FiniYear, fini_Label, finiyear_master.finiYear_id");

    return $this->db->get()->result_array();
}

public function getYearwiseTypes($year, $institu, $branches = [], $startDate = null, $endDate = null)
{
    // $this->db->select('m.project_id AS Meet_id, m.project_title AS MeetingAgenda, y.fini_Label AS year, b.branch_name');
    $this->db->select('
            m.project_id AS Meet_id,
          m.project_title AS MeetingAgenda,
            m.guide_name,
            m.rank,
           
            b.branch_name,
            y.fini_Label AS year,
            s.SponserName AS sponsor_name,
        ');
    $this->db->from('miniproject_master m');
    $this->db->join('finiyear_master y', 'y.finiYear_id = m.FiniYear', 'left');
    $this->db->join('branch_master b', 'b.branch_id = m.fkBranch_id', 'left');
      $this->db->join('sponser_master s', 's.id = m.fk_sponser', 'left');
    $this->db->where('m.FiniYear', $year);

    if (!empty($institu)) {
        $this->db->where('m.fk_institu', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('m.fkBranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('m.fkBranch_id', explode(',', $branchIds));
    }
}

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where('m.created_at >=', $startDate);
        $this->db->where('m.created_at <=', $endDate);
    }

    return $this->db->get()->result_array();
}

 public function getStudentsByMeetId($project_id)
    {
        return $this->db->select('prn, student_name')
                        ->from('miniproject_students')
                        ->where('fk_project_id', $project_id)
                        ->get()
                        ->result_array();
    }
// public function getStudentsByMeetId($project_id)
// {
//     return $this->db->select('prn, student_name')
//                     ->from('miniproject_students')
//                     ->where('fk_project_id', $project_id) // correct column
//                     ->get()
//                     ->result_array();
// }


public function getGuideNames()
{
    $this->db->select('guide_name');
    $this->db->from('miniproject_master');
    $this->db->where('guide_name IS NOT NULL');
    $this->db->where('guide_name !=', '');
    $this->db->group_by('guide_name');
    $this->db->order_by('guide_name', 'ASC');
    $query = $this->db->get();
    return $query->result();
}
public function getProjectTitles()
{
    $this->db->select('project_title');
    $this->db->from('miniproject_master');
    $this->db->where('project_title IS NOT NULL');
    $this->db->where('project_title !=', '');
    $this->db->group_by('project_title');
    $this->db->order_by('project_title', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

     public function get_all_sponser()
{
    return $this->db->get('sponser_master')->result();
}


     public function get_all_seedmoney()
{
    return $this->db->get('type_master')->result();
}





}
?>