<?php
  class MiniImport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('miniproject_master',$model);
			//return $sql->result();
	} 

   public function getdetailview()
{
    $this->db->select('
        miniproject_master.project_id,
        miniproject_master.fkBranch_id,
        miniproject_master.FiniYear,
        miniproject_master.project_title,
        miniproject_master.guide_name,
        miniproject_master.fk_sponsored,
        miniproject_master.rank,
        miniproject_master.fk_seed_money,
        miniproject_master.money,
        miniproject_students.student_name,
        miniproject_students.prn,
        finiyear_master.fini_Label,
        sponser_master.SponserName,
        type_master.type_name
    ');
    $this->db->from('miniproject_master');
    $this->db->join('miniproject_students', 'miniproject_students.fk_project_id = miniproject_master.project_id', 'left');
    $this->db->join('finiyear_master', 'miniproject_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->join('sponser_master', 'miniproject_master.fk_sponsored = sponser_master.id', 'left');
    $this->db->join('type_master', 'miniproject_master.fk_seed_money = type_master.type_id', 'left');

    $this->db->order_by('miniproject_master.project_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}

     public function get_all_institute()
{
    return $this->db->get('institute_master')->result();
}

public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }

          public function get_all_Branch()
{
    return $this->db->get('branch_master')->result();
}

 public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getDataByInstitute($institute_id, $branches = [], $guide_names = [], $project_titles = [],$years = [])
{
    $this->db->select('
        miniproject_master.project_id,
        miniproject_master.project_title,
        miniproject_master.guide_name,
        miniproject_master.rank,
        miniproject_master.money,
        miniproject_master.FiniYear,
        branch_master.branch_name,
        institute_master.Institu_name,
        sponser_master.SponserName AS sponsor_name,
        type_master.type_name AS seed_money_type
    ');
    $this->db->from('miniproject_master');
    $this->db->join('branch_master', 'miniproject_master.fkBranch_id = branch_master.branch_id', 'left');
    $this->db->join('finiyear_master', 'miniproject_master.FiniYear = finiyear_master.finiYear_id', 'left');
    $this->db->join('institute_master', 'miniproject_master.fk_institu = institute_master.Institu_id', 'left');
    $this->db->join('sponser_master', 'miniproject_master.fk_sponsored = sponser_master.id', 'left');
    $this->db->join('type_master', 'miniproject_master.fk_seed_money = type_master.type_id', 'left');

    if (!empty($institute_id)) {
        $this->db->where('miniproject_master.fk_institu', $institute_id);
    }
    if (!empty($branches)) {
        $this->db->where_in('miniproject_master.fkBranch_id', $branches);
    }
    if (!empty($guide_names)) {
        $this->db->where_in('miniproject_master.guide_name', $guide_names);
    }
    if (!empty($project_titles)) {
        $this->db->where_in('miniproject_master.project_title', $project_titles);
    }
 if (!empty($years)) {
    $this->db->where_in('miniproject_master.FiniYear', (array)$years);
}

    $this->db->order_by('miniproject_master.project_id', 'ASC');
    return $this->db->get()->result();
}

public function getStudentsByProject($project_id)
{
    $this->db->select('student_name, prn');
    $this->db->from('miniproject_students');
    $this->db->where('fk_project_id', $project_id);
    return $this->db->get()->result();
}


 public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

public function getCombinedData($institu, $branches = [], $years = [])
{
    // Branchwise Summary
    $this->db->select('b.branch_id, b.branch_name, COUNT(m.project_id) AS count');
    $this->db->from('miniproject_master m');
    $this->db->join('branch_master b', 'b.branch_id = m.fkBranch_id', 'left');
    $this->db->where('m.is_active', 1);

    if (!empty($institu)) {
        $this->db->where('m.fk_institu', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('m.fkBranch_id', (array)$branches);
    }

    if (!empty($years)) {
        $this->db->where_in('m.FiniYear', (array)$years);
    }

    $this->db->group_by('b.branch_id');
    $branchData = $this->db->get()->result_array();

    // Yearwise Summary
    $this->db->select('y.finiYear_id AS year_id, y.fini_Label AS year, COUNT(m.project_id) AS count');
    $this->db->from('miniproject_master m');
    $this->db->join('finiyear_master y', 'y.finiYear_id = m.FiniYear', 'left');
    $this->db->where('m.is_active', 1);

    if (!empty($institu)) {
        $this->db->where('m.fk_institu', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('m.fkBranch_id', (array)$branches);
    }

    if (!empty($years)) {
        $this->db->where_in('m.FiniYear', (array)$years);
    }

    $this->db->group_by('y.finiYear_id');
    $yearData = $this->db->get()->result_array();

    return [
        'branchData' => $branchData,
        'yearData'   => $yearData
    ];
}

 public function getBranchDetailsData($branch_id, $institu, $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('
            m.project_id AS Meet_id,
            m.project_title AS project_title,
            m.guide_name,
            m.rank,
            m.money,
            b.branch_name,
            y.fini_Label AS year,
            s.SponserName AS sponsor_name,
            t.type_name AS seed_money_type
        ');
        $this->db->from('miniproject_master m');
        $this->db->join('branch_master b', 'b.branch_id = m.fkBranch_id', 'left');
        $this->db->join('finiyear_master y', 'y.finiYear_id = m.FiniYear', 'left');
        $this->db->join('sponser_master s', 's.id = m.fk_sponsored', 'left');
        $this->db->join('type_master t', 't.type_id = m.fk_seed_money', 'left');

        $this->db->where('m.fkBranch_id', $branch_id);

        if (!empty($institu)) {
            $this->db->where('m.fk_institu', $institu);
        }
        if (!empty($year) && $year != '0') {
            $this->db->where('m.FiniYear', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('m.created_at >=', $startDate);
            $this->db->where('m.created_at <=', $endDate);
        }

        return $this->db->get()->result_array();
    }

    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("miniproject_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = miniproject_master.FiniYear")
        ->group_by("miniproject_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}


public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("miniproject_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = miniproject_master.FiniYear")
        ->where("miniproject_master.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where('miniproject_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('miniproject_master.fkBranch_id', (array)$branches);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("miniproject_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("miniproject_master.FiniYear, fini_Label, finiyear_master.finiYear_id");

    return $this->db->get()->result_array();
}

public function getYearwiseTypes($year, $institu, $branches = [], $startDate = null, $endDate = null)
{
    // $this->db->select('m.project_id AS Meet_id, m.project_title AS MeetingAgenda, y.fini_Label AS year, b.branch_name');
    $this->db->select('
            m.project_id AS Meet_id,
          m.project_title AS MeetingAgenda,
            m.guide_name,
            m.rank,
            m.money,
            b.branch_name,
            y.fini_Label AS year,
            s.SponserName AS sponsor_name,
            t.type_name AS seed_money_type
        ');
    $this->db->from('miniproject_master m');
    $this->db->join('finiyear_master y', 'y.finiYear_id = m.FiniYear', 'left');
    $this->db->join('branch_master b', 'b.branch_id = m.fkBranch_id', 'left');
      $this->db->join('sponser_master s', 's.id = m.fk_sponsored', 'left');
        $this->db->join('type_master t', 't.type_id = m.fk_seed_money', 'left');
    $this->db->where('m.FiniYear', $year);

    if (!empty($institu)) {
        $this->db->where('m.fk_institu', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('m.fkBranch_id', (array)$branches);
    }

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where('m.created_at >=', $startDate);
        $this->db->where('m.created_at <=', $endDate);
    }

    return $this->db->get()->result_array();
}

 public function getStudentsByMeetId($project_id)
    {
        return $this->db->select('prn, student_name')
                        ->from('miniproject_students')
                        ->where('fk_project_id', $project_id)
                        ->get()
                        ->result_array();
    }
// public function getStudentsByMeetId($project_id)
// {
//     return $this->db->select('prn, student_name')
//                     ->from('miniproject_students')
//                     ->where('fk_project_id', $project_id) // correct column
//                     ->get()
//                     ->result_array();
// }


public function getGuideNames()
{
    $this->db->select('guide_name');
    $this->db->from('miniproject_master');
    $this->db->where('guide_name IS NOT NULL');
    $this->db->where('guide_name !=', '');
    $this->db->group_by('guide_name');
    $this->db->order_by('guide_name', 'ASC');
    $query = $this->db->get();
    return $query->result();
}
public function getProjectTitles()
{
    $this->db->select('project_title');
    $this->db->from('miniproject_master');
    $this->db->where('project_title IS NOT NULL');
    $this->db->where('project_title !=', '');
    $this->db->group_by('project_title');
    $this->db->order_by('project_title', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

     public function get_all_sponser()
{
    return $this->db->get('sponser_master')->result();
}


     public function get_all_seedmoney()
{
    return $this->db->get('type_master')->result();
}


}