<?php
class Mou_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // Insert new MOU record
  public function insertdata($model)
	{
		 $this->db->insert('mou_master',$model);
			return $this->db->insert_id();
	}

    // Get all MOU records with related data
    public function getdetailview()
    {      
        $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label, branch_master.branch_name');
        $this->db->from('mou_master');
        $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
        $this->db->join('finiyear_master', 'mou_master.fkYear_id = finiyear_master.finiYear_id', 'left');
        $this->db->join('branch_master', 'mou_master.Branch_id = branch_master.branch_id', 'left');
//         // new code
//     $branchIds = $this->session->userdata('fkBranch_Id');

//     if (!empty($branchIds)) {
//         if (!is_array($branchIds)) {
//             $branchIds = explode(',', $branchIds);
//         }

//         $this->db->where_in('branch_master.branch_id', $branchIds);
//     }
// // new code end
        
        $this->db->order_by('mou_master.mou_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get duration data
    public function getduration()
    {
        $this->db->select('internduration_master.*');
        $this->db->from('internduration_master');
        $query = $this->db->get();
        return $query->result();
    }

    // Get branch data
    public function getbranch()
     {
      $this->db->select('branch_master.*,');
      // new code
      $branchIds = $this->session->userdata('fkBranch_Id');
 
    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
    // new code end
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }

    // Get year data
    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Insert gallery image - FIXED: Using correct table name
    public function insertGallery($data)
    {
        return $this->db->insert('mou_gallery', $data);
    }

    // Get MOU by ID
    public function getbyid($id)
    {
        $this->db->select("mou_master.*");
        $this->db->where('mou_id', $id);
        $query = $this->db->get('mou_master');
        return $query->result();
    }
    
    // Update MOU record
    public function update($model)
    {
        return $this->db->where('mou_id', $model['mou_id'])->update('mou_master', $model); 
    }

    // Get gallery images for a specific MOU - FIXED: Using correct table and column names
    public function getAwardGallery($mou_id) 
    {
        return $this->db
            ->select('*')
            ->from('mou_gallery')
            ->where('fkAward_id', $mou_id)
            ->get()
            ->result();
    }

    // Delete existing photos from gallery
    public function deleteExistingPhotos($mou_id, $removed_photos_array)
    {
        if (!empty($removed_photos_array)) {
            $this->deleteSpecificPhotos($mou_id, $removed_photos_array);
        }
    }

    // Delete specific photos by file path - FIXED: Using correct table name
    public function deleteSpecificPhotos($mou_id, $file_paths) 
    {
        if (empty($file_paths)) return false;

        $this->db->where('fkAward_id', $mou_id);
        $this->db->where_in('file_path', $file_paths);
        return $this->db->delete('mou_gallery');
    }

    // Delete all gallery images for a MOU - FIXED: Using correct table name
    public function deleteimagedata($mou_id)
    {
        return $this->db->where('fkAward_id', $mou_id)
                        ->delete('mou_gallery');
    }

    // Insert multiple gallery photos at once - FIXED: Using correct table name
    public function insertMultiplePhotos($mou_id, $file_paths)
    {
        if (empty($file_paths)) return false;
       
        $insert_data = [];
        foreach ($file_paths as $path) {
            $insert_data[] = [
                'fkAward_id' => $mou_id,
                'file_path' => $path
            ];
        }
       
        return $this->db->insert_batch('mou_gallery', $insert_data);
    }

    // Delete MOU record
    public function delete($mou_id)
    {
        // First delete associated gallery images
        $this->deleteimagedata($mou_id);
        
        // Then delete the MOU record
        return $this->db->where('mou_id', $mou_id)->delete('mou_master');
    }

    // Get filtered MOU data for reports
    public function getFilteredMouData($year_id = null, $branch_id = null, $duration_id = null)
    {
        $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label, branch_master.branch_name');
        $this->db->from('mou_master');
        $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
        $this->db->join('finiyear_master', 'mou_master.fkYear_id = finiyear_master.finiYear_id', 'left');
        $this->db->join('branch_master', 'mou_master.Branch_id = branch_master.branch_id', 'left');

        if (!empty($year_id)) {
            $this->db->where('mou_master.fkYear_id', $year_id);
        }

        if (!empty($branch_id)) {
            $this->db->where('mou_master.Branch_id', $branch_id);
        }

        if (!empty($duration_id)) {
            $this->db->where('mou_master.fkDuration_id', $duration_id);
        }

        $this->db->order_by('mou_master.StartDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get MOU count by year
    public function getMouCountByYear()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("mou_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = mou_master.fkYear_id")
            ->group_by("mou_master.fkYear_id, fini_Label, finiyear_master.finiYear_id")
            ->order_by("finiyear_master.finiYear_id", "DESC")
            ->get()
            ->result_array();
    }

    // Get MOU count by branch
    public function getMouCountByBranch($year_id = null)
    {
        $this->db->select("branch_master.branch_id, branch_master.branch_name, COUNT(*) as count");
        $this->db->from("mou_master");
        $this->db->join("branch_master", "branch_master.branch_id = mou_master.Branch_id");
        
        if (!empty($year_id)) {
            $this->db->where("mou_master.fkYear_id", $year_id);
        }
        
        $this->db->group_by("mou_master.Branch_id, branch_master.branch_name, branch_master.branch_id");
        $query = $this->db->get();
        return $query->result_array();
    }

    // Get active/expired MOUs
    public function getMouByStatus($status = 'active')
    {
        $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label, branch_master.branch_name');
        $this->db->from('mou_master');
        $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
        $this->db->join('finiyear_master', 'mou_master.fkYear_id = finiyear_master.finiYear_id', 'left');
        $this->db->join('branch_master', 'mou_master.Branch_id = branch_master.branch_id', 'left');

        $current_date = date('Y-m-d');

        if ($status === 'active') {
            $this->db->where('mou_master.EndDate >=', $current_date);
        } else {
            $this->db->where('mou_master.EndDate <', $current_date);
        }

        $this->db->order_by('mou_master.StartDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

      public function showDataByFilters($branch_ids = [], $year_id = null, $startdate = null, $enddate = null)
    {
        $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label, branch_master.branch_name');
        $this->db->from('mou_master');
        $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
        $this->db->join('finiyear_master', 'mou_master.fkYear_id = finiyear_master.finiYear_id', 'left');
        $this->db->join('branch_master', 'mou_master.Branch_id = branch_master.branch_id', 'left');

      // Branch filter - MODIFIED
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('mou_master.Branch_id', $branch_ids);
    }
    // new code
    // else {
    //     $branchIds = $this->session->userdata('fkBranch_Id');
 
    //     if (!is_array($branchIds)) {
    //         $branchIds = explode(',', $branchIds);
    //     }
 
    //     $this->db->where_in('mou_master.Branch_id', $branchIds);
    // }
    // new code end


        // Year filter
        if (!empty($year_id) && $year_id != '0') {
            $this->db->where('mou_master.fkYear_id', $year_id);
        }

        // Date range filter
        if (!empty($startdate) && !empty($enddate)) {
            $this->db->where('mou_master.StartDate >=', $startdate);
            $this->db->where('mou_master.StartDate <=', $enddate);
        }

        $this->db->order_by('mou_master.StartDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
// Replace these methods in your Mou_model.php

// Get branch-wise MOU count with filters
public function getBranchWiseData($branch_ids = [], $year_ids = [], $startdate = null, $enddate = null)
{
    $this->db->select('branch_master.branch_id, branch_master.branch_name, COUNT(mou_master.mou_id) as mou_count');
    $this->db->from('mou_master');
    $this->db->join('branch_master', 'branch_master.branch_id = mou_master.Branch_id', 'left');

   // Branch filter - MODIFIED
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('mou_master.Branch_id', $branch_ids);
    }
    // new code
    // else {
    //     $branchIds = $this->session->userdata('fkBranch_Id');
 
    //     if (!is_array($branchIds)) {
    //         $branchIds = explode(',', $branchIds);
    //     }
 
    //     $this->db->where_in('mou_master.Branch_id', $branchIds);
    // }
    // new code end

    // Year filter - apply to show branches that have MOUs in selected years
    if (!empty($year_ids) && is_array($year_ids)) {
        $this->db->where_in('mou_master.fkYear_id', $year_ids);
    }

    // Date range filter
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('mou_master.StartDate >=', $startdate);
        $this->db->where('mou_master.StartDate <=', $enddate);
    }

    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->having('COUNT(mou_master.mou_id) >', 0); // Only show branches with MOUs
    $this->db->order_by('mou_count', 'DESC');
    
    $query = $this->db->get();
    return $query->result();
}

// Get year-wise MOU count with filters
public function getYearWiseData($branch_ids = [], $year_ids = [], $startdate = null, $enddate = null)
{
    $this->db->select('finiyear_master.finiYear_id as year_id, finiyear_master.fini_Label as year, COUNT(mou_master.mou_id) as count');
    $this->db->from('mou_master');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = mou_master.fkYear_id', 'left');

  // Branch filter - MODIFIED
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('mou_master.Branch_id', $branch_ids);
    }
    // new code
    // else {
    //     $branchIds = $this->session->userdata('fkBranch_Id');
 
    //     if (!is_array($branchIds)) {
    //         $branchIds = explode(',', $branchIds);
    //     }
 
    //     $this->db->where_in('mou_master.Branch_id', $branchIds);
    // }
    // new code end

    // Year filter - only if years are selected
    if (!empty($year_ids) && is_array($year_ids)) {
        $this->db->where_in('mou_master.fkYear_id', $year_ids);
    }

    // Date range filter
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('mou_master.StartDate >=', $startdate);
        $this->db->where('mou_master.StartDate <=', $enddate);
    }

    $this->db->group_by('finiyear_master.finiYear_id, finiyear_master.fini_Label');
    $this->db->having('COUNT(mou_master.mou_id) >', 0); // Only show years with MOUs
    $this->db->order_by('finiyear_master.finiYear_id', 'DESC');
    
    $query = $this->db->get();
    return $query->result();
}

// Get branch details for chart drill-down
public function getBranchDetails($branch_id, $branch_ids = [], $year_ids = [], $startdate = null, $enddate = null)
{
    $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label as year, branch_master.branch_name');
    $this->db->from('mou_master');
    $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = mou_master.fkYear_id', 'left');
    $this->db->join('branch_master', 'branch_master.branch_id = mou_master.Branch_id', 'left');
    
// Branch filter
if (!empty($branch_id)) {

    // Drill-down: specific branch selected
    $this->db->where('mou_master.Branch_id', $branch_id);

} 
// else {

//     // Default: restrict data to session branches
//     $branchIds = $this->session->userdata('fkBranch_Id');

//     if (!is_array($branchIds)) {
//         $branchIds = explode(',', $branchIds);
//     }

//     $this->db->where_in('branch_master.branch_id', $branchIds);
// }

    // Year filter - IMPORTANT: Apply the year filter when drilling into branch
    if (!empty($year_ids) && is_array($year_ids)) {
        $this->db->where_in('mou_master.fkYear_id', $year_ids);
    }

    // Date range filter
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('mou_master.StartDate >=', $startdate);
        $this->db->where('mou_master.StartDate <=', $enddate);
    }

    $this->db->order_by('mou_master.StartDate', 'DESC');
    
    $query = $this->db->get();
    return $query->result();
}

// Get year details for chart drill-down
public function getYearDetails($year_id, $branch_ids = [], $year_ids = [], $startdate = null, $enddate = null)
{
    $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label as year, branch_master.branch_name');
    $this->db->from('mou_master');
    $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = mou_master.fkYear_id', 'left');
    $this->db->join('branch_master', 'branch_master.branch_id = mou_master.Branch_id', 'left');
    
    $this->db->where('mou_master.fkYear_id', $year_id);

   // Branch filter
if (!empty($branch_ids) && is_array($branch_ids)) {

    // Drill-down: selected branches
    $this->db->where_in('mou_master.Branch_id', $branch_ids);

} 
// else {

//     // Default: restrict to session branches
//     $branchIds = $this->session->userdata('fkBranch_Id');

//     if (!is_array($branchIds)) {
//         $branchIds = explode(',', $branchIds);
//     }

//     $this->db->where_in('branch_master.branch_id', $branchIds);
// }


    // Date range filter
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('mou_master.StartDate >=', $startdate);
        $this->db->where('mou_master.StartDate <=', $enddate);
    }

    $this->db->order_by('mou_master.StartDate', 'DESC');
    
    $query = $this->db->get();
    return $query->result();
}
    // NEW: Get branch-wise MOU count with filters
    // public function getBranchWiseData($year_ids = [], $startdate = null, $enddate = null)
    // {
    //     $this->db->select('branch_master.branch_id, branch_master.branch_name, COUNT(mou_master.mou_id) as mou_count');
    //     $this->db->from('mou_master');
    //     $this->db->join('branch_master', 'branch_master.branch_id = mou_master.Branch_id', 'left');

    //     // Year filter
    //     if (!empty($year_ids) && is_array($year_ids)) {
    //         $this->db->where_in('mou_master.fkYear_id', $year_ids);
    //     }

    //     // Date range filter
    //     if (!empty($startdate) && !empty($enddate)) {
    //         $this->db->where('mou_master.StartDate >=', $startdate);
    //         $this->db->where('mou_master.StartDate <=', $enddate);
    //     }

    //     $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    //     $this->db->order_by('mou_count', 'DESC');
        
    //     $query = $this->db->get();
    //     return $query->result();
    // }

    // // NEW: Get year-wise MOU count with filters
    // public function getYearWiseData($branch_ids = [], $startdate = null, $enddate = null)
    // {
    //     $this->db->select('finiyear_master.finiYear_id as year_id, finiyear_master.fini_Label as year, COUNT(mou_master.mou_id) as count');
    //     $this->db->from('mou_master');
    //     $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = mou_master.fkYear_id', 'left');

    //     // Branch filter
    //     if (!empty($branch_ids) && is_array($branch_ids)) {
    //         $this->db->where_in('mou_master.Branch_id', $branch_ids);
    //     }

    //     // Date range filter
    //     if (!empty($startdate) && !empty($enddate)) {
    //         $this->db->where('mou_master.StartDate >=', $startdate);
    //         $this->db->where('mou_master.StartDate <=', $enddate);
    //     }

    //     $this->db->group_by('finiyear_master.finiYear_id, finiyear_master.fini_Label');
    //     $this->db->order_by('finiyear_master.finiYear_id', 'DESC');
        
    //     $query = $this->db->get();
    //     return $query->result();
    // }

    // // NEW: Get branch details for chart drill-down - UPDATED TO INCLUDE ALL FIELDS
    // public function getBranchDetails($branch_id, $year_ids = [], $startdate = null, $enddate = null)
    // {
    //     // Select ALL fields from mou_master including document paths
    //     $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label as year, branch_master.branch_name');
    //     $this->db->from('mou_master');
    //     $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
    //     $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = mou_master.fkYear_id', 'left');
    //     $this->db->join('branch_master', 'branch_master.branch_id = mou_master.Branch_id', 'left');
        
    //     $this->db->where('mou_master.Branch_id', $branch_id);

    //     // Year filter
    //     if (!empty($year_ids) && is_array($year_ids)) {
    //         $this->db->where_in('mou_master.fkYear_id', $year_ids);
    //     }

    //     // Date range filter
    //     if (!empty($startdate) && !empty($enddate)) {
    //         $this->db->where('mou_master.StartDate >=', $startdate);
    //         $this->db->where('mou_master.StartDate <=', $enddate);
    //     }

    //     $this->db->order_by('mou_master.StartDate', 'DESC');
        
    //     $query = $this->db->get();
    //     return $query->result();
    // }

    // // NEW: Get year details for chart drill-down - UPDATED TO INCLUDE ALL FIELDS
    // public function getYearDetails($year_id, $branch_ids = [], $startdate = null, $enddate = null)
    // {
    //     // Select ALL fields from mou_master including document paths
    //     $this->db->select('mou_master.*, internduration_master.duration_type, finiyear_master.fini_Label as year, branch_master.branch_name');
    //     $this->db->from('mou_master');
    //     $this->db->join('internduration_master', 'mou_master.fkDuration_id = internduration_master.duration_id', 'left');
    //     $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = mou_master.fkYear_id', 'left');
    //     $this->db->join('branch_master', 'branch_master.branch_id = mou_master.Branch_id', 'left');
        
    //     $this->db->where('mou_master.fkYear_id', $year_id);

    //     // Branch filter
    //     if (!empty($branch_ids) && is_array($branch_ids)) {
    //         $this->db->where_in('mou_master.Branch_id', $branch_ids);
    //     }

    //     // Date range filter
    //     if (!empty($startdate) && !empty($enddate)) {
    //         $this->db->where('mou_master.StartDate >=', $startdate);
    //         $this->db->where('mou_master.StartDate <=', $enddate);
    //     }

    //     $this->db->order_by('mou_master.StartDate', 'DESC');
        
    //     $query = $this->db->get();
    //     return $query->result();
    // }

    // Get print headings
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}