<?php
  class NPTLReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
    

     public function getdomainbranch()
{
    $this->db->select('Domain_branch');
    $this->db->from('nptl_main_master');
    $this->db->group_by('Domain_branch');
    $this->db->order_by('Domain_branch', 'ASC'); // optional sorting
    return $this->db->get()->result();
}

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getduration()
     {
      $this->db->select('internduration_master.*,');
      $this->db->from('internduration_master');
       $query = $this->db->get();
        return $query->result();
     }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }





public function getDataByInstitute($institute_id,  $year_id, $typeids = [], $startdate = null, $enddate = null )
{
    $this->db->select('
        nptl_main_master.*, 
        finiyear_master.fini_Label,');

    $this->db->from('nptl_main_master');
$this->db->join('finiyear_master', 
                        'nptl_main_master.finicial_Year = finiyear_master.finiYear_id', 
                        'left');
    $this->db->where('nptl_main_master.institute', $institute_id);

    if (!empty($typeids)) {
        $this->db->where_in('nptl_main_master.Domain_branch', $typeids);
    }


    
    if (!empty($year_id)) {
    $this->db->where('nptl_main_master.finicial_Year', $year_id);
}


if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('nptl_main_master.Date >=', $startdate);
        $this->db->where('nptl_main_master.Date <=', $enddate);
    }
    
        // $this->db->order_by('nptl_main_master.start_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

  // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(nptl_main_master.nptlmain_id) as count")
        ->from("nptl_main_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = nptl_main_master.finicial_Year")
        ->group_by("nptl_main_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}


 
public function getSingleYearData($yearId)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(nptl_main_master.nptlmain_id) as count")
        ->from("nptl_main_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = nptl_main_master.finicial_Year")
        ->where("nptl_main_master.finicial_Year", $yearId);
 
    
   
 
    $this->db->group_by("nptl_main_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId)
{
    $this->db->select("nptl_main_master.nptlmain_id, nptl_main_master.Domain_branch,nptl_main_master.Faculty_id,
    nptl_main_master.Date,
    nptl_main_master.Domain_name,nptl_main_master.Faculty_name, finiyear_master.fini_Label as year,")
        ->from("nptl_main_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = nptl_main_master.finicial_Year")

        ->where("nptl_main_master.finicial_Year", $yearId);
    return $this->db->get()->result_array();
}

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(nptl_main_master.nptlmain_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('nptl_main_master', 'branch_master.branch_id = nptl_main_master.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('nptl_main_master.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('nptl_main_master.finicial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('nptl_main_master.details,
                       nptl_main_master.nptlmain_id,
                       nptl_main_master.fk_branch,
                       nptl_main_master.start_date,
                       nptl_main_master.document,
semester_master.Sem_Name,audit_type.type_name,
                       branch_master.branch_name,                      
                        ');
    $this->db->from('nptl_main_master');
    $this->db->join('branch_master', 'branch_master.branch_id = nptl_main_master.fk_branch', 'left');
 $this->db->join('semester_master', 'nptl_main_master.fk_sem = semester_master.SemID', 'left');
        $this->db->join('audit_type', 'nptl_main_master.fk_auditType = audit_type.ID', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('nptl_main_master.fk_branch', $branch_id);
} else {
    $this->db->where('nptl_main_master.fk_branch', $branch_id);
}
 

    if (!empty($institu)) {
        $this->db->where('nptl_main_master.institute', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('nptl_main_master.finicial_Year', $year);
    // }

  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('nptl_main_master.finicial_Year', $year);
    } else {
        $this->db->where('nptl_main_master.finicial_Year', $year);
    }
}
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("nptl_main_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count --- ❌ COMMENTED OUT
    /*
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.nptlmain_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('nptl_main_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.finicial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
    */
 
    // --- 2. Yearwise Count --- ✅ KEEP THIS
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.nptlmain_id) as count");
    $this->db->from("nptl_main_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.finicial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.institute', $institu);
    }
   
    if (!empty($years)) {
        $this->db->where_in('sp.finicial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
    
public function getStudentsByMeetId($fkmain_id)
{
    return $this->db->select('nptl_master.Course_name,
            nptl_master.fkduration_id,
            nptl_master.StartDate,
            nptl_master.EndDate,
            nptl_master.Grade,
            nptl_master.Certi_photo,
            nptl_master.fkfiniYear_id,
    finiyear_master.fini_Label, internduration_master.duration_type,')
                    ->from('nptl_master')
                     ->join('finiyear_master',' nptl_master.fkfiniYear_id = finiyear_master.finiYear_id','left')
                    ->join(' internduration_master',' nptl_master.fkduration_id =  internduration_master.duration_id','left')
                    ->where('fkmain_id', $fkmain_id)
                    ->get()
                    ->result_array();
}
 

}