<?php
class NewConference_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert parent data to budgetuti_main_master
    public function insertMain($data) {
        $this->db->insert('new_conferencemaster', $data);
        return $this->db->insert_id();
    }
    
    // Insert child data to budgetutilazation_master
    public function insertChild($data) {
        return $this->db->insert('new_conferencechild', $data);
    }
    
    // Update main record
    public function updateMain($budgetmain_id, $data) {
        $this->db->where('new_id', $budgetmain_id);
        return $this->db->update('new_conferencemaster', $data);
    }
    
    // Delete child records by main ID
    public function deleteChildByMainId($budgetmain_id) {
        $this->db->where('fk_confmain', $budgetmain_id);
        return $this->db->delete('new_conferencechild');
    }
    
    // Get main record by ID
    public function getMainById($id) {
        $this->db->select('*');
        $this->db->from('new_conferencemaster');
        $this->db->where('new_id', $id);
        $query = $this->db->get();
        return $query->row();
    }
    
    // Get child records by main ID
    public function getChildByMainId($budgetmain_id) {
        $this->db->select('*');
        $this->db->from('new_conferencechild');
        $this->db->where('fk_confmain', $budgetmain_id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get branch data
    public function getevent() {
        $this->db->select('event_id, event_type');
        $this->db->from('event_master');
        $this->db->order_by('event_type', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get financial year data
    public function getYearData() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        // $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
       
    public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}

    // Other existing methods
    public function getAlldata() {
        $this->db->select('
        new_conferencemaster.*,
        finiyear_master.fini_Label,');
        $this->db->from('new_conferencemaster');
    $this->db->join('finiyear_master', 'new_conferencemaster.Financial_year = finiyear_master.finiYear_id', 'left');
    $this->db->order_by('new_conferencemaster.new_id', 'DESC');
   
$this->db->where('new_conferencemaster.is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }
    
    
    
    // Get all budget records with joins
    // public function getAllBudgets() {
    //     $this->db->select('
    //         bm.budgetmain_id,
    //         bm.fkbranch_id,
    //         bm.finicial_Year,
    //         bm.budgetuti_date,
    //         bm.Desscription_main,
    //         bm.excel_file,
    //         br.branch_name,
    //         fy.fini_Label,
    //         COUNT(bc.budgetuti_id) as total_records,
    //         SUM(bc.amount) as total_amount
    //     ');
    //     $this->db->from('budgetuti_main_master bm');
    //     $this->db->join('branch_master br', 'br.branch_id = bm.fkbranch_id', 'left');
    //     $this->db->join('finiyear_master fy', 'fy.finiYear_id = bm.finicial_Year', 'left');
    //     $this->db->join('budgetutilazation_master bc', 'bc.fkbudgetmain_id = bm.budgetmain_id', 'left');
    //     $this->db->group_by('bm.budgetmain_id');
    //     $this->db->order_by('bm.budgetmain_id', 'DESC');
    //     $query = $this->db->get();
    //     return $query->result();
    // }
}