<?php
class NewNSS_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertMain($data)
    {
        $mainData = [
            'excel_name'   => $data['excel_name'] ?? 'Manual Entry_' . date('Ymd_His'),
            'entry_type'   => $data['entry_type'] ?? 'manual',
            'institute_id' => $data['institute_id'] ?? 1,
            'uploaded_on'  => date('Y-m-d H:i:s')
        ];
        
        if ($this->db->insert('nss_excel_uploads', $mainData)) {
            return $this->db->insert_id();
        }
        return false;
    }


    public function insertChild($data)
    {
        $childData = [
            'excel_upload_id' => $data['excel_upload_id'] ?? null,
            'Financial_Year'  => $data['Financial_Year'] ?? null,
            'NssActName'      => $data['NssActName'] ?? null,
            'PlaceOFAct'      => $data['PlaceOFAct'] ?? null,
            'ActDate'         => $data['ActDate'] ?? null,
            'StudPart'        => $data['StudPart'] ?? null,
            'Report_pdf'      => $data['Report_pdf'] ?? null,
            'Month'           => $data['Month'] ?? null,
            'Institute_id'    => $data['Institute_id'] ?? 1,
            'is_default'      => 0
        ];
        
        return $this->db->insert('nss_master', $childData);
    }


    public function updateChild($id, $data)
    {
        $this->db->where('NssAct_ID', $id);
        return $this->db->update('nss_master', $data);
    }


    public function updateMain($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('nss_excel_uploads', $data);
    }

  
    public function deleteChildRecords($excel_id)
    {
        $this->db->where('excel_upload_id', $excel_id);
        return $this->db->delete('nss_master');
    }

 
    public function deleteSingleActivity($nss_act_id)
    {
        $this->db->where('NssAct_ID', $nss_act_id);
        return $this->db->delete('nss_master');
    }

    
public function getdetailview()
    {
        $this->db->select('nss_master.*');
        $this->db->from('nss_master');
        // $this->db->join('finiyear_master', 'nss_master.id = finiyear_master.finiYear_id', 'left');
        $this->db->order_by('nss_master.NssAct_ID ', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

 
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id,finiyear_master.fini_Label');
        // $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
public function getActiveYear()
{
    // $this->db->select('*');
      $this->db->select('finiyear_master.finiYear_id,finiyear_master.fini_Label');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}
       public function getbyid($excel_upload_id)
    {
        $this->db->select('nss_master.*, finiyear_master.fini_Label');
        $this->db->from('nss_master');
        $this->db->join('finiyear_master', 'nss_master.Financial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('nss_master.excel_upload_id', $excel_upload_id);
        $query = $this->db->get();
        return $query->result();
    }


    public function getChildByMainId($excel_upload_id)
    {
        $this->db->select('nss_master.*, finiyear_master.fini_Label');
        $this->db->from('nss_master');
        $this->db->join('finiyear_master', 'nss_master.Financial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('nss_master.excel_upload_id', $excel_upload_id);
        $this->db->order_by('nss_master.NssAct_ID', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getMainById($excel_id)
    {
        $this->db->select('*');
        $this->db->from('nss_excel_uploads');
        $this->db->where('id', $excel_id);
        $query = $this->db->get();
        return $query->row();
    }

 
    public function excelUploadExists($excel_id)
    {
        $this->db->where('id', $excel_id);
        $query = $this->db->get('nss_excel_uploads');
        return $query->num_rows() > 0;
    }

    public function getOrCreateFinancialYear($year_label)
    {
        if (empty($year_label)) {
            return false;
        }

        // Check if year exists
        $this->db->select('finiYear_id');
        $this->db->where('fini_Label', $year_label);
        $query = $this->db->get('finiyear_master');

        if ($query->num_rows() > 0) {
            return $query->row()->finiYear_id;
        }

        // Create new year
        $year_data = [
            'fini_Label'      => $year_label,
            'StartDate'       => null,
            'EndDate'         => null,
            'Active_Deactive' => 1,
            'is_default'      => 0
        ];

        if ($this->db->insert('finiyear_master', $year_data)) {
            return $this->db->insert_id();
        }

        return false;
    }

    
    public function getYearLabel($year_id)
    {
        $this->db->select('fini_Label');
        $this->db->where('finiYear_id', $year_id);
        $query = $this->db->get('finiyear_master');
        
        if ($query->num_rows() > 0) {
            return $query->row()->fini_Label;
        }
        return null;
    }

    // ============ LEGACY SUPPORT (Deprecated) ============
    
    /**
     * @deprecated Use insertChild() instead
     */
    public function insertdata($model)
    {
        return $this->db->insert('nss_master', $model);
    }

    /**
     * @deprecated Use updateChild() instead
     */
    public function update($model)
    {
        return $this->db->where('NssAct_ID', $model['NssAct_ID'])
                        ->update('nss_master', $model);
    }
}
?>