<?php
class Outward_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ============ INSERT METHODS ============
    
    public function insertMainData($data)
    {
        $this->db->insert('outward_main_master', $data);
        return $this->db->insert_id();
    }

    public function insertChildData($data)
    {
        return $this->db->insert('outward_master', $data);
    }

    // ============ UPDATE METHODS ============
    
    public function updateMainData($id, $data)
    {
        $this->db->where('Outward_main_id', $id);
        return $this->db->update('outward_main_master', $data);
    }

    public function updateChildData($id, $data)
    {
        $this->db->where('Outward_id', $id);
        return $this->db->update('outward_master', $data);
    }

    // Delete old child records when updating (optional - use if you want to replace all)
    public function deleteChildByMainId($mainId)
    {
        $this->db->where('fkOutward_main_id', $mainId);
        return $this->db->delete('outward_master');
    }

    // ============ GET/FETCH METHODS ============
    
    public function getMainById($id)
    {
        $this->db->where('Outward_main_id', $id);
        $query = $this->db->get('outward_main_master');
        return $query->result();
    }

    public function getChildByMainId($id)
    {
        // FIXED: Select all columns explicitly including Quantity, Rate, Total
        $this->db->select('outward_master.Outward_id,
                          outward_master.fkOutward_main_id,
                          outward_master.fkCategory_ID,
                          outward_master.fkItem_id,
                          outward_master.fkUnit_ID,
                          outward_master.Quantity,
                          outward_master.Rate,
                          outward_master.Total,
                          itemcategory_master.Category_Name,
                          store_item_master.Item_name,
                          unit_master.Unit_Name');
        $this->db->from('outward_master');
        $this->db->join('itemcategory_master', 'outward_master.fkCategory_ID = itemcategory_master.Category_ID', 'left');
        $this->db->join('store_item_master', 'outward_master.fkItem_id = store_item_master.Item_id', 'left');
        $this->db->join('unit_master', 'outward_master.fkUnit_ID = unit_master.Unit_ID', 'left');
        $this->db->where('fkOutward_main_id', $id);
        $this->db->order_by('outward_master.Outward_id', 'ASC');
        $query = $this->db->get();
        
        // Debug: Check if data is fetched
        $result = $query->result();
        if (empty($result)) {
            log_message('debug', 'No child records found for Outward_main_id: ' . $id);
        }
        
        return $result;
    }

    public function getdetailview()
    {
        $this->db->select('outward_main_master.Outward_main_id,
                            outward_main_master.Applicant_name,
                            outward_main_master.Applicant_id,
                            outward_main_master.Date,
                            outward_main_master.Grand_Total, 
                            outward_main_master.fkmainuser_id, 
                          mainuser_master.mainuser_name,
                          GROUP_CONCAT(DISTINCT store_item_master.Item_name SEPARATOR ", ") as items,
                          SUM(outward_master.Total) as grand_total');
        $this->db->from('outward_main_master');
        $this->db->join('mainuser_master', 'outward_main_master.fkmainuser_id = mainuser_master.mainuser_id', 'left');
        $this->db->join('outward_master', 'outward_main_master.Outward_main_id = outward_master.fkOutward_main_id', 'left');
        $this->db->join('store_item_master', 'outward_master.fkItem_id = store_item_master.Item_id', 'left');
        $this->db->group_by('outward_main_master.Outward_main_id');
        $this->db->order_by('outward_main_master.Outward_main_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getmainuser() 
    {
        $this->db->select('mainuser_id, mainuser_name');
        $this->db->from('mainuser_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }
// In Outward_model.php, add this method:
public function getdepartment()
{
    $this->db->select('department_id, Department_name');
    $this->db->from('outward_department_master');
    $this->db->where('is_active', 1);
    $this->db->order_by('Department_name', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

// ✅ ADD THIS NEW METHOD
public function getDepartmentById($id)
{
    $this->db->select('department_id, Department_name');
    $this->db->from('outward_department_master');
    $this->db->where('department_id', $id);
    $this->db->where('is_active', 1);
    $query = $this->db->get();
    return $query->row();
}
    

    public function getcategory()
    {
        $this->db->select('Category_ID, Category_Name');
        $this->db->from('itemcategory_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Category_Name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getitem()
    {
        $this->db->select('Item_id, Item_name, fkCategory_ID');
        $this->db->from('store_item_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Item_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getunit()
    {
        $this->db->select('Unit_ID, Unit_Name');
        $this->db->from('unit_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Unit_Name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get items by category (for cascading dropdown)
    public function getItemsByCategory($categoryId)
    {
        $this->db->select('Item_id, Item_name');
        $this->db->from('store_item_master');
        $this->db->where('fkCategory_ID', $categoryId);
        $this->db->where('is_active', 1);
        $this->db->order_by('Item_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

     // Add this method in your Inventory_model.php

public function getStockQuantity($itemId)
{
    // Get opening stock from store_item_master
    $this->db->select('opening_stock');
    $this->db->from('store_item_master');
    $this->db->where('Item_id', $itemId);
    $this->db->where('is_active', 1);
    $itemQuery = $this->db->get();
    
    if ($itemQuery->num_rows() == 0) {
        return false;
    }
    
    $item = $itemQuery->row();
    $openingStock = $item->opening_stock ? $item->opening_stock : 0;
    
    // Get total inward quantity
    $this->db->select_sum('Quantity', 'total_inward');
    $this->db->from('inventory_master');
    $this->db->where('fkItem_id', $itemId);
    $inwardQuery = $this->db->get();
    $inwardRow = $inwardQuery->row();
    $totalInward = $inwardRow->total_inward ? $inwardRow->total_inward : 0;
    
    // Get total outward quantity
    $this->db->select_sum('Quantity', 'total_outward');
    $this->db->from('outward_master');
    $this->db->where('fkItem_id', $itemId);
    $outwardQuery = $this->db->get();
    $outwardRow = $outwardQuery->row();
    $totalOutward = $outwardRow->total_outward ? $outwardRow->total_outward : 0;
    
    // Calculate stock: Opening + Inward - Outward
    $stockQty = $openingStock + $totalInward - $totalOutward;
    
    return $stockQty;
}


    // ============ DELETE METHOD ============
    
    public function deleteInventory($id)
    {
        // First delete child records
        $this->db->where('fkOutward_main_id', $id);
        $this->db->delete('outward_master');
        
        // Then delete main record
        $this->db->where('Outward_main_id', $id);
        return $this->db->delete('outward_main_master');
    }

    // Soft delete (if you have is_active column)
    public function softDeleteInventory($id)
    {
        $this->db->where('Outward_main_id', $id);
        return $this->db->update('outward_main_master', array('is_active' => 0));
    }

    // ============ VALIDATION METHODS ============
    
    public function checkDuplicateEntry($date, $supplierId, $excludeId = null)
    {
        $this->db->where('Date', $date);
        $this->db->where('fkmainuser_id', $supplierId);
        if ($excludeId) {
            $this->db->where('Outward_main_id !=', $excludeId);
        }
        $query = $this->db->get('outward_main_master');
        return $query->num_rows() > 0;
    }

    // Check if inventory record exists
    public function inventoryExists($id)
    {
        $this->db->where('Outward_main_id', $id);
        $query = $this->db->get('outward_main_master');
        return $query->num_rows() > 0;
    }

    // ============ REPORTING METHODS (BONUS) ============
    
    public function getInventoryByDateRange($startDate, $endDate)
    {
        $this->db->select('outward_main_master.*, 
                          mainuser_master.Supplier_name,
                          SUM(outward_master.Total) as grand_total');
        $this->db->from('outward_main_master');
        $this->db->join('mainuser_master', 'outward_main_master.fkmainuser_id = mainuser_master.mainuser_id', 'left');
        $this->db->join('outward_master', 'outward_main_master.Outward_main_id = outward_master.fkOutward_main_id', 'left');
        $this->db->where('outward_main_master.Date >=', $startDate);
        $this->db->where('outward_main_master.Date <=', $endDate);
        $this->db->group_by('outward_main_master.Outward_main_id');
        $this->db->order_by('outward_main_master.Date', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getInventoryBySupplier($supplierId)
    {
        $this->db->select('outward_main_master.*, 
                          SUM(outward_master.Total) as grand_total,
                          COUNT(outward_master.Outward_id) as total_items');
        $this->db->from('outward_main_master');
        $this->db->join('outward_master', 'outward_main_master.Outward_main_id = outward_master.fkOutward_main_id', 'left');
        $this->db->where('outward_main_master.fkmainuser_id', $supplierId);
        $this->db->group_by('outward_main_master.Outward_main_id');
        $this->db->order_by('outward_main_master.Date', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get total inventory value
    public function getTotalInventoryValue()
    {
        $this->db->select_sum('Total');
        $query = $this->db->get('outward_master');
        $result = $query->row();
        return $result ? $result->Total : 0;
    }

    // ============ DEBUG METHOD ============
    
    public function debugChildData($id)
    {
        // Simple query without joins to check raw data
        $this->db->where('fkOutward_main_id', $id);
        $query = $this->db->get('outward_master');
        return $query->result();
    }
}
?>