<?php
  class PatentReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
   
    public function getPatenttDataFiltered($institu_id, $branch_ids = null, $year = null, $startdate = null, $enddate = null )
{
    $this->db->select('
        patent_master.patent_id,
        patent_master.patent_name,
        patent_master.fkmainuser_id,
        mainuser_master.mainuser_name,
        patent_master.fkbranch_id,
        branch_master.branch_name,
        patent_master.fkpatenttpye_id,
        patenttpye_master.patenttpye_name,
        patent_master.ApplicNo,
        patent_master.PRN,
        patent_master.Published,
        patent_master.PublicDate,
        patent_master.Granted,
        patent_master.GrantDate,
         patent_master.finicial_Year,
        patent_master.institute,
        patent_master.applicant_id,
        patent_master.applicant_type,
         patent_master.applicant_name
    ');
    $this->db->from('patent_master');
    $this->db->join('branch_master','patent_master.fkbranch_id = branch_master.branch_id','left');
    $this->db->join('mainuser_master','patent_master.fkmainuser_id = mainuser_master.mainuser_id','left');
    $this->db->join('patenttpye_master','patent_master.fkpatenttpye_id = patenttpye_master.patenttpye_id','left');

    if (!empty($institu_id)) {
        $this->db->where('patent_master.institute', $institu_id);
    }
    if (!empty($branch_ids)) {
        $this->db->where_in('patent_master.fkbranch_id', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('patent_master.finicial_Year', $year);
    }
   if (!empty($startdate) && !empty($enddate)) {
    $this->db->where("patent_master.PublicDate BETWEEN '$startdate' AND '$enddate'");
}


    $this->db->order_by('patent_master.patent_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}



   
     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }
 
     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
     public function getmainuser()
     {
      $this->db->select('mainuser_master.*,');
      $this->db->from('mainuser_master');
       $query = $this->db->get();
        return $query->result();
     }
 
     public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
} 
 
   
 // new 

public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("patent_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = patent_master.finicial_Year")
        ->group_by("patent_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId, $branches = [], $userTypes = [])
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("patent_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = patent_master.finicial_Year")
        ->where("patent_master.finicial_Year", $yearId);
         
    if (!empty($branches)) {
        $this->db->where_in('patent_master.fkbranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('patent_master.fkbranch_id', explode(',', $branchIds));
    }
}
    
    if (!empty($userTypes)) {
        $this->db->where_in('patent_master.fkmainuser_id', (array)$userTypes);
    }

    $this->db->group_by("patent_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
    return $this->db->get()->result_array();
}

public function getYearwiseTypes($yearId, $branches = [], $userTypes = [])
{
    $this->db->select("patent_master.patent_id,
                       patent_master.patent_name,
                       patent_master.applicant_name, 
                       finiyear_master.fini_Label as year,
                       mainuser_master.mainuser_name")
        ->from("patent_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = patent_master.finicial_Year")
        ->join("mainuser_master", "mainuser_master.mainuser_id = patent_master.fkmainuser_id", "left")
        ->where("patent_master.finicial_Year", $yearId);
    
    if (!empty($branches)) {
        $this->db->where_in('patent_master.fkbranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('patent_master.fkbranch_id', explode(',', $branchIds));
    }
}
    
    if (!empty($userTypes)) {
        $this->db->where_in('patent_master.fkmainuser_id', (array)$userTypes);
    }

    return $this->db->get()->result_array();
}
 
 

 
// Add these methods to your VAPReport_model class

 public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null, $userTypes = [])
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(patent_master.patent_id) as patent_count');
    $this->db->from('branch_master');
    $this->db->join('patent_master', 'branch_master.branch_id = patent_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('patent_master.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('patent_master.finicial_Year', $year);
    }
    if (!empty($userTypes)) {
        $this->db->where_in('patent_master.fkmainuser_id', (array)$userTypes);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("patent_master.PublicDate BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}


public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null, $userTypes = [])
{
    $this->db->select('patent_master.patent_name,
                       patent_master.patent_id,
                       patent_master.applicant_name,
                       patent_master.fkbranch_id,
                       branch_master.branch_name,
                       mainuser_master.mainuser_name');
    $this->db->from('patent_master');
    $this->db->join('branch_master', 'branch_master.branch_id = patent_master.fkbranch_id', 'left');
    $this->db->join('mainuser_master', 'mainuser_master.mainuser_id = patent_master.fkmainuser_id', 'left');
 
    if (is_array($branch_id)) {
        $this->db->where_in('patent_master.fkbranch_id', $branch_id);
    } else {
        $this->db->where('patent_master.fkbranch_id', $branch_id);
    }
 
    if (!empty($institu)) {
        $this->db->where('patent_master.institute', $institu);
    }
    
    if (!empty($year)) {
        if (is_array($year)) {
            $this->db->where_in('patent_master.finicial_Year', $year);
        } else {
            $this->db->where('patent_master.finicial_Year', $year);
        }
    }
    
    if (!empty($userTypes)) {
        $this->db->where_in('patent_master.fkmainuser_id', (array)$userTypes);
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("patent_master.PublicDate BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null, $userTypes = [])
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.patent_id) as patent_count');
    $this->db->from('branch_master b');
    $this->db->join('patent_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($userTypes)) {
        $this->db->where_in('sr.fkmainuser_id', (array)$userTypes);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.PublicDate BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.patent_id) as count");
    $this->db->from("patent_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sr.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($userTypes)) {
        $this->db->where_in('sr.fkmainuser_id', (array)$userTypes);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.PublicDate BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}


}