<?php
class Practiced_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertdata($model)
    {
         $this->db->insert('practiced_master', $model);
         return $this->db->insert_id();
    }

    public function update($fields)
    {
        $this->db->where('Practiced_id', $fields['Practiced_id']);
        return $this->db->update('practiced_master', $fields);
    }

    public function getbyid($id)
    {
        $this->db->where('Practiced_id', $id);
        $query = $this->db->get('practiced_master');
        return $query->result();
    }

    public function getdetailview()
    {
        $this->db->select('practiced_master.*, 
                          mainuser_master.mainuser_name,
                          platform_master.Platform_name,
                          internduration_master.duration_type,
                          grade_master.Grade_name,
                          status_master.Status_name,
                          finiyear_master.fini_Label');
        $this->db->from('practiced_master');
        $this->db->join('mainuser_master', 'mainuser_master.mainuser_id = practiced_master.fkmainuser_id', 'left');
        $this->db->join('platform_master', 'platform_master.Platform_id = practiced_master.fkPlatform_id', 'left');
        $this->db->join('internduration_master', 'internduration_master.duration_id = practiced_master.fkduration_id', 'left');
        $this->db->join('grade_master', 'grade_master.Grade_id = practiced_master.fkGrade_id', 'left');
        $this->db->join('status_master', 'status_master.Status_id = practiced_master.fkStatus_id', 'left');
        $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = practiced_master.finicial_Year', 'left');
        $this->db->where('practiced_master.is_active', 1);
        $this->db->order_by('practiced_master.Practiced_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getFac() 
    {
        $this->db->select('fac_id, fac_Fullname');
        $this->db->from('faculty_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getstudent() 
    {
        $this->db->select('Student_id, FullName');
        $this->db->from('student_reg');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getmainuser() 
    {
        $this->db->select('mainuser_id, mainuser_name');
        $this->db->from('mainuser_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getduration()
    {
        $this->db->select('duration_id, duration_type');
        $this->db->from('internduration_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getplatform()
    {
        $this->db->select('Platform_id, Platform_name');
        $this->db->from('platform_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getgrade()
    {
        $this->db->select('Grade_id, Grade_name');
        $this->db->from('grade_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getstatus()
    {
        $this->db->select('Status_id, Status_name');
        $this->db->from('status_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

      public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}
}
?>