<?php
  class ScholershipReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  

   

public function getFilteredData($branch_names = [], $levels = [], $castes = [], $year_ids = null)
{
    $this->db->select('
        sm.scholerID,
        sm.PRN,
        sm.ScholershipName,
        sm.FiniYear,
        sm.Student_name,
        sm.branch_name,
        sm.Scholer_Level,
        sm.Caste,
        sm.fkMain_id,
        smm.ExcelName,
        fm.fini_Label as year_label
    ');
    $this->db->from('scholership_master sm');
    
    $this->db->join('scholershipmain_master smm', 'smm.Main_id = sm.fkMain_id', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = smm.FiniYear', 'left');
    
    $this->db->where('sm.is_active', 1);
    
    // ✅ Direct filtering on actual column values
    if (!empty($branch_names) && is_array($branch_names)) {
        $this->db->where_in('sm.branch_name', $branch_names);
    }
    
    if (!empty($levels) && is_array($levels)) {
        $this->db->where_in('sm.Scholer_Level', $levels);
    }
    
    if (!empty($castes) && is_array($castes)) {
        $this->db->where_in('sm.Caste', $castes);
    }
    
    if (!empty($year_ids) && is_array($year_ids)) {
        $this->db->where_in('smm.FiniYear', $year_ids);
    }

    $this->db->order_by('sm.scholerID', 'DESC');
    $query = $this->db->get();
    return $query->result();
}




     public function getBranches()
     {
      $this->db->select('scholerID , branch_name');
      $this->db->group_by('branch_name');
      $this->db->from('scholership_master');
       $query = $this->db->get();
        return $query->result();
     }
     public function getLevels()
     {
      $this->db->select('scholerID , Scholer_Level');
      $this->db->group_by('Scholer_Level');
      $this->db->from('scholership_master');
       $query = $this->db->get();
        return $query->result();
     }
     public function getCastes()
     {
      $this->db->select('scholerID , Caste');
      $this->db->group_by('Caste');
      $this->db->from('scholership_master');
       $query = $this->db->get();
        return $query->result();
     }
    
     
 
    
      public function getYears()
     {
      $this->db->select('finiYear_id, fini_Label');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
       public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
   
 // Get print headings
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }


  // b new 

// public function getAllYearsData()
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(grantrec_master.Grant_id) as count")
//         ->from("grantrec_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = grantrec_master.finicial_Year")
//         ->group_by("grantrec_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getSingleYearData($yearId, $branches = [],)
// {
//     $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(grantrec_master.Grant_id) as count")
//         ->from("grantrec_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = grantrec_master.finicial_Year")
//         ->where("grantrec_master.finicial_Year", $yearId);

//         if (!empty($branches)) {
//                 $this->db->where_in('grantrec_master.fkbranch_id', (array)$branches);
//             }

//         $this->db->group_by("grantrec_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
//         return $this->db->get()->result_array();
// }
 
// public function getYearwiseTypes($yearId, $branches = [],)
// {
//     $this->db->select("grantrec_master.Grant_id,
//                        grantrec_master.fkfac_id,
//                        faculty_master.fac_Fullname,
//                        grantrec_master.fkbranch_id,
//                        branch_master.branch_name,
//                         grantrec_master.Grant_date,
//                        grantrec_master.description,    
//                        grantrec_master.fkgranttype_id, 
//                        granttype_master.granttype_name,      
//                        grantrec_master.Amount_rec,
//                         grantrec_master.Approval_letter,
//                          grantrec_master.Other_doc,  
//                         grantrec_master.institute,
//                        institute_master.Institu_name,
//                        grantrec_master.finicial_Year,       
//                        finiyear_master.fini_Label as year")
//         ->from("grantrec_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = grantrec_master.finicial_Year")
//         ->join('branch_master', 'grantrec_master.fkbranch_id = branch_master.branch_id', 'left')
//         ->join('faculty_master', 'grantrec_master.fkfac_id = faculty_master.fac_id', 'left')
//     ->join('granttype_master', 'grantrec_master.fkgranttype_id = granttype_master.granttype_id', 'left')

//     ->join('institute_master', 'grantrec_master.institute = institute_master.Institu_id', 'left')
// //    ->join('finiyear_master', 'grantrec_master.finicial_Year = finiyear_master.finiYear_id', 'left')
//         ->where("grantrec_master.finicial_Year", $yearId);

        
//     if (!empty($branches)) {
//         $this->db->where_in('grantrec_master.fkbranch_id', (array)$branches);
//        }
//         return $this->db->get()->result_array();
// }
 
 

 
// // Add these methods to your VAPReport_model class

//   public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
// {
//     $this->db->select('branch_master.branch_id,
//                        branch_master.branch_name,
//                        COUNT(grantrec_master.Grant_id) as Grant_count');
//     $this->db->from('branch_master');
//     $this->db->join('grantrec_master', 'branch_master.branch_id = grantrec_master.fkbranch_id', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('grantrec_master.institute', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('branch_master.branch_id', (array)$branches);
//     }
//     if (!empty($year) && $year != 0) {
//         $this->db->where('grantrec_master.finicial_Year', $year);
//     }
//     if (!empty($startDate) && !empty($endDate)) {
//         $this->db->where("grantrec_master.created_at BETWEEN '$startDate' AND '$endDate'");
//     }
 
//     $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
//     $this->db->order_by('branch_master.branch_name', 'ASC');
 
//     return $this->db->get()->result();
// }
 
// public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
// {
//     $this->db->select('grantrec_master.Grant_id,
//                        grantrec_master.fkfac_id,
//                        faculty_master.fac_Fullname,
//                        grantrec_master.fkbranch_id,
//                        branch_master.branch_name,
//                         grantrec_master.Grant_date,
//                        grantrec_master.description,    
//                        grantrec_master.fkgranttype_id, 
//                        granttype_master.granttype_name,      
//                        grantrec_master.Amount_rec,
//                         grantrec_master.Approval_letter,
//                          grantrec_master.Other_doc,  
//                         grantrec_master.institute,
//                        institute_master.Institu_name,
//                        grantrec_master.finicial_Year,
//                        finiyear_master.fini_Label');
//     $this->db->from('grantrec_master');
//     $this->db->join('faculty_master', 'grantrec_master.fkfac_id = faculty_master.fac_id', 'left');
//     $this->db->join('branch_master', 'branch_master.branch_id = grantrec_master.fkbranch_id', 'left');
//     $this->db->join('granttype_master', 'grantrec_master.fkgranttype_id = granttype_master.granttype_id', 'left');
//      $this->db->join('institute_master', 'grantrec_master.institute = institute_master.Institu_id', 'left');
//      $this->db->join('finiyear_master', 'grantrec_master.finicial_Year = finiyear_master.finiYear_id', 'left');
 
//    if (is_array($branch_id)) {
//     $this->db->where_in('grantrec_master.fkbranch_id', $branch_id);
// } else {
//     $this->db->where('grantrec_master.fkbranch_id', $branch_id);
// }
 
 
//     if (!empty($institu)) {
//         $this->db->where('grantrec_master.institute', $institu);
//     }
//     // if (!empty($year) && $year != 0) {
//     //     $this->db->where('grantrec_master.finicial_Year', $year);
//     // }

//     if (!empty($year)) {
//     if (is_array($year)) {
//         $this->db->where_in('grantrec_master.finicial_Year', $year);
//     } else {
//         $this->db->where('grantrec_master.finicial_Year', $year);
//     }
//     }
    
//     if (!empty($startDate) && !empty($endDate)) {
//         $this->db->where("grantrec_master.Grant_date BETWEEN '$startDate' AND '$endDate'");
//     }
 
//     return $this->db->get()->result();
// }
 
//  public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
// {
//     $response = [];
 
//     // --- 1. Branchwise Count ---
//     $this->db->select('b.branch_id, b.branch_name, COUNT(sr.Grant_id) as Grant_count');
//     $this->db->from('branch_master b');
//     $this->db->join('grantrec_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('sr.institute', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('b.branch_id', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sr.finicial_Year', (array)$years);
//     }
//     if (!empty($startDate) && !empty($endDate)) {
//         $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
//     }
 
//     $this->db->group_by('b.branch_id, b.branch_name');
//     $this->db->order_by('b.branch_name', 'ASC');
//     $response['branchData'] = $this->db->get()->result();
 
//     // --- 2. Yearwise Count ---
//     $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Grant_id) as count");
//     $this->db->from("grantrec_master sr");
//     $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
//     if (!empty($institu)) {
//         $this->db->where('sr.Institute', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('sr.fkbranch_id', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sr.finicial_Year', (array)$years);
//     }
//     if (!empty($startDate) && !empty($endDate)) {
//         $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
//     }
 
//     $this->db->group_by("fy.finiYear_id, fy.fini_Label");
//     $this->db->order_by("fy.finiYear_id", "ASC");
//     $response['yearData'] = $this->db->get()->result();
 
//     return $response;
// }
   




}