<?php
class Scholership_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // ============ INSERT METHODS ============
    
    public function insertMain($data)
    {
        $this->db->insert('scholershipmain_master', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        }
        return false;
    }

    public function insertChild($data)
    {
        $this->db->insert('scholership_master', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        }
        return false;
    }

    // ============ UPDATE METHODS ============
    
    public function updateMain($data)
    {
        $this->db->where('Main_id', $data['Main_id']);
        $this->db->update('scholershipmain_master', $data);
        return $this->db->affected_rows() >= 0;
    }

    // ============ DELETE METHODS ============
    
    public function deleteMain($id)
    {
        // Soft delete
        $data = [
            'is_active' => 0,
            'deleted_date' => date('Y-m-d H:i:s'),
            'deleted_by' => $this->session->userdata('user_id') ?? 1
        ];
        
        $this->db->where('Main_id', $id);
        $this->db->update('scholershipmain_master', $data);
        
        // Also soft delete child records
        $this->db->where('fkMain_id', $id);
        $this->db->update('scholership_master', [
            'is_active' => 0,
            'deleted_date' => date('Y-m-d H:i:s'),
            'deleted_by' => $this->session->userdata('user_id') ?? 1
        ]);
        
        return $this->db->affected_rows() >= 0;
    }

    public function deleteChildByMainId($mainId)
    {
        // Hard delete for update scenario
        $this->db->where('fkMain_id', $mainId);
        $this->db->delete('scholership_master');
        return true;
    }

    // ============ SELECT METHODS ============
    
    public function getMainById($id)
    {
        $this->db->select('*');
        $this->db->from('scholershipmain_master');
        $this->db->where('Main_id', $id);
        $this->db->where('is_active', 1);
        return $this->db->get()->row();
    }

    public function getChildByMainId($mainId)
    {
        $this->db->select('*');
        $this->db->from('scholership_master');
        $this->db->where('fkMain_id', $mainId);
        $this->db->where('is_active', 1);
        $this->db->order_by('scholerID', 'ASC');
        return $this->db->get()->result();
    }

     public function getdetailview2()
    {
        $this->db->select('
            s.scholerID,
            s.fkMain_id,
            s.Student_name as FullName,
            s.PRN,
            s.mobile_no,
            s.branch_name,
            s.Scholer_Level as ScholerName,
            s.ScholershipName,
            s.Caste as caste_name,
            sm.FiniYear,
            fy.fini_Label as year_label
        ');
        $this->db->from('scholership_master s');
        $this->db->join('scholershipmain_master sm', 'sm.Main_id = s.fkMain_id', 'left');
        $this->db->join('finiyear_master fy', 'fy.finiYear_id = sm.FiniYear', 'left');
        $this->db->where('s.is_active', 1);
        $this->db->where('sm.is_active', 1);
        $this->db->order_by('s.scholerID', 'DESC');
        return $this->db->get()->result();
    }

     public function getdetailview()
    {
        $this->db->select('
           scholershipmain_master.Main_id,
           scholershipmain_master.ExcelName,
            scholershipmain_master.FiniYear,
            finiyear_master.fini_Label as year_label
        ');
        $this->db->from('scholershipmain_master');
        // $this->db->join('scholershipmain_master scholershipmain_master', 'scholershipmain_master.Main_id = s.fkMain_id', 'left');
        $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = scholershipmain_master.FiniYear', 'left');
       
        $this->db->where('scholershipmain_master.is_active', 1);
        $this->db->order_by('scholershipmain_master.Main_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getActiveYear()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    public function getYears()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('fini_Label', 'DESC');
        return $this->db->get()->result();
    }

    // Update individual child record
public function updateChild($data)
{
    $this->db->where('scholerID', $data['scholerID']);
    $this->db->update('scholership_master', $data);
    return $this->db->affected_rows() >= 0;
}

// Delete specific child records by IDs
public function deleteChildByIds($ids)
{
    if (empty($ids)) return true;
    
    $this->db->where_in('scholerID', $ids);
    $this->db->update('scholership_master', [
        'is_active' => 0,
        'deleted_date' => date('Y-m-d H:i:s'),
        'deleted_by' => $this->session->userdata('user_id') ?? 1
    ]);
    
    return true;
}
}