<?php
class StockReport_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function getFilteredData($institu, $category = [], $item = [], $year = null, $startDate = null, $endDate = null)
    {
        // Build the query to get stock data with calculations
        $this->db->select('
            store_item_master.Item_id,
            store_item_master.Item_name,
            store_item_master.fkCategory_ID,
            itemcategory_master.Category_name,
            store_item_master.opening_stock,
            unit_master.Unit_name,
            finiyear_master.fini_Label
        ');
        
        $this->db->from('store_item_master');
        
        // Join category
        $this->db->join('itemcategory_master', 
            'store_item_master.fkCategory_ID = itemcategory_master.Category_id', 
            'left');
        
        // Join unit
        $this->db->join('unit_master', 
            'store_item_master.fkUnit_ID = unit_master.Unit_ID', 
            'left');
        
        // Join financial year
        $this->db->join('finiyear_master', 
            'store_item_master.finicial_Year = finiyear_master.finiYear_id', 
            'left');

        // Institute filter
        if (!empty($institu)) {
            $this->db->where('store_item_master.institute', $institu);
        }

        // Category filter
        if (!empty($category)) {
            if (is_array($category)) {
                $this->db->where_in('store_item_master.fkCategory_ID', $category);
            } else {
                $this->db->where('store_item_master.fkCategory_ID', $category);
            }
        }

        // Item filter
        if (!empty($item)) {
            if (is_array($item)) {
                $this->db->where_in('store_item_master.Item_id', $item);
            } else {
                $this->db->where('store_item_master.Item_id', $item);
            }
        }

        // Year filter
        if (!empty($year) && $year != 0) {
            $this->db->where('store_item_master.finicial_Year', $year);
        }

        // Active records only
        $this->db->where('store_item_master.is_active', 1);

        $this->db->order_by('itemcategory_master.Category_name', 'ASC');
        $this->db->order_by('store_item_master.Item_name', 'ASC');
        
        $items = $this->db->get()->result();
        
        // Now calculate inward and outward for each item
        foreach ($items as $item) {
            // Get Inward Quantity
            $this->db->select_sum('inventory_master.Quantity', 'inward_qty');
            $this->db->from('inventory_master');
            $this->db->join('inventory_main_master', 
                'inventory_master.fkInventory_main_id = inventory_main_master.Inventory_main_id', 
                'inner');
            $this->db->where('inventory_master.fkItem_id', $item->Item_id);
            $this->db->where('inventory_main_master.is_active', 1);
            
            if (!empty($institu)) {
                $this->db->where('inventory_main_master.institute', $institu);
            }
            if (!empty($year) && $year != 0) {
                $this->db->where('inventory_main_master.finicial_Year', $year);
            }
            if (!empty($startDate) && !empty($endDate)) {
                $this->db->where("DATE(inventory_main_master.Date) BETWEEN '$startDate' AND '$endDate'");
            }
            
            $inward = $this->db->get()->row();
            $item->inward_qty = $inward->inward_qty ? $inward->inward_qty : 0;
            
            // Get Outward Quantity
            $this->db->select_sum('outward_master.Quantity', 'outward_qty');
            $this->db->from('outward_master');
            $this->db->join('outward_main_master', 
                'outward_master.fkOutward_main_id = outward_main_master.Outward_main_id', 
                'inner');
            $this->db->where('outward_master.fkItem_id', $item->Item_id);
            $this->db->where('outward_main_master.is_active', 1);
            
            if (!empty($institu)) {
                $this->db->where('outward_main_master.institute', $institu);
            }
            if (!empty($year) && $year != 0) {
                $this->db->where('outward_main_master.finicial_Year', $year);
            }
            if (!empty($startDate) && !empty($endDate)) {
                $this->db->where("DATE(outward_main_master.Date) BETWEEN '$startDate' AND '$endDate'");
            }
            
            $outward = $this->db->get()->row();
            $item->outward_qty = $outward->outward_qty ? $outward->outward_qty : 0;
            
            // Calculate Stock Quantity
            $item->stock_qty = $item->opening_stock + $item->inward_qty - $item->outward_qty;
        }
        
        return $items;
    }

    public function getCategory()
    {
        $this->db->select('Category_id, Category_name');
        $this->db->from('itemcategory_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Category_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getItems()
    {
        $this->db->select('store_item_master.Item_id, store_item_master.Item_name, store_item_master.fkCategory_ID, itemcategory_master.Category_name');
        $this->db->from('store_item_master');
        $this->db->join('itemcategory_master', 'store_item_master.fkCategory_ID = itemcategory_master.Category_id', 'left');
        $this->db->where('store_item_master.is_active', 1);
        $this->db->order_by('store_item_master.Item_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getItemsByCategory($category_id)
    {
        $this->db->select('Item_id, Item_name');
        $this->db->from('store_item_master');
        $this->db->where('fkCategory_ID', $category_id);
        $this->db->where('is_active', 1);
        $this->db->order_by('Item_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getyear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getinstitu()
    {
        $this->db->select('*');
        $this->db->from('institute_master');
        $this->db->order_by('Institu_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}