<?php
  class Studassociation_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('stud_associationmaster',$model);
			//return $sql->result();
	} 


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


public function getDataByInstitute($year_id, )
{
    $this->db->select('
        stud_associationmaster.*, ');

    $this->db->from('stud_associationmaster');

    
    if (!empty($year_id)) {
    $this->db->where('stud_associationmaster.year', $year_id);
}

        $this->db->order_by('stud_associationmaster.ass_id','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}


public function getActivityByMainId($fk_assID)
{
    return $this->db->select('student_name, designation,PRN,mobile,branch_master.branch_name,')
                    ->from('studassociation_student')
    ->join('branch_master', 'branch_master.branch_id = studassociation_student.fk_branch', 'left')
                    ->where('fk_assID', $fk_assID)
                    ->get()
                    ->result_array();
}

public function getGuestsByMainId($fk_associID)
{
    return $this->db->select('activity_name, date, photo_link')
                    ->from('studassociation_activity')
                    ->where('fk_associID', $fk_associID)
                    ->get()
                    ->result_array();
}

  // chart code
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("stud_associationmaster")
        ->join("finiyear_master", "finiyear_master.finiYear_id = stud_associationmaster.Financial_Year")
        ->group_by("stud_associationmaster.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("stud_associationmaster")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = stud_associationmaster.Financial_Year")
//         ->where("stud_associationmaster.Financial_Year", $yearId)
//         ->group_by("stud_associationmaster.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("stud_associationmaster.soft_id, stud_associationmaster.soft_name, finiyear_master.fini_Label as year,")
//         ->from("stud_associationmaster")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = stud_associationmaster.Financial_Year")
//      ->where("stud_associationmaster.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("stud_associationmaster")
        ->join("finiyear_master", "finiyear_master.finiYear_id = stud_associationmaster.Financial_Year")
        ->where("stud_associationmaster.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('stud_associationmaster.fk_branch', (array)$branches);
    }
  
 
    $this->db->group_by("stud_associationmaster.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("stud_associationmaster.soft_id, stud_associationmaster.soft_name, finiyear_master.fini_Label as year,")
        ->from("stud_associationmaster")
        ->join("finiyear_master", "finiyear_master.finiYear_id = stud_associationmaster.Financial_Year")
                // ->join('student_reg', 'student_reg.Student_id = stud_associationmaster.fk_student')
        ->where("stud_associationmaster.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('stud_associationmaster.fk_branch', (array)$branches);
    }
    
 
    return $this->db->get()->result_array();
}

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(stud_associationmaster.soft_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('stud_associationmaster', 'branch_master.branch_id = stud_associationmaster.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('stud_associationmaster.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('stud_associationmaster.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('stud_associationmaster.soft_name,
                       stud_associationmaster.soft_id,
                       stud_associationmaster.fk_branch,
                       branch_master.branch_name,
                        ');
    $this->db->from('stud_associationmaster');
    $this->db->join('branch_master', 'branch_master.branch_id = stud_associationmaster.fk_branch', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('stud_associationmaster.fk_branch', $branch_id);
} else {
    $this->db->where('stud_associationmaster.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('stud_associationmaster.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('stud_associationmaster.Financial_Year', $year);
    // }

  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('stud_associationmaster.Financial_Year', $year);
    } else {
        $this->db->where('stud_associationmaster.Financial_Year', $year);
    }
}
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("stud_associationmaster.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.soft_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('stud_associationmaster sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.soft_id) as count");
    $this->db->from("stud_associationmaster sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
    

}