<?php
class StudentClub_model extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    // ----------------- INSERT / UPDATE CLUB -----------------

    // Insert new student club
    public function insertdata($model) {
     $this->db->insert('studentclub_master', $model);
     return $this->db->insert_id();
    }


    // Update student club (pass $club_id separately)
    public function update($model, $club_id) {
        return $this->db->where('club_id', $club_id)
                        ->update('studentclub_master', $model);
    }

    // Fetch by id
    public function getbyid($id) {
        return $this->db
            ->select("studentclub_master.*")
            ->where('club_id', $id)
            ->get('studentclub_master')
            ->result();
    }

    // ----------------- FETCH DATA -----------------

    // Get all clubs with branch, faculty & student details
    public function getdetailview() {
        $this->db->select('studentclub_master.*, finiyear_master.fini_Label, faculty_master.fac_Fullname, student_reg.FullName');
        $this->db->from('studentclub_master');
        $this->db->join('finiyear_master', 'studentclub_master.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->join('faculty_master', 'studentclub_master.fkFacCo_id = faculty_master.fac_id', 'left');
        $this->db->join('student_reg', 'studentclub_master.fkStudCo_id = student_reg.Student_id', 'left');
        $this->db->order_by('studentclub_master.club_id', 'DESC');
        return $this->db->get()->result();
    }


    // Dropdown lists
    public function get_all_Branch() {
        return $this->db->get('branch_master')->result();
    }

    public function get_all_Faculty() {
        return $this->db->get('faculty_master')->result();
    }

      public function get_all_year() {
        return $this->db->get('finiyear_master')->result();
    }

    public function get_all_Student() {
        return $this->db->get('student_reg')->result();
    }

    // ----------------- GALLERY FUNCTIONS -----------------

    // Insert single gallery photo
    public function insertGallery($data) {
        return $this->db->insert('studentclub_gallery', $data);
    }

    // Insert multiple gallery photos
    public function insertMultiplePhotos($club_id, $file_paths) {
        if (empty($file_paths)) return false;
        $insert_data = [];
        foreach ($file_paths as $path) {
            $insert_data[] = [
                'club_id'   => $club_id,
                'file_path' => $path
            ];
        }
        return $this->db->insert_batch('studentclub_gallery', $insert_data);
    }

    // Get gallery by club id
    public function getClubGallery($club_id) {
        return $this->db
            ->select('*')
            ->from('studentclub_gallery')
            ->where('club_id', $club_id)
            ->get()
            ->result();
    }

    // Delete all gallery photos for a club
    public function deleteimagedata($club_id) {
        return $this->db->where('club_id', $club_id)
                        ->delete('studentclub_gallery');
    }

    // Delete specific gallery photos
    public function deleteSpecificPhotos($club_id, $file_paths) {
        if (empty($file_paths)) return false;
        $this->db->where('club_id', $club_id);
        $this->db->where_in('file_path', $file_paths);
        return $this->db->delete('studentclub_gallery');
    }


    public function deleteExistingPhotos($club_id, $removed_photos_array)
{
    if (!empty($removed_photos_array)) {
        // Delete from DB
        $this->db->where('club_id', $club_id);
        $this->db->where_in('file_path', $removed_photos_array);
        $this->db->delete('studentclub_gallery'); // table name

        // Delete physical files
        foreach ($removed_photos_array as $file_path) {
            $full_path = FCPATH . $file_path; // full server path
            if (file_exists($full_path)) {
                unlink($full_path);
            }
        }
    }
}

public function getFacultyByBranch($branch_id) {
    return $this->db->where('fkbranch_id', $branch_id)
                    ->get('faculty_master')
                    ->result();
}

public function getStudentsByBranch($branch_id) {
    return $this->db->where('fkbranch_id', $branch_id)
                    ->get('student_reg')
                    ->result();
}

      public function get_all_institute()
{
    return $this->db->get('institute_master')->result();
}

public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }

public function getDataByInstitute($institute_id, $startdate = null, $enddate = null, $year = null, $branches = [], $faculties = [], $students = [])
{
    $this->db->select('studentclub_master.*, 
                       branch_master.branch_name, 
                       faculty_master.fac_Fullname as faculty_name, 
                       student_reg.FullName as student_name,
                       institute_master.Institu_name,
                       finiyear_master.fini_Label');
    $this->db->from('studentclub_master');
    $this->db->join('branch_master', 'studentclub_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('faculty_master', 'studentclub_master.fkFacCo_id = faculty_master.fac_id', 'left');
    $this->db->join('student_reg', 'studentclub_master.fkStudCo_id = student_reg.Student_id', 'left');
    $this->db->join('finiyear_master', 'studentclub_master.FiniYear = finiyear_master.finiYear_id', 'left');
    $this->db->join('institute_master', 'studentclub_master.InstituteId = institute_master.Institu_id', 'left');

    // ✅ Filter by institute
    if (!empty($institute_id)) {
        $this->db->where('studentclub_master.InstituteId', $institute_id);
    }

    // ✅ Filter by year
    if (!empty($year) && $year != '0') {
        $this->db->where('studentclub_master.FiniYear', $year);
    }

    // ✅ Filter by StartDate between
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('studentclub_master.StartDate >=', $startdate);
        $this->db->where('studentclub_master.StartDate <=', $enddate);
    }

    // ✅ Filter by multi-select branch
    if (!empty($branches)) {
        $this->db->where_in('studentclub_master.fkbranch_id', $branches);
    }

    // ✅ Filter by multi-select faculty coordinator
    if (!empty($faculties)) {
        $this->db->where_in('studentclub_master.fkFacCo_id', $faculties);
    }

    // ✅ Filter by multi-select student coordinator
    if (!empty($students)) {
        $this->db->where_in('studentclub_master.fkStudCo_id', $students);
    }

    $this->db->order_by('studentclub_master.StartDate', 'DESC');
    $query = $this->db->get();
    return $query->result();
}



 public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}


 public function insertStudents($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('student_list', $data);
        }
        return false;
    }


// Get all students by club_id (if you want relation)
public function getStudentsByClub($club_id) {
    return $this->db->where('club_id', $club_id)
                    ->get('student_list')
                    ->result();
}

// Delete students of a club (when updating)
public function deleteStudentsByClub($club_id) {
    return $this->db->where('club_id', $club_id)
                    ->delete('student_list');
}



public function insertActivities($data) {
    if (!empty($data)) {
        return $this->db->insert_batch('activities', $data);
    }
    return false;
}

public function getActivitiesByClub($club_id) {
    return $this->db->where('club_id', $club_id)
                    ->get('activities')
                    ->result();
}

public function deleteActivitiesByClub($club_id) {
    return $this->db->where('club_id', $club_id)
                    ->delete('activities');
}



public function get_students_by_club($club_id)
{
    $this->db->where('club_id', $club_id);
    $query = $this->db->get('student_list');
    return $query->result();
}


public function get_students_by_activity($club_id)
{
    $this->db->where('club_id', $club_id);
    $query = $this->db->get('activities');
    return $query->result();
}
public function getClubFullDetails($club_id) {
    $data = [];

    // Main club details
    $data['club'] = $this->db
        ->select('studentclub_master.*, branch_master.branch_name, faculty_master.fac_Fullname, student_reg.FullName')
        ->from('studentclub_master')
        ->join('branch_master', 'studentclub_master.fkbranch_id = branch_master.branch_id', 'left')
        ->join('faculty_master', 'studentclub_master.fkFacCo_id = faculty_master.fac_id', 'left')
        ->join('student_reg', 'studentclub_master.fkStudCo_id = student_reg.Student_id', 'left')
        ->where('studentclub_master.club_id', $club_id)
        ->get()
        ->row();

    // Related students
    $data['students'] = $this->getStudentsByClub($club_id);

    // Related activities
    $data['activities'] = $this->getActivitiesByClub($club_id);

    // Related gallery
    $data['gallery'] = $this->getClubGallery($club_id);

    return $data;
}



   // Add this function
    public function deleteStudents($id) {
        $this->db->where('id', $id);
        return $this->db->delete('student_list'); // <-- table name adjust as per your DB
    }


     public function deleteActivities($id) {
        $this->db->where('id', $id);
        return $this->db->delete('activities'); // <-- change table name if needed
    }




    

    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("studentclub_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = studentclub_master.FiniYear")
        ->group_by("studentclub_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}



public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(*) as count")
        ->from("studentclub_master sc")
        ->join("finiyear_master fy", "fy.finiYear_id = sc.FiniYear");

    $this->db->where("sc.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where('sc.fkInstitu_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sc.fkbranch_id', (array)$branches);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sc.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("sc.FiniYear, fy.fini_Label, fy.finiYear_id");

    return $this->db->get()->result_array();
}

public function getYearwiseTypes($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("
            sc.NameClub, 
            sc.fkbranch_id, 
            b.branch_name, 
            fy.fini_Label as year
        ")
        ->from("studentclub_master sc")
        ->join("finiyear_master fy", "fy.finiYear_id = sc.FiniYear")
        ->join("branch_master b", "b.branch_id = sc.fkbranch_id", "left")
        ->where("sc.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where('sc.fkInstitu_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sc.fkbranch_id', (array)$branches);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sc.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    return $this->db->get()->result_array();
}

 

// Add these methods to your VAPReport_model class


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }

  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(studentclub_master.Student_id) as club_count');
    $this->db->from('branch_master');
    $this->db->join('studentclub_master', 'branch_master.branch_id = studentclub_master.fkbranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('studentclub_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('studentclub_master.FiniYear', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("studentclub_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');

    return $this->db->get()->result();
}

public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('
                       studentclub_master.club_id,
                       studentclub_master.NameClub,
                       studentclub_master.fkbranch_id,
                       branch_master.branch_name');
    $this->db->from('studentclub_master');
    $this->db->join('branch_master', 'branch_master.branch_id = studentclub_master.fkbranch_id', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('studentclub_master.fkbranch_id', $branch_id);
} else {
    $this->db->where('studentclub_master.fkbranch_id', $branch_id);
}


    if (!empty($institu)) {
        $this->db->where('studentclub_master.fkInstitName_id', $institu);
    }
    if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('studentclub_master.FiniYear', $year);
    } else {
        $this->db->where('studentclub_master.FiniYear', $year);
    }
}
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('studentclub_master.FiniYear', $year);
    // }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("studentclub_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    return $this->db->get()->result();
}

 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.club_id) as club_count');
    $this->db->from('branch_master b');
    $this->db->join('studentclub_master sr', 'b.branch_id = sr.fkbranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.FiniYear', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();

    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.club_id) as count");
    $this->db->from("studentclub_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.FiniYear");

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.FiniYear', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}


public function getAllClubNames()
{
    return $this->db->select('club_id, NameClub')
        ->from('studentclub_master')
        ->order_by('NameClub', 'ASC')
        ->get()
        ->result();
}



public function getStudentByPrnAndClub($club_id, $prn) {
    $this->db->where('club_id', $club_id);
    $this->db->where('prn', $prn);
    $query = $this->db->get('student_list');
    return $query->row();
}

public function updateStudent($id, $data) {
    $this->db->where('id', $id);
    return $this->db->update('student_list', $data);
}



public function getActivityByNameAndClub($club_id, $activity_name) {
    $this->db->where('club_id', $club_id);
    $this->db->where('activity_name', $activity_name);
    $query = $this->db->get('activities');
    return $query->row();
}

public function updateActivity($id, $data) {
    $this->db->where('id', $id);
    return $this->db->update('activities', $data);
}

}
