<?php
class StudentFeedReport_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Get all hostels
    public function getHostels()
    {
        $this->db->select('Hostel_id, Hostel_Name');
        $this->db->from('hostel_master');
        $this->db->where('is_on', 1);
        $this->db->order_by('Hostel_Name', 'ASC');
        return $this->db->get()->result();
    }

    // Get all branches
    public function getBranches()
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        return $this->db->get()->result();
    }

    // Get all institutes
    public function getInstitutes()
    {
        $this->db->select('Institu_id, Institu_name');
        $this->db->from('institute_master');
        $this->db->where('is_active', 1);
        // $this->db->order_by('Institu_name', 'ASC');
        return $this->db->get()->result();
    }

    // Get active year
    public function getActiveYear()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    // Get all years
    public function getYears()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        return $this->db->get()->result();
    }

    // Get filtered feedback data
    // public function getFeedbackDataFiltered($hostel_ids = null, $branch_ids = null, $year_ids = null, $Institu_ids = null)
    // {
    //     $this->db->select('
    //         fm.feedback_id,
    //         fm.student_name,
    //         fm.prnno as prno,
    //         bm.branch_name,
    //         hm.Hostel_Name as hostel_name,
    //         fy.fini_Label as year_label,
    //         im.Institu_name as institute_name,
    //         sfu.generated_url as url
           
    //     ', FALSE);
        
    //     $this->db->from('feedback_main fm');
    //     $this->db->join('branch_master bm', 'bm.branch_id = fm.branchId', 'left');
    //     $this->db->join('hostel_master hm', 'hm.Hostel_id = fm.Hostel_id', 'left');
    //     $this->db->join('finiyear_master fy', 'fy.finiYear_id = fm.financial_year_id', 'left');
    //     $this->db->join('institute_master im', 'im.Institu_id = fm.institute_id', 'left');
    //     $this->db->join('student_feedback_urls sfu', 'sfu.url_id = fm.fkURL_id', 'left');
    //     // $this->db->join('url_master um', 'um.url_id = fm.fkURL_id', 'left');
        
    //     $this->db->where('fm.is_active', 1);
        
    //     if (!empty($hostel_ids) && is_array($hostel_ids)) {
    //         $this->db->where_in('fm.Hostel_id', $hostel_ids);
    //     }
        
    //     if (!empty($branch_ids) && is_array($branch_ids)) {
    //         $this->db->where_in('fm.branchId', $branch_ids);
    //     }
        
    //     if (!empty($year_ids) && is_array($year_ids)) {
    //         $this->db->where_in('fm.financial_year_id', $year_ids);
    //     }
        
    //     if (!empty($Institu_ids) && is_array($Institu_ids)) {
    //         $this->db->where_in('fm.institute_id', $Institu_ids);
    //     }
        
    //     $this->db->order_by('fm.feedback_id', 'ASC');
        
    //     $query = $this->db->get();
    //     log_message('debug', 'Feedback Filter Query: ' . $this->db->last_query());
        
    //     return $query->result();
    // }

    // Get branchwise count with filters
    public function getBranchwiseCount($branches = [], $years = [])
    {
        $this->db->select('
            bm.branch_id,
            bm.branch_name,
            COUNT(fm.feedback_id) as feedback_count
        ');
        $this->db->from('branch_master bm');
        $this->db->join('feedback_main fm', 'fm.branchId = bm.branch_id AND fm.is_active = 1', 'left');
        
        if (!empty($branches) && is_array($branches)) {
            $this->db->where_in('bm.branch_id', $branches);
        }
        
        if (!empty($years) && is_array($years)) {
            $this->db->where_in('fm.financial_year_id', $years);
        }
        
        $this->db->where('bm.is_active', 1);
        $this->db->group_by('bm.branch_id, bm.branch_name');
        $this->db->having('COUNT(fm.feedback_id) >', 0);
        $this->db->order_by('bm.branch_name', 'ASC');
        
        log_message('debug', 'getBranchwiseCount Query: ' . $this->db->get_compiled_select('', FALSE));
        
        return $this->db->get()->result();
    }

    // Get yearwise count with filters
    public function getYearwiseCount($branches = [], $years = [])
    {
        $this->db->select('
            fy.finiYear_id as year_id,
            fy.fini_Label as year,
            COUNT(fm.feedback_id) as count
        ');
        $this->db->from('finiyear_master fy');
        $this->db->join('feedback_main fm', 'fm.financial_year_id = fy.finiYear_id AND fm.is_active = 1', 'left');
        
        if (!empty($branches) && is_array($branches)) {
            $this->db->where_in('fm.branchId', $branches);
        }
        
        if (!empty($years) && is_array($years)) {
            $this->db->where_in('fy.finiYear_id', $years);
        }
        
        $this->db->group_by('fy.finiYear_id, fy.fini_Label');
        $this->db->having('COUNT(fm.feedback_id) >', 0);
        $this->db->order_by('fy.finiYear_id', 'ASC');
        
        return $this->db->get()->result();
    }

    // Get combined chart data
    public function getCombinedChartData($branches = [], $years = [])
    {
        return [
            'branchData' => $this->getBranchwiseCount($branches, $years),
            'yearData' => $this->getYearwiseCount($branches, $years)
        ];
    }

    // Get branch details data
    public function getBranchDetailsData($branch_id, $years = [])
    {
        $this->db->select('
            fm.feedback_id,
            fm.student_name,
            fm.prnno as prno,
            bm.branch_name,
            hm.Hostel_Name as hostel_name,
            fy.fini_Label as year_label,
            im.Institu_name as institute_name,
            sfu.generated_url as url
        ', FALSE);
        
        $this->db->from('feedback_main fm');
        $this->db->join('branch_master bm', 'bm.branch_id = fm.branchId', 'left');
        $this->db->join('hostel_master hm', 'hm.Hostel_id = fm.Hostel_id', 'left');
        $this->db->join('finiyear_master fy', 'fy.finiYear_id = fm.financial_year_id', 'left');
        $this->db->join('institute_master im', 'im.Institu_id = fm.institute_id', 'left');
        $this->db->join('student_feedback_urls sfu', 'sfu.url_id = fm.fkURL_id', 'left');
        
        if (is_array($branch_id)) {
            $this->db->where_in('fm.branchId', $branch_id);
        } else {
            $this->db->where('fm.branchId', $branch_id);
        }
        
        if (!empty($years) && is_array($years)) {
            $this->db->where_in('fm.financial_year_id', $years);
        }
        
        $this->db->where('fm.is_active', 1);
        $this->db->order_by('fm.feedback_id', 'ASC');
        
        log_message('debug', 'getBranchDetailsData Query: ' . $this->db->get_compiled_select('', FALSE));
        
        return $this->db->get()->result();
    }

    // Get year details data
    public function getYearDetailsData($year_id, $branches = [])
    {
        $this->db->select('
            fm.feedback_id,
            fm.student_name,
            fm.prnno as prno,
            bm.branch_name,
            hm.Hostel_Name as hostel_name,
            fy.fini_Label as year_label,
            im.Institu_name as institute_name,
            sfu.generated_url as url
        ', FALSE);
        
        $this->db->from('feedback_main fm');
        $this->db->join('branch_master bm', 'bm.branch_id = fm.branchId', 'left');
        $this->db->join('hostel_master hm', 'hm.Hostel_id = fm.Hostel_id', 'left');
        $this->db->join('finiyear_master fy', 'fy.finiYear_id = fm.financial_year_id', 'left');
        $this->db->join('institute_master im', 'im.Institu_id = fm.institute_id', 'left');
        $this->db->join('student_feedback_urls sfu', 'sfu.url_id = fm.fkURL_id', 'left');
        
        if (is_array($year_id)) {
            $this->db->where_in('fm.financial_year_id', $year_id);
        } else {
            $this->db->where('fm.financial_year_id', $year_id);
        }
        
        if (!empty($branches) && is_array($branches)) {
            $this->db->where_in('fm.branchId', $branches);
        }
        
        $this->db->where('fm.is_active', 1);
        $this->db->order_by('fm.feedback_id', 'ASC');
        
        return $this->db->get()->result();
    }

    // Get print headings
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

 // Add this method to your StudentFeedReport_model.php

/**
 * Get feedback details by Feedback ID (for specific student)
 * Fetches all responses from feedback_detail table for a specific feedback record
 */
public function getFeedbackDetailsByFeedback($feedback_id)
{
    $this->db->select('
        fd.detail_id,
        fd.feedback_id,
        fd.heading_id,
        fd.subheading_id,
        fd.option_id,
        hm.heading_text as heading,
        shm.subheading_text as subheading,
        om.option_text as option_text
    ', FALSE);
    
    $this->db->from('feedback_detail fd');
    
    // Join with heading master
    $this->db->join('feedbackheading hm', 'hm.heading_id = fd.heading_id', 'left');
    
    // Join with subheading master
    $this->db->join('feedbacksubheading shm', 'shm.subheading_id = fd.subheading_id', 'left');
    
    // Join with option master to get the selected option text
    $this->db->join('feedbackoption om', 'om.option_id = fd.option_id', 'left');
    
    $this->db->where('fd.feedback_id', $feedback_id);
    
    $this->db->order_by('fd.heading_id', 'ASC');
    $this->db->order_by('fd.subheading_id', 'ASC');
    
    $query = $this->db->get();
    
    log_message('debug', 'getFeedbackDetailsByFeedback Query: ' . $this->db->last_query());
    
    return $query->result();
}

/**
 * Get feedback details by URL ID (OLD METHOD - keeping for reference)
 * Fetches all responses from feedback_detail table for a specific URL
 */
public function getFeedbackDetailsByUrl($url_id)
{
    $this->db->select('
        fd.detail_id,
        fd.feedback_id,
        fd.heading_id,
        fd.subheading_id,
        fd.option_id,
        hm.heading_name as heading,
        shm.subheading_name as subheading,
        om.option_text as option_text
    ', FALSE);
    
    $this->db->from('feedback_detail fd');
    $this->db->join('feedback_main fm', 'fm.feedback_id = fd.feedback_id', 'inner');
    
    // Join with heading master
    $this->db->join('heading_master hm', 'hm.heading_id = fd.heading_id', 'left');
    
    // Join with subheading master
    $this->db->join('subheading_master shm', 'shm.subheading_id = fd.subheading_id', 'left');
    
    // Join with option master to get the selected option text
    $this->db->join('option_master om', 'om.option_id = fd.option_id', 'left');
    
    $this->db->where('fm.fkURL_id', $url_id);
    $this->db->where('fm.is_active', 1);
    
    $this->db->order_by('fd.heading_id', 'ASC');
    $this->db->order_by('fd.subheading_id', 'ASC');
    
    $query = $this->db->get();
    
    log_message('debug', 'getFeedbackDetailsByUrl Query: ' . $this->db->last_query());
    
    return $query->result();
}

/**
 * Update getFeedbackDataFiltered to include fkURL_id
 */
public function getFeedbackDataFiltered($hostel_ids = null, $branch_ids = null, $year_ids = null, $Institu_ids = null)
{
    $this->db->select('
        fm.feedback_id,
        fm.student_name,
        fm.prnno as prno,
        fm.fkURL_id,
        bm.branch_name,
        hm.Hostel_Name as hostel_name,
        fy.fini_Label as year_label,
        im.Institu_name as institute_name,
        sfu.generated_url as url
    ', FALSE);
    
    $this->db->from('feedback_main fm');
    $this->db->join('branch_master bm', 'bm.branch_id = fm.branchId', 'left');
    $this->db->join('hostel_master hm', 'hm.Hostel_id = fm.Hostel_id', 'left');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = fm.financial_year_id', 'left');
    $this->db->join('institute_master im', 'im.Institu_id = fm.institute_id', 'left');
    $this->db->join('student_feedback_urls sfu', 'sfu.url_id = fm.fkURL_id', 'left');
    
    $this->db->where('fm.is_active', 1);
    
    if (!empty($hostel_ids) && is_array($hostel_ids)) {
        $this->db->where_in('fm.Hostel_id', $hostel_ids);
    }
    
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('fm.branchId', $branch_ids);
    }
    
    if (!empty($year_ids) && is_array($year_ids)) {
        $this->db->where_in('fm.financial_year_id', $year_ids);
    }
    
    if (!empty($Institu_ids) && is_array($Institu_ids)) {
        $this->db->where_in('fm.institute_id', $Institu_ids);
    }
    
    $this->db->order_by('fm.feedback_id', 'ASC');
    
    $query = $this->db->get();
    log_message('debug', 'Feedback Filter Query: ' . $this->db->last_query());
    
    return $query->result();
}
}