<?php
  class StudentReg_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
 
      public function insertdata($model)
  {
    return $this->db->insert('student_reg',$model);
      //return $sql->result();
  }
 
      public function getdetailview()
{
    $this->db->select('
        student_reg.*,classmaster.classname');
    $this->db->from('student_reg');
    $this->db->join('classmaster', 'classmaster.class_id = student_reg.fkClass_id', 'left');
    // $this->db->join('department_master', 'department_master.dep_id = student_reg.fkdep_id', 'left');
    // $this->db->join('branch_master', 'branch_master.branch_id = student_reg.fkbranch_id', 'left');
    // $this->db->join('gender_master', 'gender_master.gender_id = student_reg.fkgender_id', 'left');
    // $this->db->join('complaintcat_master', 'complaintcat_master.Comp_id = student_reg.fkComp_id', 'left');
    $this->db->where('student_reg.is_active', '1');
    $this->db->order_by('student_reg.Student_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}


     public function getbyid($id)
{
    $this->db->select('
        student_reg.*
        
    ');
    $this->db->from('student_reg');
    // $this->db->join('institute_master', 'institute_master.Institu_id = faculty_master.fkInstitute', 'left');
    // $this->db->join('department_master', 'department_master.dep_id = faculty_master.fkdep_id', 'left');
    // $this->db->join('branch_master', 'branch_master.branch_id = faculty_master.fkbranch_id', 'left');
    // $this->db->join('gender_master', 'gender_master.gender_id = faculty_master.fkgender_id', 'left');
    // $this->db->join('complaintcat_master', 'complaintcat_master.Comp_id = faculty_master.fkComp_id', 'left');
    $this->db->where('student_reg.Student_id', $id);
    $query = $this->db->get();
    return $query->result();
}

     
      public function get_all_genders()
{
    return $this->db->get('gender_master')->result();
}
 
     
      public function get_all_ReportSubmenu()
{
    return $this->db->get('reportsubmenu')->result();
}

      public function get_all_ReportHeadmenu()
{
    return $this->db->get('reporthead')->result();
}

      public function get_all_Class()
{
    return $this->db->get('classmaster')->result();
}
     public function get_all_Religion()
{
    return $this->db->get('religion_master')->result();
}

     public function get_all_Region()
{
    return $this->db->get('region_master')->result();
}

     public function get_all_CasteCate()
{
    return $this->db->get('castecategory_master')->result();
}

     public function get_all_MotherTong()
{
    return $this->db->get('mothertong')->result();
}

     public function get_all_FamInc()
{
    return $this->db->get('famincome')->result();
}

     public function get_all_State()
{
    return $this->db->get('state_master')->result();
}

     public function get_all_District()
{
    return $this->db->get('district_master')->result();
}

     public function get_all_Taluka()
{
    return $this->db->get('taluka_master')->result();
}

     public function get_all_Village()
{
    return $this->db->get('village_master')->result();
}

     public function get_all_SSC()
{
    return $this->db->get('sscboard_master')->result();
}

     public function get_all_QualifyExam()
{
    return $this->db->get('qualify_master')->result();
}

     public function get_all_HSC()
{
    return $this->db->get('hscboard_master')->result();
}

     public function get_all_Subject()
{
    return $this->db->get('sub_master')->result();
}

     public function get_all_Insitute()
{
    return $this->db->get('institute_master')->result();
}

     public function get_all_Branch()
{
    return $this->db->get('branch_master')->result();
}

     public function get_all_Seat()
{
    return $this->db->get('seat_type')->result();
}

      public function get_all_handicap()
{
    return $this->db->get('handikap_master')->result();
}

      public function get_all_Candi()
{
    return $this->db->get('can_type')->result();
}

      public function get_all_University()
{
    return $this->db->get('university_master')->result();
}

      public function get_all_defence()
{
    return $this->db->get('def_type')->result();
}

      public function get_all_LigMin()
{
    return $this->db->get('lingu_min')->result();
}

      public function get_all_ReliMin()
{
    return $this->db->get('relig_minority')->result();
}

      public function get_all_Country()
{
    return $this->db->get('country_master')->result();
}

public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
 

public function getDataByInstitute($fkInstitName_id, $fkQualifyExam_id, $fkBranchName_id, $fkClass_id, $year_id, $fkGender_id)
{
    $this->db->select('sr.Student_id, sr.FullName, b.branch_name, c.classname, g.gender_name');
    $this->db->from('student_reg sr');
    $this->db->join('branch_master b', 'b.branch_id = sr.fkBranchName_id', 'left');
    $this->db->join('classmaster c', 'c.class_id = sr.fkClass_id', 'left');
    $this->db->join('gender_master g', 'g.gender_id = sr.fkGender_id', 'left'); // ✅ join gender

    if (!empty($fkInstitName_id)) {
        $this->db->where('sr.fkInstitName_id', $fkInstitName_id);
    }
    if (!empty($fkQualifyExam_id)) {
        $this->db->where('sr.fkQualifyExam_id', $fkQualifyExam_id);
    }
    if (!empty($fkBranchName_id)) {
        $this->db->where_in('sr.fkBranchName_id', $fkBranchName_id);
    }
    if (!empty($fkClass_id)) {
        $this->db->where_in('sr.fkClass_id', $fkClass_id);
    }
    if (!empty($year_id)) {
        $this->db->where('sr.Financial_Year', $year_id);
    }
    if (!empty($fkGender_id)) {
        $this->db->where('sr.fkGender_id', $fkGender_id);
    }

    $query = $this->db->get();
    return $query->result();
}

// public function getDataByInstitute($institute_id, $qualify_id = null, $branch_ids = [], $class_ids = [], $year_id = null, $gender_id = null)
// {
//     $this->db->select('
//         student_reg.FullName,
//         branch_master.branch_name,
//         classmaster.classname
//     ');
//     $this->db->from('student_reg');
//     $this->db->join('branch_master', 'branch_master.branch_id = student_reg.fkBranchName_id', 'left');
//     $this->db->join('classmaster', 'classmaster.class_id = student_reg.fkClass_id', 'left');

//     if (!empty($institute_id)) {
//         $this->db->where('student_reg.fkInstitName_id', $institute_id);
//     }

//     if (!empty($qualify_id)) {
//         $this->db->where('student_reg.fkQualifyExam_id', $qualify_id);
//     }

//     if (!empty($branch_ids)) {
//         $this->db->where_in('student_reg.fkBranchName_id', $branch_ids);
//     }

//     if (!empty($class_ids)) {
//         $this->db->where_in('student_reg.fkClass_id', $class_ids);
//     }

//     if (!empty($year_id)) {
//         $this->db->where('student_reg.Financial_Year', $year_id);
//     }

//     if (!empty($gender_id)) {
//         $this->db->where('student_reg.fkGender_id', $gender_id); // 👈 ADD THIS
//     }

//     return $this->db->get()->result();
// }

public function getDataByCategory($institute_id,$branch_ids = [], $country_id = null, $state_ids = [], $district_ids = [], $caste_ids = [], $year_id = null, $out_of_maharashtra = 0)
{
    $this->db->select('
        student_reg.FullName,
        branch_master.branch_name,
        classmaster.classname,
        state_master.stateName,
        district_master.district_name,
        castecategory_master.Category_name
    ');
    $this->db->from('student_reg');
    $this->db->join('branch_master', 'branch_master.branch_id = student_reg.fkBranchName_id', 'left');
    $this->db->join('classmaster', 'classmaster.class_id = student_reg.fkClass_id', 'left');
     $this->db->join('state_master', 'state_master.stateId = student_reg.fkState_id', 'left');
      $this->db->join('district_master', 'district_master.district_id = student_reg.fkDistrict_id', 'left');
    $this->db->join('castecategory_master', 'castecategory_master.Category_id  = student_reg.fkCat_id', 'left');

    if (!empty($institute_id)) {
        $this->db->where('student_reg.fkInstitName_id', $institute_id);
    }

    
    if (!empty($branch_ids)) {
        $this->db->where_in('student_reg.fkBranchName_id', $branch_ids);
    }


    if (!empty($country_id)) {
        $this->db->where('student_reg.fkcountryId', $country_id);
    }

    // Out of Maharashtra filter
    if ($out_of_maharashtra == 1) {
    $this->db->where('student_reg.fkState_id !=', 1); // 1 means Maharashtra, exclude it

    } else {
        if (!empty($state_ids)) {
            $this->db->where_in('student_reg.fkState_id', $state_ids);
        }
    }

    if (!empty($district_ids)) {
        $this->db->where_in('student_reg.fkDistrict_id', $district_ids);
    }

    if (!empty($caste_ids)) {
        $this->db->where_in('student_reg.fkCat_id', $caste_ids);
    }

    if (!empty($year_id)) {
        $this->db->where('student_reg.Financial_Year', $year_id);
    }

    return $this->db->get()->result();
}

 
// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

  public function check_mobile_exists($mobileNo)
{
    $this->db->where('Mobile', $mobileNo);
    $query = $this->db->get('student_reg'); // Replace with your actual table name

    return $query->num_rows() > 0;
}

 public function get_submenus_by_head($fkReportHead_id)
{
    $this->db->where('fkReportHead_id', $fkReportHead_id);
    return $this->db->get('reportsubmenu')->result();
}


    public function update($model)
    {
       return $sql = $this->db->where('Student_id',$model['Student_id'])->update('student_reg',$model);
    }
 
 


    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("student_reg")
        ->join("finiyear_master", "finiyear_master.finiYear_id = student_reg.Financial_Year")
        ->group_by("student_reg.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId)
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("student_reg")
        ->join("finiyear_master", "finiyear_master.finiYear_id = student_reg.Financial_Year")
        ->where("student_reg.Financial_Year", $yearId)
        ->group_by("student_reg.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getYearwiseTypes($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("student_reg.AppliID, student_reg.FullName, finiyear_master.fini_Label as year")
        ->from("student_reg")
        ->join("finiyear_master", "finiyear_master.finiYear_id = student_reg.Financial_Year");

    // ✅ Filter by year
    if (!empty($yearId)) {
        if (is_array($yearId)) {
            $this->db->where_in("student_reg.Financial_Year", $yearId);
        } else {
            $this->db->where("student_reg.Financial_Year", $yearId);
        }
    }

    // ✅ Filter by institute
    if (!empty($institu)) {
        $this->db->where("student_reg.fkInstitName_id", $institu);
    }

    // ✅ Filter by branch
    if (!empty($branches)) {
        if (is_array($branches)) {
            $this->db->where_in("student_reg.fkBranchName_id", $branches);
        } else {
            $this->db->where("student_reg.fkBranchName_id", $branches);
        }
    }

    // ✅ Filter by date range
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("student_reg.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    // ✅ Return the result as an array
    return $this->db->get()->result_array();
}



   public function getStudentsByInstitute($filters = [])
{
    $this->db->select('sr.Student_id, sr.FullName, b.branch_name, c.classname, g.gender_name');
    $this->db->from('student_reg sr');

    // ✅ Join related tables
    $this->db->join('branch_master b', 'b.branch_id = sr.fkBranchName_id', 'left');
    $this->db->join('class_master c', 'c.class_id = sr.fkClass_id', 'left'); // <-- make sure table exists
    $this->db->join('gender_master g', 'g.gender_id = sr.fkGender_id', 'left');

    // ✅ Apply filters if provided
    if (!empty($filters['fkInstitName_id'])) {
        $this->db->where('sr.fkInstitName_id', $filters['fkInstitName_id']);
    }
    if (!empty($filters['fkQualifyExam_id'])) {
        $this->db->where('sr.fkQualifyExam_id', $filters['fkQualifyExam_id']);
    }
    if (!empty($filters['fkBranchName_id']) && is_array($filters['fkBranchName_id'])) {
        $this->db->where_in('sr.fkBranchName_id', $filters['fkBranchName_id']);
    }
    if (!empty($filters['fkClass_id']) && is_array($filters['fkClass_id'])) {
        $this->db->where_in('sr.fkClass_id', $filters['fkClass_id']);
    }
    if (!empty($filters['year'])) {
        $this->db->where('sr.Financial_Year', $filters['year']);
    }
    if (!empty($filters['fkGender_id'])) {
        $this->db->where('sr.fkGender_id', $filters['fkGender_id']);
    }

    // ✅ Order by name
    $this->db->order_by('sr.FullName', 'ASC');

    $query = $this->db->get();
    return $query->result();
}



// Add these methods to your VAPReport_model class


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }
  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(student_reg.Student_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('student_reg', 'branch_master.branch_id = student_reg.fkBranchName_id', 'left');

    if (!empty($institu)) {
        $this->db->where('student_reg.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
   if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('student_reg.Financial_Year', $year);
    } else {
        $this->db->where('student_reg.Financial_Year', $year);
    }
}

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("student_reg.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');

    return $this->db->get()->result();
}

public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('student_reg.FullName,
                       student_reg.Student_id,
                       student_reg.AppliID,
                       student_reg.fkBranchName_id,
                       branch_master.branch_name');
    $this->db->from('student_reg');
    $this->db->join('branch_master', 'branch_master.branch_id = student_reg.fkBranchName_id', 'left');

    if (!empty($branch_id)) {
        if (is_array($branch_id)) {
            $this->db->where_in('student_reg.fkBranchName_id', $branch_id);
        } else {
            $this->db->where('student_reg.fkBranchName_id', $branch_id);
        }
    }

    if (!empty($institu)) {
        $this->db->where('student_reg.fkInstitName_id', $institu);
    }

if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('student_reg.Financial_Year', $year);
    } else {
        $this->db->where('student_reg.Financial_Year', $year);
    }
}
 

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("student_reg.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    return $this->db->get()->result();
}


 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.Student_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('student_reg sr', 'b.branch_id = sr.fkBranchName_id', 'left');

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
if (!empty($years)) {
    $years = is_array($years) ? $years : [$years];
    $this->db->where_in('sr.Financial_Year', $years);
}

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();

    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Student_id) as count");
    $this->db->from("student_reg sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.Financial_Year");

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkBranchName_id', (array)$branches);
    }
   if (!empty($years)) {
    $years = is_array($years) ? $years : [$years];
    $this->db->where_in('sr.Financial_Year', $years);
}

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}
  public function get_submenu_by_menu_id($fkMenuID)
    {
        $this->db->select('submenu_master.SubID, submenu_master.Name, submenu_master.SubName, submenu_master.fkMenuID, submenu_master.fkFormTypeID, submenu_master.ArrangeNO, submenu_master.URL,submenu_master.is_active, submenu_master.is_on,menu_master.MenuMainHead,menu_master.MenuSubHead,menu_master.MenuReport');
         $this->db->join('menu_master', 'menu_master.MenuID = submenu_master. fkMenuID');
         
          $this->db->join('useraccess_master', 'useraccess_master.fkSubMenu_Id = submenu_master. SubID');
         $this->db->where('useraccess_master.fkUserID', $this->session->userdata('userID'));
        $this->db->from('submenu_master');
        $this->db->where('submenu_master.fkMenuID', $fkMenuID);
        $this->db->where('submenu_master.is_on', 1);
        $this->db->order_by('ArrangeNO', 'ASC');
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->result_array();
        }
        
        return [];
    }

}