<?php
  class Studentpub_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('student_publication',$model);
			//return $sql->result();
	} 


    //  public function getbranch()
    //  {
    //   $this->db->select('branch_master.*,');
    //   $this->db->from('branch_master');
    //    $query = $this->db->get();
    //     return $query->result();
    //  }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getpubli()
     {
      $this->db->select('student_publishtype.*,');
      $this->db->from('student_publishtype');
       $query = $this->db->get();
        return $query->result();
     }


     public function getdoc()
     {
      $this->db->select('publish_document.*,');
      $this->db->from('publish_document');
       $query = $this->db->get();
        return $query->result();
     }

    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getmainuser()
     {
      $this->db->select('mainuser_master.*,');
      $this->db->from('mainuser_master');
       $query = $this->db->get();
        return $query->result();
     }



public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $s_ids = [], $doc_ids = [], $startdate = null, $enddate = null,)
{
    $this->db->select('
        student_publication.*, 
        branch_master.branch_name, 
student_publishtype.stud_publishName,
student_reg.FullName,');

    $this->db->from('student_publication');
    $this->db->join('branch_master', 'branch_master.branch_id = student_publication.fk_branch', 'left');
        // $this->db->join('student_pubsecond', 'student_publication.stu_Id = student_pubsecond.fk_stuId_facid', 'left');
// $this->db->join('publish_document', 'publish_document.doc_id = student_pubsecond.fk_document', 'left');
   $this->db->join('student_publishtype', 'student_publishtype.s_id = student_publication.fk_pubtype', 'left');
      $this->db->join('student_reg', 'student_reg.Student_id = student_publication.fk_student', 'left');



    $this->db->where('student_publication.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('student_publication.fk_branch', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

if (!empty($s_ids)) {
    $this->db->where_in('student_publication.fk_pubtype', $s_ids);
}

    
    if (!empty($year_id)) {
    $this->db->where('student_publication.Financial_Year', $year_id);
}

 if (!empty($doc_ids)) {
    $this->db->where_in('student_pubsecond.fk_document', $doc_ids);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('student_publication.pub_date >=', $startdate);
        $this->db->where('student_publication.pub_date <=', $enddate);
    }

     

        $this->db->order_by('student_publication.pub_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}




// chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("student_publication")
        ->join("finiyear_master", "finiyear_master.finiYear_id = student_publication.Financial_Year")
        ->group_by("student_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("student_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = student_publication.Financial_Year")
//         ->where("student_publication.Financial_Year", $yearId)
//         ->group_by("student_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("student_publication.stu_Id, student_publication.applicant_name, finiyear_master.fini_Label as year")
//         ->from("student_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = student_publication.Financial_Year")
//         ->where("student_publication.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 
public function getSingleYearData($yearId, $branches = [], $usertype = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("student_publication")
        ->join("finiyear_master", "finiyear_master.finiYear_id = student_publication.Financial_Year")
        ->where("student_publication.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('student_publication.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('student_publication.fk_branch', explode(',', $branchIds));
    }
}
  
   if (!empty($usertype)) {
    if (is_array($usertype)) {
        $this->db->where_in('student_publication.fk_usertype', $usertype);
    } else {
        $this->db->where('student_publication.fk_usertype', $usertype);
    }
}
 
    // $this->db->group_by("student_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 $this->db->group_by("student_publication.Financial_Year, finiyear_master.fini_Label, finiyear_master.finiYear_id");

    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [], $usertype = null)
{
    $this->db->select("student_publication.stu_Id, student_publication.applicant_name, student_publication.fk_pubtype, finiyear_master.fini_Label as year,
    student_publishtype.stud_publishName")
        ->from("student_publication")
        ->join("finiyear_master", "finiyear_master.finiYear_id = student_publication.Financial_Year")
        ->join('student_publishtype', 'student_publishtype.s_id = student_publication.fk_pubtype', 'left')
        ->where("student_publication.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('student_publication.fk_branch', (array)$branches);
    }

    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('student_publication.fk_branch', explode(',', $branchIds));
    }
}
    
 if (!empty($usertype)) {
    if (is_array($usertype)) {
        $this->db->where_in('student_publication.fk_usertype', $usertype);
    } else {
        $this->db->where('student_publication.fk_usertype', $usertype);
    }
}

    return $this->db->get()->result_array();
}
 

     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }
  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $usertype = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(student_publication.stu_Id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('student_publication', 'branch_master.branch_id = student_publication.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('student_publication.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

     if (!empty($usertype)) {
    if (is_array($usertype)) {
        $this->db->where_in('student_publication.fk_usertype', $usertype);
    } else {
        $this->db->where('student_publication.fk_usertype', $usertype);
    }
}


    if (!empty($year) && $year != 0) {
        $this->db->where('student_publication.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null, $usertype = null)
{
    $this->db->select('student_publication.applicant_name,
                       student_publication.stu_Id,
                       student_publication.fk_branch,
                       student_publication.fk_pubtype,
                       branch_master.branch_name,
                       student_publishtype.stud_publishName');
    $this->db->from('student_publication');
    $this->db->join('branch_master', 'branch_master.branch_id = student_publication.fk_branch', 'left');
    $this->db->join('student_publishtype', 'student_publishtype.s_id = student_publication.fk_pubtype', 'left');
$this->db->join('mainuser_master ut', 'ut.mainuser_id = student_publication.fk_usertype', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('student_publication.fk_branch', $branch_id);
} else {
    $this->db->where('student_publication.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('student_publication.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('student_publication.Financial_Year', $year);
    // }

    if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('student_publication.Financial_Year', $year);
    } else {
        $this->db->where('student_publication.Financial_Year', $year);
    }
}


    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("student_publication.created_at BETWEEN '$startDate' AND '$endDate'");
    }

     if (!empty($usertype)) {
    if (is_array($usertype)) {
        $this->db->where_in('student_publication.fk_usertype', $usertype);
    } else {
        $this->db->where('student_publication.fk_usertype', $usertype);
    }
}
 
    return $this->db->get()->result();
}




 
//  public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null, $usertype = null)
// {
//     $response = [];
 
//     // --- 1. Branchwise Count ---
//     $this->db->select('b.branch_id, b.branch_name, COUNT(sp.stu_Id) as student_count');
//     $this->db->from('branch_master b');
//     $this->db->join('student_publication sp', 'b.branch_id = sp.fk_branch', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('b.branch_id', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.Financial_Year', (array)$years);
//     }

//    if (!empty($usertype)) {
//     if (is_array($usertype)) {
//         $this->db->where_in('sp.fk_usertype', $usertype);
//     } else {
//         $this->db->where('sp.fk_usertype', $usertype);
//     }
// }

   
//     $this->db->group_by('b.branch_id, b.branch_name');
//     $this->db->order_by('b.branch_name', 'ASC');
//     $response['branchData'] = $this->db->get()->result();
 
//     // --- 2. Yearwise Count ---
//     $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.stu_Id) as count");
//     $this->db->from("student_publication sp");
//     $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('sp.fk_branch', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.Financial_Year', (array)$years);
//     }

//    if (!empty($usertype)) {
//     if (is_array($usertype)) {
//         $this->db->where_in('sp.fk_usertype', $usertype);
//     } else {
//         $this->db->where('sp.fk_usertype', $usertype);
//     }
// }



   
//     $this->db->group_by("fy.finiYear_id, fy.fini_Label");
//     $this->db->order_by("fy.finiYear_id", "ASC");
//     $response['yearData'] = $this->db->get()->result();
 
    
//     return $response;
// }
 
 
public function getCombinedData($institu = null, $branches = [], $years = [], $usertype = null)
{
    $response = [];

    // --- Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.stu_Id) as student_count');
    $this->db->from('student_publication sp'); // start from sp first
    $this->db->join('branch_master b', 'b.branch_id = sp.fk_branch', 'inner'); // inner join ensures only matched rows

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', $branches);
    }
else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', $years);
    }
    if (!empty($usertype)) {
        if (is_array($usertype)) {
            $this->db->where_in('sp.fk_usertype', $usertype);
        } else {
            $this->db->where('sp.fk_usertype', $usertype);
        }
    }

    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();

    // --- Yearwise Count ---
    $this->db->select('fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.stu_Id) as count');
    $this->db->from('student_publication sp'); // start from sp
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = sp.Financial_Year', 'inner');

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', $branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', $years);
    }
    if (!empty($usertype)) {
        if (is_array($usertype)) {
            $this->db->where_in('sp.fk_usertype', $usertype);
        } else {
            $this->db->where('sp.fk_usertype', $usertype);
        }
    }

    $this->db->group_by('fy.finiYear_id, fy.fini_Label');
    $this->db->order_by('fy.finiYear_id', 'ASC');
    $response['yearData'] = $this->db->get()->result();

    return $response;
}


}