<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Survey_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
  
    public function insertdata($model)
    {
        return $this->db->insert('feedback_detail', $model);
    } 

    // Get active headings with their subheadings
    public function get_survey_structure() {
        // Get all active headings
        $this->db->select('heading_id, heading_text');
        $this->db->from('feedbackheading');
        $this->db->where('is_active', 1);
        $this->db->where('is_on', 1);
        $this->db->order_by('heading_id', 'ASC');
        $headings = $this->db->get()->result_array();
        
        // For each heading, get its subheadings
        foreach ($headings as &$heading) {
            $this->db->select('subheading_id, subheading_text');
            $this->db->from('feedbacksubheading');
            $this->db->where('heading_id', $heading['heading_id']);
            $this->db->where('is_active', 1);
            $this->db->where('is_on', 1);
            $this->db->order_by('subheading_id', 'ASC');
            $heading['subheadings'] = $this->db->get()->result_array();
        }
        
        return $headings;
    }
    
    // Get active options
    public function get_options() {
        $this->db->select('option_id, option_text');
        $this->db->from('feedbackoption');
        $this->db->where('is_on', 1);
        $this->db->where('is_active', 1);
        $this->db->order_by('option_id', 'ASC'); // Excellent (5) first
        return $this->db->get()->result();
    }
    
    // Get all branches from branch_master table
    public function get_branches() {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // $this->db->order_by('branch_name', 'ASC');
        return $this->db->get()->result();
    }
    
    // Get heading icon based on heading text
    public function get_heading_icon($heading_text) {
        // Map heading names to icons
        $icons = [
            'Warden and Other Staff Members' => '👥',
            'Hostel Facilities(Cleanliness)' => '🧹',
            'Cleanliness' => '🧹',
            'Mess Facilities' => '🍽️',
            'Food and Water' => '🥘',
            'Medical Facilities' => '⚕️',
            'Medical' => '⚕️',
            'Hostel Facilities' => '🏋️',
            'Other Facilities' => '🏋️'
        ];
        
        // Return icon if found, else default
        return isset($icons[$heading_text]) ? $icons[$heading_text] : '📋';
    }

    // Get option emoji based on option text
    public function get_option_emoji($option_text) {
        // Map option names to emojis
        $emoji_map = [
            'Excellent' => '⭐',
            'V.Good' => '😊',
            'Very Good' => '😊',
            'Good' => '👍',
            'Average' => '😐',
            'Poor' => '👎'
        ];
        
        return isset($emoji_map[$option_text]) ? $emoji_map[$option_text] : '📝';
    }
    
    // Check if student has already submitted feedback for current financial year
    public function check_submission_exists($prn_number) {
        // Get current financial year
        $this->db->select('finiYear_id');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        $financial_year = $this->db->get()->row();
        
        if (!$financial_year) {
            return false;
        }
        
        // Check in feedback_main table
        $this->db->select('COUNT(*) as count');
        $this->db->from('feedback_main');
        $this->db->where('prnno', $prn_number);
        $this->db->where('financial_year_id', $financial_year->finiYear_id);
        $result = $this->db->get()->row();
        
        return $result->count > 0;
    }
    
    // Get survey results for a specific student
    public function get_student_feedback($prn_number, $financial_year_id = null) {
        $this->db->select('fm.*, fd.*, fh.heading_text, fs.subheading_text, fo.option_text, b.branch_name');
        $this->db->from('feedback_main fm');
        $this->db->join('feedback_detail fd', 'fm.feedback_id = fd.feedback_id');
        $this->db->join('feedbackheading fh', 'fd.heading_id = fh.heading_id');
        $this->db->join('feedbacksubheading fs', 'fd.subheading_id = fs.subheading_id');
        $this->db->join('feedbackoption fo', 'fd.option_id = fo.option_id');
        $this->db->join('branch_master b', 'fm.branchId = b.branch_id', 'left');
        $this->db->where('fm.prnno', $prn_number);
        
        if ($financial_year_id) {
            $this->db->where('fm.financial_year_id', $financial_year_id);
        }
        
        $this->db->order_by('fh.heading_id', 'ASC');
        $this->db->order_by('fs.subheading_id', 'ASC');
        
        return $this->db->get()->result();
    }
    
    // Get all feedback results for reporting
    public function get_all_feedback($financial_year_id = null, $branch_id = null) {
        $this->db->select('fm.*, fd.*, fh.heading_text, fs.subheading_text, fo.option_text, b.branch_name');
        $this->db->from('feedback_main fm');
        $this->db->join('feedback_detail fd', 'fm.feedback_id = fd.feedback_id');
        $this->db->join('feedbackheading fh', 'fd.heading_id = fh.heading_id');
        $this->db->join('feedbacksubheading fs', 'fd.subheading_id = fs.subheading_id');
        $this->db->join('feedbackoption fo', 'fd.option_id = fo.option_id');
        $this->db->join('branch_master b', 'fm.branchId = b.branch_id', 'left');
        
        if ($financial_year_id) {
            $this->db->where('fm.financial_year_id', $financial_year_id);
        }
        
        if ($branch_id) {
            $this->db->where('fm.branchId', $branch_id);
        }
        
        $this->db->order_by('fm.feedback_id', 'DESC');
        $this->db->order_by('fh.heading_id', 'ASC');
        $this->db->order_by('fs.subheading_id', 'ASC');
        
        return $this->db->get()->result();
    }
    
    // Get feedback statistics
    public function get_feedback_statistics($financial_year_id = null, $branch_id = null) {
        $this->db->select('
            fh.heading_text,
            fs.subheading_text,
            fo.option_text,
            fo.option_id,
            COUNT(*) as response_count
        ');
        $this->db->from('feedback_main fm');
        $this->db->join('feedback_detail fd', 'fm.feedback_id = fd.feedback_id');
        $this->db->join('feedbackheading fh', 'fd.heading_id = fh.heading_id');
        $this->db->join('feedbacksubheading fs', 'fd.subheading_id = fs.subheading_id');
        $this->db->join('feedbackoption fo', 'fd.option_id = fo.option_id');
        
        if ($financial_year_id) {
            $this->db->where('fm.financial_year_id', $financial_year_id);
        }
        
        if ($branch_id) {
            $this->db->where('fm.branchId', $branch_id);
        }
        
        $this->db->group_by('fd.heading_id, fd.subheading_id, fd.option_id');
        $this->db->order_by('fh.heading_id', 'ASC');
        $this->db->order_by('fs.subheading_id', 'ASC');
        $this->db->order_by('fo.option_id', 'DESC');
        
        return $this->db->get()->result();
    }
  
    public function getbyid($id)
    {
        $this->db->select('gst_master.*');
        $this->db->where('gstId', $id);
        $query = $this->db->get('gst_master');
        return $query->result();
    }
  
    public function update($model)
    {
        return $this->db->where('gstId', $model['gstId'])->update('gst_master', $model); 
    }
    
    // public function getdetailGST()
    // {
    //     $this->db->select('*');
    //     $this->db->from('gst_master');
    //     $query = $this->db->get();
    //     return $query->result();
    // }
}