<?php
  class Tech_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('tech_event_student',$model);
			//return $sql->result();
	} 

  public function getevent()
     {
      $this->db->select('event_master.*');
      $this->db->from('event_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getparti()
     {
      $this->db->select('participate_master.*,');
      $this->db->from('participate_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('Institute');
    $this->db->from('tech_event_student');
    $this->db->group_by('Institute');
    $this->db->order_by('Institute', 'ASC'); // optional sorting
    return $this->db->get()->result();
     }

         public function getlevel()
     {
      $this->db->select('level_master.*,');
      $this->db->from('level_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getclass()
     {
      $this->db->select('classmaster.*,');
      $this->db->from('classmaster');
       $query = $this->db->get();
        return $query->result();
     }

public function getrank()
     {
      $this->db->select('rank_master.*,');
      $this->db->from('rank_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function gettype()
     {
      $this->db->select('type_master.*,');
      $this->db->from('type_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getproff()
     {
      $this->db->select('professional_body.*,');
      $this->db->from('professional_body');
       $query = $this->db->get();
        return $query->result();
     }

     public function geteventnames()
{
    $this->db->select('eventName');
    $this->db->from('tech_event_student');
    $this->db->group_by('eventName');
    $this->db->order_by('eventName', 'ASC'); // optional sorting
    return $this->db->get()->result();
}

    public function getDataByInstitute($year_id, $institute_ids = [], $branch_ids = [], $class_ids = [], $level_ids = [], $event_types = [], $participate_types = [], 
    $rank_name = [], $type_name = [], $prof_bodyName = [],) {
        $this->db->select('
            tech_event_student.*, 
            level_master.leval_name,
            event_master.event_type,
            rank_master.rank_name,
             student_reg.FullName,
             tech_event_student.amount,
              branch_master.branch_name,
        ');
        $this->db->from('tech_event_student');
          $this->db->join('technical_event', 'technical_event.tech_id = tech_event_student.fk_tech_id', 'left');
        $this->db->join('branch_master', 'branch_master.branch_id = technical_event.fk_branch', 'left');
        $this->db->join('level_master', 'level_master.level_id = tech_event_student.fk_leval', 'left');
        // $this->db->join('participate_master', 'participate_master.parti_id = tech_event_student.fk_particiType', 'left');
        $this->db->join('event_master', 'event_master.event_id = tech_event_student.fk_eventtype', 'left');
        $this->db->join('student_reg', 'student_reg.Student_id = tech_event_student.fk_student', 'left');
        $this->db->join('rank_master', 'rank_master.rank_id = tech_event_student.fk_rank', 'left');
        //  $this->db->join('type_master', 'type_master.type_id = tech_event_student.fk_type', 'left');
        // $this->db->join('professional_body', 'tech_event_student.fk_pofessional = professional_body.prof_id', 'left');

        $this->db->order_by('tech_event_student.ID','DESC');
        // $this->db->where('tech_event_student.Institute', $institute_id);
 if (!empty($institute_ids)) {
            $this->db->where_in('tech_event_student.Institute', $institute_ids);
        }

        if (!empty($year_id)) {
            $this->db->where('tech_event_student.Financial_Year', $year_id);
        }

        if (!empty($branch_ids)) {
            $this->db->where_in('technical_event.fk_branch', $branch_ids);
        }
        // new code
    // else{
    //     $branchIds = $this->session->userdata('fkBranch_Id');

    //     if (!is_array($branchIds)) {
    //         $branchIds = explode(',', $branchIds);
    //     }

    //     $this->db->where_in('branch_master.branch_id', $branchIds);
    
    // }
// new code end

        if (!empty($class_ids)) {
            $this->db->where_in('tech_event_student.fk_class', $class_ids);
        }

        if (!empty($level_ids)) {
            $this->db->where_in('tech_event_student.fk_leval', $level_ids);
        }

        if (!empty($event_types)) {
            $this->db->where_in('tech_event_student.fk_eventtype', $event_types);
        }

        if (!empty($participate_types)) {
            $this->db->where_in('tech_event_student.fk_particiType', $participate_types);
        }

          if (!empty($rank_name)) {
            $this->db->where_in('tech_event_student.fk_rank', $rank_name);
        } 
        

        if (!empty($type_name)) {
            $this->db->where_in('tech_event_student.fk_type', $type_name);
        }

         if (!empty($prof_bodyName)) {
            $this->db->where_in('tech_event_student.fk_pofessional', $prof_bodyName);
        }

        return $this->db->get()->result();
    }


// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

      // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("tech_event_student")
        ->join("finiyear_master", "finiyear_master.finiYear_id = tech_event_student.Financial_Year")
        ->group_by("tech_event_student.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("tech_event_student")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = tech_event_student.Financial_Year")
//         ->where("tech_event_student.Financial_Year", $yearId)
//         ->group_by("tech_event_student.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("tech_event_student.ID, tech_event_student.fk_student, finiyear_master.fini_Label as year, student_reg.FullName,")
//         ->from("tech_event_student")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = tech_event_student.Financial_Year")
//         ->join('student_reg', 'student_reg.Student_id = tech_event_student.fk_student')
//         ->where("tech_event_student.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 

public function getSingleYearData($yearId, $events = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("tech_event_student")
        ->join("finiyear_master", "finiyear_master.finiYear_id = tech_event_student.Financial_Year")
        ->where("tech_event_student.Financial_Year", $yearId);
 
    
    if (!empty($events)) {
        $this->db->where_in('tech_event_student.eventName', (array)$events);
    }
  
 
    $this->db->group_by("tech_event_student.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $events = [],)
{
    $this->db->select("tech_event_student.ID, tech_event_student.fk_student, finiyear_master.fini_Label as year,student_reg.FullName,")
        ->from("tech_event_student")
        ->join("finiyear_master", "finiyear_master.finiYear_id = tech_event_student.Financial_Year")
                ->join('student_reg', 'student_reg.Student_id = tech_event_student.fk_student')
        ->where("tech_event_student.Financial_Year", $yearId);
 
    
    if (!empty($events)) {
        $this->db->where_in('tech_event_student.eventName', (array)$events);
    }
    
 
    return $this->db->get()->result_array();
}
 

public function getCombinedData($institu = null, $events = [], $years = [])
{
    $response = [];

    // --- 1. Eventwise Count ---
    $this->db->select('sp.eventName, COUNT(sp.ID) as student_count');
    $this->db->from('tech_event_student sp');

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($events)) {
        $this->db->where_in('sp.eventName', (array)$events);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }

    $this->db->group_by('sp.eventName');
    $this->db->order_by('sp.eventName', 'ASC');
    $response['eventData'] = $this->db->get()->result();

    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.ID) as count");
    $this->db->from("tech_event_student sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($events)) {
        $this->db->where_in('sp.eventName', (array)$events);
    }
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}

public function getEventDetailsData($eventName, $institu = null, $year = null)
{
    $this->db->select('sp.fk_student, sp.ID, sp.eventName, student_reg.FullName');
    $this->db->from('tech_event_student sp');
    $this->db->join('student_reg', 'student_reg.Student_id = sp.fk_student', 'left');

    $this->db->where('sp.eventName', $eventName);

    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('sp.Financial_Year', $year);
    // }


  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('sp.Financial_Year', $year);
    } else {
        $this->db->where('sp.Financial_Year', $year);
    }
}

    return $this->db->get()->result();
}

}