<?php
  class Technical_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		 $this->db->insert('technical_event',$model);
			return $this->db->insert_id();
	} 

     public function insertseconddata($model)
	{
		 $this->db->insert('tech_event_student',$model);
			return $this->db->insert_id();
	} 


     public function getdetailview()
{      
    $this->db->select('technical_event.*,
                       type_master.type_name,
                       classmaster.classname,
                       branch_master.branch_name,
                       level_master.leval_name,
                       participate_master.participate_type,
                       event_master.event_type,
                       professional_body.prof_bodyName,
                       fac1.fac_Fullname as facultyhod,
                       fac2.fac_Fullname as facultyName,
                       semester_master.Sem_Name');
    $this->db->from('technical_event');
    $this->db->join('classmaster', 'technical_event.fk_class = classmaster.class_id', 'left');
    $this->db->join('branch_master', 'technical_event.fk_branch = branch_master.branch_id', 'left');
    $this->db->join('level_master', 'technical_event.fk_leval = level_master.level_id', 'left');
    $this->db->join('type_master', 'technical_event.fk_type = type_master.type_id', 'left');
    $this->db->join('participate_master', 'technical_event.fk_particiType = participate_master.parti_id', 'left');
    $this->db->join('professional_body', 'technical_event.fk_pofessional = professional_body.prof_id', 'left');
    $this->db->join('faculty_master as fac1', 'technical_event.fk_hod = fac1.fac_id', 'left');
    $this->db->join('faculty_master as fac2', 'technical_event.fk_faculty = fac2.fac_id', 'left');
    $this->db->join('event_master', 'technical_event.fk_eventtype = event_master.event_id', 'left');
    $this->db->join('semester_master', 'technical_event.fk_sem = semester_master.SemID', 'left');
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    
    $this->db->group_by('technical_event.tech_id');
    $this->db->order_by('technical_event.tech_id','DESC');
    $query = $this->db->get();
    return $query->result();
}
     
//   public function getRegisteredBranches()
// {
//     return $this->db->select('branch_master.branch_id, branch_master.branch_name')
//                     ->from('student_reg')
//                     ->join('branch_master', 'branch_master.branch_id = student_reg.fkBranchName_id')
//                     ->group_by('branch_master.branch_id')
//                     ->get()
//                     ->result();
// }
 
  public function getRegisteredBranches()
{
    $this->db->select('branch_master.branch_id, branch_master.branch_name');
    $this->db->from('branch_master');
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    return $this->db->get()->result();
}

 
// public function getClassesByBranch($branch_id)
// {
//     return $this->db->select('classmaster.class_id, classmaster.classname AS class_name') // important!
//                     ->from('student_reg')
//                     ->join('classmaster', 'classmaster.class_id = student_reg.fkClass_id')
//                     ->where('student_reg.fkBranchName_id', $branch_id)
//                     ->group_by('classmaster.class_id')
//                     ->get()
//                     ->result();
// }
 
 
// public function getStudentsByBranchAndClass($branch_id, $class_id)
// {
//     return $this->db->select('student_id, FullName')
//                     ->from('student_reg')
//                     ->where('fkBranchName_id', $branch_id)
//                     ->where('fkClass_id', $class_id)
//                     ->get()
//                     ->result();
// }
 

 public function getstudent()
     {
      $this->db->select('student_reg.*,');
      $this->db->from('student_reg');
       $query = $this->db->get();
        return $query->result();
     }


   //   public function getclass()
   //   {
   //    $this->db->select('classmaster.*,');
   //    $this->db->from('classmaster');
   //     $query = $this->db->get();
   //      return $query->result();
   //   }

public function getevent()
     {
      $this->db->select('event_master.*,');
      $this->db->from('event_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getparti()
     {
      $this->db->select('participate_master.*,');
      $this->db->from('participate_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function gettype()
     {
      $this->db->select('type_master.*,');
      $this->db->from('type_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function getlevel()
     {
      $this->db->select('level_master.*,');
      $this->db->from('level_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getrank()
     {
      $this->db->select('rank_master.*,');
      $this->db->from('rank_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function getproff()
     {
      $this->db->select('professional_body.*,');
      $this->db->from('professional_body');
       $query = $this->db->get();
        return $query->result();
     }

     
     public function getfac()
     {
      $this->db->select('faculty_master.*,');
      $this->db->from('faculty_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getsem()
     {
      $this->db->select('semester_master.SemID,semester_master.Sem_Name');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getbyid($id)
		{
		  $this->db->select("technical_event.*,");
	    $this->db->where('tech_id',$id);
      $query = $this->db->get('technical_event');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('tech_id',$model['tech_id'])->update('technical_event',$model); 
    } 



public function getbyItemid($itemid)
    {
    $this->db->select('tech_event_student.*,student_reg.FullName,rank_master.rank_name,event_master.event_type,level_master.leval_name,');
    $this->db->from('tech_event_student');
    $this->db->join('student_reg', 'tech_event_student.fk_student	= student_reg.student_id', 'left');
       $this->db->join('rank_master', 'tech_event_student.fk_rank	= rank_master.rank_id', 'left');
               $this->db->join('event_master', 'tech_event_student.fk_eventtype = event_master.event_id', 'left');
    $this->db->join('level_master', 'tech_event_student.fk_leval	= level_master.level_id', 'left');
    $this->db->where('tech_event_student.fk_tech_id',$itemid);
    $this->db->where('tech_event_student.is_active', 1); 
    $query = $this->db->get();
    return $query->result();
    }

  
public function updatesecond($model) {
return $this->db->where('fk_tech_id', $model['fk_tech_id'])
                ->where('ID', $model['ID']) 
                ->update('tech_event_student', $model); 
}



}