<?php
  class TotalPlace_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('placement_master',$model);
			//return $sql->result();
	} 

  public function getcompany()
     {
      $this->db->select('company_master.*,');
      $this->db->from('company_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      // new code
      $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
    // new code end
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

     public function gettype()
     {
      $this->db->select('company_type.*,');
      $this->db->from('company_type');
       $query = $this->db->get();
        return $query->result();
     }

     public function getcat()
     {
      $this->db->select('company_category.*,');
      $this->db->from('company_category');
       $query = $this->db->get();
        return $query->result();
     }


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getclass()
     {
      $this->db->select('classmaster.*,');
      $this->db->from('classmaster');
       $query = $this->db->get();
        return $query->result();
     }

      public function getsalary()
     {
      $this->db->select('salary_master.*,');
      $this->db->from('salary_master');
       $query = $this->db->get();
        return $query->result();
     }

public function getplace()
     {
      $this->db->select('placement_type.*,');
      $this->db->from('placement_type');
       $query = $this->db->get();
        return $query->result();
     }

     public function getdiv()
     {
      $this->db->select('division_master.*,');
      $this->db->from('division_master');
       $query = $this->db->get();
        return $query->result();
     }


// public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $class_ids = [], $company_types = [], $company_categories = [], $company_ids = [],)
// {
//     $this->db->select('
//         placement_master.*, 
//         student_reg.FullName, 
//         branch_master.branch_name, 
//         classmaster.classname, 
//         company_master.comp_name,
//         designation_master.desig_name,
//         company_category.category_name,
//         company_type.Comp_type
//     ');
//     $this->db->from('placement_master');
//     $this->db->join('student_reg', 'student_reg.Student_id = placement_master.fk_student');
//     $this->db->join('branch_master', 'branch_master.branch_id = placement_master.fk_branch', 'left');
//     $this->db->join('classmaster', 'classmaster.class_id = placement_master.fk_class', 'left');
//     $this->db->join('company_master', 'company_master.ID = placement_master.fk_company', 'left');
//     $this->db->join('designation_master', 'placement_master.fk_desig = designation_master.desig_id', 'left');
//         $this->db->join('company_category', 'company_master.fk_comp_cat = company_category.compCat_id', 'left');
//     $this->db->join('company_type', 'company_master.fk_comptype = company_type.Company_id', 'left');


//     $this->db->where('placement_master.Institute', $institute_id);

//     if (!empty($branch_ids)) {
//         $this->db->where_in('placement_master.fk_branch', $branch_ids);
//     }

//     if (!empty($class_ids)) {
//         $this->db->where_in('placement_master.fk_class', $class_ids);
//     }

//    if (!empty($company_types)) {
//     $this->db->where_in('company_master.fk_comptype', $company_types);
// }

// if (!empty($company_categories)) {
//     $this->db->where_in('company_master.fk_comp_cat', $company_categories);
// }


//     if (!empty($company_ids)) {
//         $this->db->where_in('placement_master.fk_company', $company_ids);
//     }
    
//     if (!empty($year_id)) {
//     $this->db->where('placement_master.Financial_Year', $year_id);
// }


//     $query = $this->db->get();
//     return $query->result();
// }



public function getDataByInstitute($institute_id, $year_id, $branch_ids = [], $class_ids = [], $company_types = [], $company_categories = [], $company_ids = [], $div_ids = [], $ids = [], $salary_ids = [])
{
    $this->db->select('
        placement_master.*, 
        student_reg.FullName, 
        branch_master.branch_name, 
        classmaster.classname, 
        company_master.comp_name,
        designation_master.desig_name,
        company_category.category_name,
        company_type.Comp_type,
        division_master.div_name,
        placement_type.name
    ');
    $this->db->from('placement_master');
    $this->db->join('student_reg', 'student_reg.Student_id = placement_master.fk_student');
    $this->db->join('branch_master', 'branch_master.branch_id = placement_master.fk_branch', 'left ');
    $this->db->join('classmaster', 'classmaster.class_id = placement_master.fk_class', 'left');
    $this->db->join('company_master', 'company_master.ID = placement_master.fk_company', 'left');
    $this->db->join('designation_master', 'placement_master.fk_desig = designation_master.desig_id', 'left');
    $this->db->join('company_category', 'company_master.fk_comp_cat = company_category.compCat_id', 'left');
    $this->db->join('company_type', 'company_master.fk_comptype = company_type.Company_id', 'left');
  $this->db->join('division_master', 'placement_master.fk_div = division_master.div_id', 'left');
    $this->db->join('placement_type', 'placement_master.fk_place = placement_type.id', 'left');
    
        $this->db->order_by('placement_master.place_id','DESC');

    // Required base filters
    $this->db->where('placement_master.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('placement_master.fk_branch', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($class_ids)) {
        $this->db->where_in('placement_master.fk_class', $class_ids);
    }

    if (!empty($company_types)) {
        $this->db->where_in('company_master.fk_comptype', $company_types);
    }

    if (!empty($company_categories)) {
        $this->db->where_in('company_master.fk_comp_cat', $company_categories);
    }

    if (!empty($company_ids)) {
        $this->db->where_in('placement_master.fk_company', $company_ids);
    }

     if (!empty($div_ids)) {
        $this->db->where_in('placement_master.fk_div', $div_ids);
    }

     if (!empty($ids)) {
        $this->db->where_in('placement_master.fk_place', $ids);
    }

    if (!empty($year_id)) {
        $this->db->where('placement_master.Financial_Year', $year_id);
    }

    // ✅ Salary filter fix (safe and correct)
   // Salary filter fix with clone
if (!empty($salary_ids) && is_array($salary_ids)) {
    // Use a clone to avoid interfering with the main query
    $salary_db = clone $this->db;

    $salary_ranges = $salary_db
        ->select('mini_pack, max_pack')
        ->from('salary_master')
        ->where_in('salary_id', $salary_ids)
        ->get()
        ->result();

    if (!empty($salary_ranges)) {
        $this->db->group_start(); // open OR group

        foreach ($salary_ranges as $range) {
            if (!empty($range->mini_pack) && !empty($range->max_pack)) {
                $this->db->or_group_start()
                    ->where('placement_master.salary_package >=', $range->mini_pack)
                    ->where('placement_master.salary_package <=', $range->max_pack)
                    ->group_end();
            }
        }

        $this->db->group_end(); // close OR group
    }
}



    // ✅ Now safely run get()
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

     // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("placement_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = placement_master.Financial_Year")
        ->group_by("placement_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("placement_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = placement_master.Financial_Year")
//         ->where("placement_master.Financial_Year", $yearId)
//         ->group_by("placement_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("placement_master.place_id, placement_master.fk_student, finiyear_master.fini_Label as year, student_reg.FullName,")
//         ->from("placement_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = placement_master.Financial_Year")
//         ->join('student_reg', 'student_reg.Student_id = placement_master.fk_student')
//         ->where("placement_master.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 

public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("placement_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = placement_master.Financial_Year")
        ->where("placement_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('placement_master.fk_branch', (array)$branches);
    }
  
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('placement_master.fk_branch', explode(',', $branchIds));
    }
}

 
    $this->db->group_by("placement_master.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("placement_master.place_id, placement_master.fk_student, finiyear_master.fini_Label as year,student_reg.FullName,")
        ->from("placement_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = placement_master.Financial_Year")
                ->join('student_reg', 'student_reg.Student_id = placement_master.fk_student')
        ->where("placement_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('placement_master.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('placement_master.fk_branch', explode(',', $branchIds));
    }
}

 
    return $this->db->get()->result_array();
}
 


  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(placement_master.place_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('placement_master', 'branch_master.branch_id = placement_master.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('placement_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    else{
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!is_array($branchIds)) {
        $branchIds = explode(',', $branchIds);
    }

    $this->db->where_in('branch_master.branch_id', $branchIds);
}


    if (!empty($year) && $year != 0) {
        $this->db->where('placement_master.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('placement_master.fk_student,
                       placement_master.place_id,
                       placement_master.fk_branch,
                       branch_master.branch_name,
                        student_reg.FullName,');
    $this->db->from('placement_master');
    $this->db->join('branch_master', 'branch_master.branch_id = placement_master.fk_branch', 'left');
     $this->db->join('student_reg', 'student_reg.Student_id = placement_master.fk_student');

   if (is_array($branch_id)) {
    $this->db->where_in('placement_master.fk_branch', $branch_id);
} else {
    $this->db->where('placement_master.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('placement_master.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('placement_master.Financial_Year', $year);
    // }

    if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('placement_master.Financial_Year', $year);
    } else {
        $this->db->where('placement_master.Financial_Year', $year);
    }
}
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("placement_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.place_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('placement_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    else{
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.place_id) as count");
    $this->db->from("placement_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
    else{
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
 
 

}