<!-- Include CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.4.0/css/fixedHeader.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Include JS -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/fixedheader/3.4.0/js/dataTables.fixedHeader.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>

<style>
.table {
    color: #030b14;
    font-size: .725rem;
    border-color: #e8edf3;
}
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                <div class="card">
                    <div class="card-header">
                        <div class="card-title text-center w-100" style="text-decoration: underline;font-size:20px !important">Leave Details</div>
                    </div>

                    <div class="mb-3 text-center">
                        <button class="btn btn-sm" onclick="filterHOD('0')" style="background-color: yellow;">Processing</button>
                        <button class="btn btn-sm" onclick="filterHOD('1')" style="background-color: lightgreen;">Approved</button>
                        <button class="btn btn-sm" onclick="filterHOD('2')" style="background-color: lightcoral;">Rejected</button>
                        <!-- <button class="btn btn-secondary btn-sm" onclick="filterHOD('all')">Clear Filter</button> -->
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="leaveTable" class="table custom-table datatable-init">
                                <thead>
                                    <tr>
                                        <th>Action</th>
                                        <th>ID</th>
                                        <th>Faculty Name</th>
                                        <th>Alternative Faculty</th>
                                        <th>Branch Name</th>
                                        <th>Leave Type</th>
                                        <th>From Date</th>
                                        <th>To Date</th>
                                        <th>Leave Apply Date</th>
                                        <th>Approved Days</th>
                                        <th>Apply Days</th>
                                        <th>Reason</th>
                                        <th>HOD Approval</th>
                                        <th>Reg Approval</th>
                                        <th>Princ Approval</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    foreach($alldata as $value){
                                        $hod = (int)$value->HOD_Approval;
                                        $reg = (int)$value->REG_Approval;
                                        $princ = (int)$value->Princ_Approval;

                                        echo "<tr data-hod='$hod'>";
                                        echo "<td><a href='".base_url()."Heads/Leave/updateverify/{$value->LeaveApp_id}'><i class='fas fa-eye' style='font-size: 16px;'></i></a></td>";
                                        echo "<td>$value->LeaveApp_id</td>";
                                        echo "<td>$value->facname1</td>";
                                        echo "<td>$value->facname2</td>";
                                        echo "<td>$value->branch_name</td>";
                                        echo "<td>$value->leave_name</td>";
                                        echo "<td>" . date("d-m-Y", strtotime($value->Leave_from)) . "</td>";
                                        echo "<td>" . date("d-m-Y", strtotime($value->Leave_to)) . "</td>";
                                        echo "<td>" . date("d-m-Y", strtotime($value->created_date)) . "</td>";
                                        echo "<td>$value->No_of_days</td>";
                                        echo "<td>$value->ApprovedDays</td>";
                                        echo "<td>$value->Leave_Reas</td>";

                                        $hodText = $hod == 0 ? "Processing" : ($hod == 1 ? "Approved" : "Rejected");
                                        $hodColor = $hod == 0 ? "yellow" : ($hod == 1 ? "lightgreen" : "lightcoral");
                                        echo "<td style='background-color:$hodColor;text-align:center;'>$hodText</td>";

                                        $regText = $reg == 0 ? "Processing" : ($reg == 1 ? "Approved" : "Rejected");
                                        $regColor = $reg == 0 ? "yellow" : ($reg == 1 ? "lightgreen" : "lightcoral");
                                        echo "<td style='background-color:$regColor;text-align:center;'>$regText</td>";

                                        $princText = $princ == 0 ? "Processing" : ($princ == 1 ? "Approved" : "Rejected");
                                        $princColor = $princ == 0 ? "yellow" : ($princ == 1 ? "lightgreen" : "lightcoral");
                                        echo "<td style='background-color:$princColor;text-align:center;'>$princText</td>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- DataTables init + filter script -->
<script>
let leaveTable;

$(document).ready(function () {
    leaveTable = $('#leaveTable').DataTable({
        scrollX: true,
        fixedHeader: true,
        pageLength: 10,
        responsive: true
    });
});

function filterHOD(status) {
    leaveTable.rows().every(function () {
        let row = $(this.node());
        let hod = row.data('hod');
        if (status === 'all' || hod == status) {
            row.show();
        } else {
            row.hide();
        }
    });
}
</script>
